/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/intellij/util/ui/ListUiUtil;", "", "()V", "Selection", "WithTallRow", "intellij.platform.util.ui"})
public final class ListUiUtil {
    @NotNull
    public static final ListUiUtil INSTANCE;

    private ListUiUtil() {
    }

    static {
        ListUiUtil listUiUtil;
        INSTANCE = listUiUtil = new ListUiUtil();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\"\u0010\f\u001a\u00020\b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001a\u0010\u0010\u001a\u00020\b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/ui/ListUiUtil$WithTallRow;", "", "()V", "alternativeRowBackground", "Lcom/intellij/ui/JBColor;", "selectionBackground", "unfocusedSelectionBackground", "alternativeBackground", "Ljava/awt/Color;", "isSelected", "", "hasFocus", "background", "list", "Ljavax/swing/JList;", "foreground", "secondaryForeground", "intellij.platform.util.ui"})
    public static final class WithTallRow {
        private static final JBColor selectionBackground;
        private static final JBColor unfocusedSelectionBackground;
        private static final JBColor alternativeRowBackground;
        @NotNull
        public static final WithTallRow INSTANCE;

        @NotNull
        public final Color foreground(boolean isSelected, boolean hasFocus) {
            Color color;
            Color color2 = UIUtil.getListForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.getListForeground()");
            Color color3 = color2;
            if (isSelected) {
                JBColor jBColor = hasFocus ? JBColor.namedColor("Table.lightSelectionForeground", color3) : JBColor.namedColor("Table.lightSelectionInactiveForeground", color3);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"if (hasFocus) JBColor.na\u2026tiveForeground\", default)");
                color = jBColor;
            } else {
                JBColor jBColor = JBColor.namedColor("Table.foreground", color3);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"Table.foreground\", default)");
                color = jBColor;
            }
            return color;
        }

        @NotNull
        public final Color secondaryForeground(@NotNull JList<?> list, boolean isSelected) {
            Color color;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (isSelected) {
                color = this.foreground(true, list.hasFocus());
            } else {
                JBColor jBColor = JBColor.namedColor("Component.infoForeground", UIUtil.getContextHelpForeground());
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"Comp\u2026tContextHelpForeground())");
                color = jBColor;
            }
            return color;
        }

        @NotNull
        public final Color background(@NotNull JList<?> list, boolean isSelected, boolean hasFocus) {
            Color color;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (isSelected) {
                JBColor jBColor = hasFocus ? JBColor.namedColor("Table.lightSelectionBackground", selectionBackground) : JBColor.namedColor("Table.lightSelectionInactiveBackground", unfocusedSelectionBackground);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"if (hasFocus) JBColor.na\u2026cusedSelectionBackground)");
                color = jBColor;
            } else {
                Color color2 = list.getBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"list.background");
            }
            return color;
        }

        @NotNull
        public final Color alternativeBackground(boolean isSelected, boolean hasFocus) {
            Color color;
            if (isSelected) {
                JBColor jBColor = hasFocus ? JBColor.namedColor("Table.lightSelectionBackground", selectionBackground) : JBColor.namedColor("Table.lightSelectionInactiveBackground", unfocusedSelectionBackground);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"if (hasFocus) JBColor.na\u2026cusedSelectionBackground)");
                color = jBColor;
            } else {
                JBColor jBColor = JBColor.namedColor("Table.alternativeRowBackground", alternativeRowBackground);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"Tabl\u2026alternativeRowBackground)");
                color = jBColor;
            }
            return color;
        }

        private WithTallRow() {
        }

        static {
            WithTallRow withTallRow;
            INSTANCE = withTallRow = new WithTallRow();
            selectionBackground = new JBColor(15595262, 4606541);
            unfocusedSelectionBackground = new JBColor(0xF5F5F5, 4606541);
            alternativeRowBackground = new JBColor(0xFFFFFF, 0x313335);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/util/ui/ListUiUtil$Selection;", "", "()V", "installSelectionOnFocus", "Ljava/awt/event/FocusListener;", "list", "Ljavax/swing/JList;", "installSelectionOnRightClick", "Ljava/awt/event/MouseListener;", "intellij.platform.util.ui"})
    public static final class Selection {
        @NotNull
        public static final Selection INSTANCE;

        @NotNull
        public final FocusListener installSelectionOnFocus(@NotNull JList<?> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            FocusListener listener2 = new FocusAdapter(list){
                final /* synthetic */ JList $list;

                public void focusGained(@NotNull FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (this.$list.isSelectionEmpty()) {
                        ListModel<E> listModel = this.$list.getModel();
                        Intrinsics.checkNotNullExpressionValue(listModel, (String)"list.model");
                        if (listModel.getSize() > 0) {
                            this.$list.setSelectedIndex(0);
                        }
                    }
                }
                {
                    this.$list = $captured_local_variable$0;
                }
            };
            list.addFocusListener(listener2);
            return listener2;
        }

        @NotNull
        public final MouseListener installSelectionOnRightClick(@NotNull JList<?> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            MouseListener listener2 = new MouseAdapter(list){
                final /* synthetic */ JList $list;

                public void mousePressed(@NotNull MouseEvent e) {
                    int row;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (SwingUtilities.isRightMouseButton(e) && (row = this.$list.locationToIndex(e.getPoint())) != -1) {
                        this.$list.setSelectedIndex(row);
                    }
                }
                {
                    this.$list = $captured_local_variable$0;
                }
            };
            list.addMouseListener(listener2);
            return listener2;
        }

        private Selection() {
        }

        static {
            Selection selection;
            INSTANCE = selection = new Selection();
        }
    }
}

