/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.ByteRange;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.FileResponsesKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"c\u0010\u0003\u001aJ\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00050\u0005 \u0002*#\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00050\u00050\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"RANGE_HEADER", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "fileExtToMimeType", "", "", "Lorg/jetbrains/annotations/NotNull;", "", "getFileExtToMimeType", "()Ljava/util/Map;", "fileExtToMimeType$delegate", "Lkotlin/Lazy;", "flushChunkedResponse", "", "channel", "Lio/netty/channel/Channel;", "isKeepAlive", "", "parseRange", "Lorg/jetbrains/io/ByteRange;", "header", "size", "", "intellij.platform.ide.util.netty"})
public final class FileResponsesKt {
    private static final Lazy fileExtToMimeType$delegate = LazyKt.lazy((Function0)fileExtToMimeType.2.INSTANCE);
    private static final Pattern RANGE_HEADER = Pattern.compile("bytes=(\\d+)?-(\\d+)?");

    public static final void flushChunkedResponse(@NotNull Channel channel, boolean isKeepAlive) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!isKeepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static final Map<String, String> getFileExtToMimeType() {
        Lazy lazy = fileExtToMimeType$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    private static final ByteRange parseRange(String header, long size) {
        ByteRange byteRange;
        CharSequence charSequence = header;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        Matcher m = RANGE_HEADER.matcher(header);
        if (!m.matches()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FileResponses.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Range header is invalid: " + header);
            return null;
        }
        CharSequence $i$f$logger = m.group(1);
        bl2 = false;
        boolean bl3 = false;
        if ($i$f$logger == null || $i$f$logger.length() == 0) {
            String string2 = m.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"m.group(2)");
            $i$f$logger = string2;
            bl2 = false;
            return new ByteRange(size - Long.parseLong((String)$i$f$logger), size);
        }
        String string3 = m.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"m.group(1)");
        String string4 = string3;
        boolean bl4 = false;
        long start = Long.parseLong(string4);
        long end = 0L;
        CharSequence charSequence2 = m.group(2);
        boolean bl5 = false;
        boolean bl6 = false;
        if (charSequence2 == null || charSequence2.length() == 0) {
            end = size - 1L;
        } else {
            String string5 = m.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"m.group(2)");
            charSequence2 = string5;
            bl5 = false;
            end = Long.parseLong((String)charSequence2);
        }
        if (end < start) {
            boolean $i$f$logger2 = false;
            Logger logger = Logger.getInstance(FileResponses.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("start (" + start + ") must be greater than end (" + end + ')');
            byteRange = null;
        } else if (end >= size) {
            boolean $i$f$logger3 = false;
            Logger logger = Logger.getInstance(FileResponses.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("end (" + end + ") must be lesser than size (" + size + ')');
            byteRange = null;
        } else {
            byteRange = new ByteRange(start, end + 1L);
        }
        return byteRange;
    }

    public static final /* synthetic */ Map access$getFileExtToMimeType$p() {
        return FileResponsesKt.getFileExtToMimeType();
    }

    public static final /* synthetic */ ByteRange access$parseRange(String header, long size) {
        return FileResponsesKt.parseRange(header, size);
    }
}

