/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0013\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0006\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u0018\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u0019\u001a\u00020\u0015*\u00020\u0006\u001a\"\u0010\f\u001a\u00020\u0006*\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u001a*\u0010\u001a\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007\u001a\u001a\u0010\u001a\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0017\u001a8\u0010\u001a\u001a\u00020\u0015*\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007\"\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006 "}, d2={"SERVER_HEADER_VALUE", "", "serverHeaderValue", "getServerHeaderValue", "()Ljava/lang/String;", "createStatusResponse", "Lio/netty/handler/codec/http/HttpResponse;", "responseStatus", "Lio/netty/handler/codec/http/HttpResponseStatus;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "description", "response", "Lio/netty/handler/codec/http/FullHttpResponse;", "content", "", "charset", "Ljava/nio/charset/Charset;", "contentType", "Lio/netty/buffer/ByteBuf;", "addCommonHeaders", "", "addKeepAliveIfNeeded", "", "addNoCache", "addServer", "send", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "close", "intellij.platform.ide.util.netty"})
@JvmName(name="Responses")
public final class Responses {
    private static String SERVER_HEADER_VALUE;

    @NotNull
    public static final FullHttpResponse response(@Nullable String contentType, @Nullable ByteBuf content) {
        DefaultFullHttpResponse response;
        DefaultFullHttpResponse defaultFullHttpResponse = response = content == null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        if (contentType != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
        return (FullHttpResponse)response;
    }

    @NotNull
    public static final FullHttpResponse response(@NotNull CharSequence content, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)content, (Charset)charset));
    }

    public static /* synthetic */ FullHttpResponse response$default(CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset2 = CharsetUtil.US_ASCII;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"CharsetUtil.US_ASCII");
            charset = charset2;
        }
        return Responses.response(charSequence, charset);
    }

    @NotNull
    public static final HttpResponse addNoCache(@NotNull HttpResponse $this$addNoCache) {
        Intrinsics.checkNotNullParameter((Object)$this$addNoCache, (String)"$this$addNoCache");
        $this$addNoCache.headers().add((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache, no-store, must-revalidate, max-age=0");
        $this$addNoCache.headers().add((CharSequence)HttpHeaderNames.PRAGMA, (Object)"no-cache");
        return $this$addNoCache;
    }

    @Nullable
    public static final String getServerHeaderValue() {
        Application app;
        if (SERVER_HEADER_VALUE == null && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
            SERVER_HEADER_VALUE = applicationInfo.getFullApplicationName();
        }
        return SERVER_HEADER_VALUE;
    }

    public static final void addServer(@NotNull HttpResponse $this$addServer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$addServer, (String)"$this$addServer");
            String string2 = Responses.getServerHeaderValue();
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            $this$addServer.headers().add((CharSequence)HttpHeaderNames.SERVER, (Object)it);
        }
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponse $this$send, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"$this$send");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        if (Intrinsics.areEqual((Object)$this$send.status(), (Object)HttpResponseStatus.NOT_MODIFIED) ^ true && !HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)$this$send))) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)$this$send), (long)($this$send instanceof FullHttpResponse ? ((FullHttpResponse)$this$send).content().readableBytes() : 0));
        }
        Responses.addCommonHeaders($this$send);
        HttpHeaders httpHeaders = extraHeaders;
        if (httpHeaders != null) {
            HttpHeaders httpHeaders2 = httpHeaders;
            boolean bl = false;
            boolean bl2 = false;
            HttpHeaders it = httpHeaders2;
            boolean bl3 = false;
            $this$send.headers().add(it);
        }
        Responses.send($this$send, channel, request != null && !Responses.addKeepAliveIfNeeded($this$send, request));
    }

    public static /* synthetic */ void send$default(HttpResponse httpResponse, Channel channel, HttpRequest httpRequest, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 4) != 0) {
            httpHeaders = null;
        }
        Responses.send(httpResponse, channel, httpRequest, httpHeaders);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponse $this$send, @NotNull Channel channel, @Nullable HttpRequest request) {
        Responses.send$default($this$send, channel, request, null, 4, null);
    }

    public static final boolean addKeepAliveIfNeeded(@NotNull HttpResponse $this$addKeepAliveIfNeeded, @NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)$this$addKeepAliveIfNeeded, (String)"$this$addKeepAliveIfNeeded");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request))) {
            HttpUtil.setKeepAlive((HttpMessage)((HttpMessage)$this$addKeepAliveIfNeeded), (boolean)true);
            return true;
        }
        return false;
    }

    public static final void addCommonHeaders(@NotNull HttpResponse $this$addCommonHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$addCommonHeaders, (String)"$this$addCommonHeaders");
        Responses.addServer($this$addCommonHeaders);
        if (!$this$addCommonHeaders.headers().contains((CharSequence)HttpHeaderNames.DATE)) {
            HttpHeaders httpHeaders = $this$addCommonHeaders.headers();
            CharSequence charSequence = (CharSequence)HttpHeaderNames.DATE;
            Calendar calendar = Calendar.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance()");
            httpHeaders.set(charSequence, (Object)calendar.getTime());
        }
        if (!$this$addCommonHeaders.headers().contains((CharSequence)HttpHeaderNames.X_FRAME_OPTIONS)) {
            $this$addCommonHeaders.headers().set((CharSequence)HttpHeaderNames.X_FRAME_OPTIONS, (Object)"SameOrigin");
        }
        $this$addCommonHeaders.headers().set("X-Content-Type-Options", (Object)"nosniff");
        $this$addCommonHeaders.headers().set("x-xss-protection", (Object)"1; mode=block");
        if ($this$addCommonHeaders.status().compareTo(HttpResponseStatus.MULTIPLE_CHOICES) < 0) {
            $this$addCommonHeaders.headers().set((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (Object)"bytes");
        }
    }

    public static final void send(@NotNull HttpResponse $this$send, @NotNull Channel channel, boolean close2) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"$this$send");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        if (!channel.isActive()) {
            return;
        }
        ChannelFuture future = channel.write((Object)$this$send);
        if (!($this$send instanceof FullHttpResponse)) {
            channel.write((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        channel.flush();
        if (close2) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    @NotNull
    public static final HttpResponse response(@NotNull HttpResponseStatus $this$response, @Nullable HttpRequest request, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)$this$response, (String)"$this$response");
        return Responses.createStatusResponse($this$response, request, description);
    }

    public static /* synthetic */ HttpResponse response$default(HttpResponseStatus httpResponseStatus, HttpRequest httpRequest, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            httpRequest = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return Responses.response(httpResponseStatus, httpRequest, string2);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $this$send, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable String description, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"$this$send");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Responses.send(Responses.createStatusResponse($this$send, request, description), channel, request, extraHeaders);
    }

    public static /* synthetic */ void send$default(HttpResponseStatus httpResponseStatus, Channel channel, HttpRequest httpRequest, String string2, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 2) != 0) {
            httpRequest = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        Responses.send(httpResponseStatus, channel, httpRequest, string2, httpHeaders);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $this$send, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable String description) {
        Responses.send$default($this$send, channel, request, description, null, 8, null);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $this$send, @NotNull Channel channel, @Nullable HttpRequest request) {
        Responses.send$default($this$send, channel, request, null, null, 12, null);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $this$send, @NotNull Channel channel) {
        Responses.send$default($this$send, channel, null, null, null, 14, null);
    }

    @NotNull
    public static final HttpResponse createStatusResponse(@NotNull HttpResponseStatus responseStatus, @Nullable HttpRequest request, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)responseStatus, (String)"responseStatus");
        if (request != null && Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.HEAD)) {
            return (HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.EMPTY_BUFFER);
        }
        StringBuilder builder = new StringBuilder();
        String string2 = responseStatus.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"responseStatus.toString()");
        String message = string2;
        builder.append("<!doctype html><title>").append(message).append("</title>").append("<h1 style=\"text-align: center\">").append(message).append("</h1>");
        if (description != null) {
            builder.append("<p>").append(description).append("</p>");
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(builder), (Charset)Charsets.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        return (HttpResponse)response;
    }

    public static /* synthetic */ HttpResponse createStatusResponse$default(HttpResponseStatus httpResponseStatus, HttpRequest httpRequest, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return Responses.createStatusResponse(httpResponseStatus, httpRequest, string2);
    }
}

