/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.Period;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBePeriod;
import org.assertj.core.error.ShouldHavePeriod;
import org.assertj.core.internal.Failures;

public abstract class AbstractPeriodAssert<SELF extends AbstractPeriodAssert<SELF>>
extends AbstractAssert<SELF, Period> {
    protected AbstractPeriodAssert(Period period, Class<?> selfType) {
        super(period, selfType);
    }

    public SELF hasYears(int expectedYears) {
        this.isNotNull();
        int actualYears = ((Period)this.actual).getYears();
        if (expectedYears != actualYears) {
            throw Failures.instance().failure(this.info, ShouldHavePeriod.shouldHaveYears((Period)this.actual, actualYears, expectedYears), actualYears, expectedYears);
        }
        return (SELF)((AbstractPeriodAssert)this.myself);
    }

    public SELF hasMonths(int expectedMonths) {
        this.isNotNull();
        int actualMonths = ((Period)this.actual).getMonths();
        if (expectedMonths != actualMonths) {
            throw Failures.instance().failure(this.info, ShouldHavePeriod.shouldHaveMonths((Period)this.actual, actualMonths, expectedMonths), actualMonths, expectedMonths);
        }
        return (SELF)((AbstractPeriodAssert)this.myself);
    }

    public SELF hasDays(int expectedDays) {
        this.isNotNull();
        int actualDays = ((Period)this.actual).getDays();
        if (expectedDays != actualDays) {
            throw Failures.instance().failure(this.info, ShouldHavePeriod.shouldHaveDays((Period)this.actual, actualDays, expectedDays), actualDays, expectedDays);
        }
        return (SELF)((AbstractPeriodAssert)this.myself);
    }

    public SELF isPositive() {
        this.isNotNull();
        boolean negative = ((Period)this.actual).isNegative();
        if (negative || Period.ZERO.equals(this.actual)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBePeriod.shouldBePositive((Period)this.actual));
        }
        return (SELF)((AbstractPeriodAssert)this.myself);
    }

    public SELF isNegative() {
        this.isNotNull();
        boolean negative = ((Period)this.actual).isNegative();
        if (!negative || Period.ZERO.equals(this.actual)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBePeriod.shouldBeNegative((Period)this.actual));
        }
        return (SELF)((AbstractPeriodAssert)this.myself);
    }
}

