/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.Assert;
import org.assertj.core.api.AssertJProxySetup;
import org.assertj.core.api.AssertionErrorCollector;
import org.assertj.core.api.ClassLoadingStrategyFactory;
import org.assertj.core.api.ErrorCollector;
import org.assertj.core.api.IterableSizeAssert;
import org.assertj.core.api.MapSizeAssert;
import org.assertj.core.api.ProxifyMethodChangingTheObjectUnderTest;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.internal.bytebuddy.ByteBuddy;
import org.assertj.core.internal.bytebuddy.TypeCache;
import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.description.modifier.Visibility;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.TypeValidation;
import org.assertj.core.internal.bytebuddy.implementation.FieldAccessor;
import org.assertj.core.internal.bytebuddy.implementation.Implementation;
import org.assertj.core.internal.bytebuddy.implementation.MethodDelegation;
import org.assertj.core.internal.bytebuddy.implementation.auxiliary.AuxiliaryType;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;

class SoftProxies {
    private static final ElementMatcher.Junction<MethodDescription> METHODS_CHANGING_THE_OBJECT_UNDER_TEST = SoftProxies.methodsChangingTheObjectUnderTestNamed("asInstanceOf", "asList", "asString", "asHexString", "decodedAsBase64", "encodedAsBase64", "extracting", "extractingByKey", "extractingByKeys", "extractingFromEntries", "extractingResultOf", "filteredOn", "filteredOnAssertions", "filteredOnNull", "flatExtracting", "flatMap", "get", "getCause", "getRootCause", "map", "newAbstractIterableAssert", "size", "succeedsWithin", "toAssert", "usingRecursiveComparison");
    private static final ElementMatcher.Junction<MethodDescription> METHODS_NOT_TO_PROXY = SoftProxies.methodsNamed("as").or(ElementMatchers.named("clone")).or(ElementMatchers.named("describedAs")).or(ElementMatchers.named("descriptionText")).or(ElementMatchers.named("getWritableAssertionInfo")).or(ElementMatchers.named("inBinary")).or(ElementMatchers.named("inHexadecimal")).or(ElementMatchers.named("newAbstractIterableAssert")).or(ElementMatchers.named("newObjectArrayAssert")).or(ElementMatchers.named("overridingErrorMessage")).or(ElementMatchers.named("removeCustomAssertRelatedElementsFromStackTraceIfNeeded")).or(ElementMatchers.named("succeedsWithin")).or(ElementMatchers.named("failsWithin")).or(ElementMatchers.named("usingComparator")).or(ElementMatchers.named("usingDefaultComparator")).or(ElementMatchers.named("usingElementComparator")).or(ElementMatchers.named("withAssertionInfo")).or(ElementMatchers.named("withAssertionState")).or(ElementMatchers.named("withComparatorsForElementPropertyOrFieldNames")).or(ElementMatchers.named("withComparatorsForElementPropertyOrFieldTypes")).or(ElementMatchers.named("withFailMessage")).or(ElementMatchers.named("withIterables")).or(ElementMatchers.named("withRepresentation")).or(ElementMatchers.named("withThreadDumpOnError")).or(ElementMatchers.named("withTypeComparators"));
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy().with(new AuxiliaryType.NamingStrategy.SuffixingRandom("AssertJ$SoftProxies")).with(TypeValidation.DISABLED);
    private static final Implementation PROXIFY_METHOD_CHANGING_THE_OBJECT_UNDER_TEST = MethodDelegation.to(ProxifyMethodChangingTheObjectUnderTest.class);
    private static final Implementation ERROR_COLLECTOR = MethodDelegation.to(ErrorCollector.class);
    private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction<TypeCache.SimpleKey>(TypeCache.Sort.SOFT);
    private ErrorCollector collector;

    public SoftProxies(AssertionErrorCollector assertionErrorCollector) {
        this.collector = new ErrorCollector(assertionErrorCollector);
    }

    <SELF extends Assert<? extends SELF, ? extends ACTUAL>, ACTUAL> SELF createSoftAssertionProxy(Class<SELF> assertClass, Class<ACTUAL> actualClass, ACTUAL actual) {
        try {
            Class<SELF> proxyClass = SoftProxies.createSoftAssertionProxyClass(assertClass);
            Constructor<SELF> constructor = proxyClass.getConstructor(actualClass);
            Assert proxiedAssert = (Assert)constructor.newInstance(actual);
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return (SELF)proxiedAssert;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <ASSERT extends Assert<?, ?>> Class<ASSERT> createSoftAssertionProxyClass(Class<ASSERT> assertClass) {
        TypeCache.SimpleKey cacheKey = new TypeCache.SimpleKey(assertClass, new Class[0]);
        return CACHE.findOrInsert(assertClass.getClassLoader(), cacheKey, () -> SoftProxies.generateProxyClass(assertClass));
    }

    IterableSizeAssert<?> createIterableSizeAssertProxy(IterableSizeAssert<?> iterableSizeAssert) {
        Class<IterableSizeAssert> proxyClass = SoftProxies.createSoftAssertionProxyClass(IterableSizeAssert.class);
        try {
            Constructor<IterableSizeAssert> constructor = proxyClass.getConstructor(AbstractIterableAssert.class, Integer.class);
            IterableSizeAssert proxiedAssert = constructor.newInstance(iterableSizeAssert.returnToIterable(), iterableSizeAssert.actual);
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    MapSizeAssert<?, ?> createMapSizeAssertProxy(MapSizeAssert<?, ?> mapSizeAssert) {
        Class<MapSizeAssert> proxyClass = SoftProxies.createSoftAssertionProxyClass(MapSizeAssert.class);
        try {
            Constructor<MapSizeAssert> constructor = proxyClass.getConstructor(AbstractMapAssert.class, Integer.class);
            MapSizeAssert proxiedAssert = constructor.newInstance(mapSizeAssert.returnToMap(), mapSizeAssert.actual);
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    RecursiveComparisonAssert<?> createRecursiveComparisonAssertProxy(RecursiveComparisonAssert<?> recursiveComparisonAssert) {
        Class<RecursiveComparisonAssert> proxyClass = SoftProxies.createSoftAssertionProxyClass(RecursiveComparisonAssert.class);
        try {
            Constructor<RecursiveComparisonAssert> constructor = proxyClass.getConstructor(Object.class, RecursiveComparisonConfiguration.class);
            RecursiveComparisonAssert proxiedAssert = constructor.newInstance(recursiveComparisonAssert.actual, recursiveComparisonAssert.getRecursiveComparisonConfiguration());
            ((AssertJProxySetup)((Object)proxiedAssert)).assertj$setup(new ProxifyMethodChangingTheObjectUnderTest(this), this.collector);
            return proxiedAssert;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static <V> Class<? extends V> generateProxyClass(Class<V> assertClass) {
        ClassLoadingStrategyFactory.ClassLoadingStrategyPair strategy = ClassLoadingStrategyFactory.classLoadingStrategy(assertClass);
        return BYTE_BUDDY.subclass(assertClass).defineField("dispatcher", (Type)((Object)ProxifyMethodChangingTheObjectUnderTest.class), Visibility.PRIVATE).method(METHODS_CHANGING_THE_OBJECT_UNDER_TEST).intercept(PROXIFY_METHOD_CHANGING_THE_OBJECT_UNDER_TEST).defineField("errorCollector", (Type)((Object)ErrorCollector.class), Visibility.PRIVATE).method(ElementMatchers.any().and(ElementMatchers.not(METHODS_CHANGING_THE_OBJECT_UNDER_TEST)).and(ElementMatchers.not(METHODS_NOT_TO_PROXY))).intercept(ERROR_COLLECTOR).implement(new Type[]{AssertJProxySetup.class}).intercept(FieldAccessor.ofField("dispatcher").setsArgumentAt(0).andThen(FieldAccessor.ofField("errorCollector").setsArgumentAt(1))).make().load(strategy.getClassLoader(), strategy.getClassLoadingStrategy()).getLoaded();
    }

    private static ElementMatcher.Junction<MethodDescription> methodsNamed(String ... names) {
        return ElementMatchers.namedOneOf(names);
    }

    private static ElementMatcher.Junction<MethodDescription> methodsChangingTheObjectUnderTestNamed(String ... names) {
        ElementMatcher.Junction publicMethods = ElementMatchers.namedOneOf(names).and(ElementMatchers.isPublic());
        String[] forProxyMethodNames = (String[])Stream.of(names).map(name -> name + "ForProxy").toArray(String[]::new);
        ElementMatcher.Junction forProxyProtectedMethods = ElementMatchers.namedOneOf(forProxyMethodNames).and(ElementMatchers.isProtected());
        return publicMethods.or(forProxyProtectedMethods);
    }
}

