/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.configuration;

import org.assertj.core.configuration.Configuration;
import org.assertj.core.configuration.Services;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;

public final class ConfigurationProvider {
    public static final ConfigurationProvider CONFIGURATION_PROVIDER = new ConfigurationProvider();
    private final Representation representation = Services.get(Representation.class, StandardRepresentation.STANDARD_REPRESENTATION);
    private final Configuration configuration;

    private ConfigurationProvider() {
        if (this.representation != StandardRepresentation.STANDARD_REPRESENTATION) {
            System.err.println(String.format("Although it still works, registering a Representation through a file named 'org.assertj.core.presentation.Representation' in the META-INF/services directory is deprecated.%nThe proper way of providing a Representation is to register a Configuration as described in the documentation (a Configuration allowing to provide a Representation and other AssertJ configuration elements)", new Object[0]));
        }
        this.configuration = Services.get(Configuration.class, Configuration.DEFAULT_CONFIGURATION);
        if (this.configuration != Configuration.DEFAULT_CONFIGURATION) {
            this.configuration.applyAndDisplay();
        }
    }

    public Representation representation() {
        return this.configuration.hasCustomRepresentation() ? this.configuration.representation() : this.representation;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public static void loadRegisteredConfiguration() {
    }
}

