/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.designSurface.DraggedComponentList;
import com.intellij.uiDesigner.designSurface.EventProcessor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class DragSelectionProcessor
extends EventProcessor {
    private static final Logger LOG = Logger.getInstance(DragSelectionProcessor.class);
    public static final int TREMOR = 3;
    private final GuiEditor myEditor;
    private Point myPressPoint;
    private boolean myDragStarted;
    private final MyDragGestureRecognizer myDragGestureRecognizer;
    private final MyDragSourceListener myDragSourceListener;

    public DragSelectionProcessor(@NotNull GuiEditor editor) {
        if (editor == null) {
            DragSelectionProcessor.$$$reportNull$$$0(0);
        }
        this.myDragSourceListener = new MyDragSourceListener();
        this.myEditor = editor;
        this.myDragGestureRecognizer = new MyDragGestureRecognizer(DragSource.getDefaultDragSource(), this.myEditor.getActiveDecorationLayer(), 3);
    }

    @Override
    public boolean isDragActive() {
        return this.myDragStarted;
    }

    @Override
    protected boolean cancelOperation() {
        if (!this.myDragStarted) {
            return true;
        }
        this.myEditor.setDesignTimeInsets(2);
        this.myEditor.getActiveDecorationLayer().removeFeedback();
        this.myEditor.repaintLayeredPane();
        return true;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.myPressPoint = e.getPoint();
        } else if (e.getID() == 502) {
            RadComponent component;
            if (!this.myDragStarted && (component = FormEditingUtil.getRadComponentAt(this.myEditor.getRootContainer(), e.getX(), e.getY())) != null && UIUtil.isControlKeyDown((MouseEvent)e)) {
                component.setSelected(!component.isSelected());
            }
        } else if (e.getID() == 506 && !this.myDragStarted && (Math.abs((double)e.getX() - this.myPressPoint.getX()) > 3.0 || Math.abs((double)e.getY() - this.myPressPoint.getY()) > 3.0)) {
            ArrayList<MouseEvent> eventList = new ArrayList<MouseEvent>();
            eventList.add(e);
            this.myDragGestureRecognizer.setTriggerEvent(e);
            DragGestureEvent dge = new DragGestureEvent(this.myDragGestureRecognizer, UIUtil.isControlKeyDown((MouseEvent)e) ? 1 : 2, this.myPressPoint, eventList);
            this.myDragStarted = true;
            this.myEditor.getDropTargetListener().setUseDragDelta(true);
            dge.startDrag(null, DraggedComponentList.pickupSelection(this.myEditor, e.getPoint()), this.myDragSourceListener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/designSurface/DragSelectionProcessor", "<init>"));
    }

    private class MyDragSourceListener
    extends DragSourceAdapter {
        private MyDragSourceListener() {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            int shiftDownMask = dsde.getGestureModifiersEx() & 0x40;
            if (shiftDownMask != 0) {
                DragSelectionProcessor.this.myEditor.setDesignTimeInsets(12);
            } else {
                DragSelectionProcessor.this.myEditor.setDesignTimeInsets(2);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragSelectionProcessor.this.myDragStarted = false;
            DragSelectionProcessor.this.myEditor.getDropTargetListener().setUseDragDelta(false);
            DragSelectionProcessor.this.myEditor.setDesignTimeInsets(2);
        }
    }

    private static class MyDragGestureRecognizer
    extends DragGestureRecognizer {
        MyDragGestureRecognizer(DragSource ds, Component c, int sa) {
            super(ds, c, sa);
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }

        public void setTriggerEvent(MouseEvent e) {
            this.resetRecognizer();
            this.appendEvent(e);
        }
    }
}

