/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.componentTree.ComponentSelectionListener;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyEditorListener;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.MathUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InplaceEditingLayer
extends JComponent {
    private static final Logger LOG = Logger.getInstance(InplaceEditingLayer.class);
    private final GuiEditor myEditor;
    private final MyFocusWatcher myFocusWatcher;
    private final MyPropertyEditorListener myPropertyEditorListener;
    private RadComponent myInplaceComponent;
    private Property myInplaceProperty;
    private PropertyEditor myInplaceEditor;
    private JComponent myInplaceEditorComponent;
    private Rectangle myPreferredBounds;
    private boolean myInsideChange;

    public InplaceEditingLayer(@NotNull GuiEditor editor) {
        if (editor == null) {
            InplaceEditingLayer.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
        this.myEditor.addComponentSelectionListener(new MyComponentSelectionListener());
        this.myFocusWatcher = new MyFocusWatcher();
        this.myPropertyEditorListener = new MyPropertyEditorListener();
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.myInplaceComponent != null && (501 == e.getID() || 502 == e.getID())) {
            this.finishInplaceEditing();
        }
        super.processMouseEvent(e);
    }

    public boolean isEditing() {
        return this.myInplaceComponent != null;
    }

    public void startInplaceEditing(int x, int y) {
        RadComponent inplaceComponent = FormEditingUtil.getRadComponentAt(this.myEditor.getRootContainer(), x, y);
        if (inplaceComponent == null) {
            return;
        }
        Point p = SwingUtilities.convertPoint(this, x, y, inplaceComponent.getDelegee());
        Property inplaceProperty = inplaceComponent.getInplaceProperty(p.x, p.y);
        if (inplaceProperty != null) {
            Rectangle bounds = inplaceComponent.getInplaceEditorBounds(inplaceProperty, p.x, p.y);
            this.startInplaceEditing(inplaceComponent, inplaceProperty, bounds, new InplaceContext(true));
        }
    }

    public void startInplaceEditing(@NotNull RadComponent inplaceComponent, @Nullable Property property, @Nullable Rectangle bounds, InplaceContext context) {
        Point _p;
        if (inplaceComponent == null) {
            InplaceEditingLayer.$$$reportNull$$$0(1);
        }
        this.myInplaceProperty = property;
        if (this.myInplaceProperty == null) {
            return;
        }
        if (!this.myEditor.ensureEditable()) {
            this.myInplaceProperty = null;
            return;
        }
        this.myInplaceComponent = inplaceComponent;
        this.myInplaceEditor = this.myInplaceProperty.getEditor();
        LOG.assertTrue(this.myInplaceEditor != null);
        this.myInplaceEditorComponent = this.myInplaceEditor.getComponent(this.myInplaceComponent, context.isKeepInitialValue() ? (Object)this.myInplaceProperty.getValue(this.myInplaceComponent) : null, context);
        if (context.isModalDialogDisplayed()) {
            this.finishInplaceEditing();
            return;
        }
        LOG.assertTrue(this.myInplaceEditorComponent != null);
        this.myInplaceEditor.addPropertyEditorListener(this.myPropertyEditorListener);
        Dimension prefSize = this.myInplaceEditorComponent.getPreferredSize();
        if (bounds != null) {
            _p = SwingUtilities.convertPoint(this.myInplaceComponent.getDelegee(), bounds.x, bounds.y, this);
            this.myPreferredBounds = new Rectangle(_p.x, _p.y, bounds.width, bounds.height);
        } else {
            _p = SwingUtilities.convertPoint(this.myInplaceComponent.getDelegee(), 0, 0, this);
            this.myPreferredBounds = new Rectangle(_p.x, _p.y, this.myInplaceComponent.getWidth(), this.myInplaceComponent.getHeight());
        }
        this.myInplaceEditorComponent.setBounds(this.myPreferredBounds.x, this.myPreferredBounds.y + (this.myPreferredBounds.height - prefSize.height) / 2, MathUtil.clamp((int)prefSize.width, (int)this.myPreferredBounds.width, (int)(this.getWidth() - this.myPreferredBounds.x)), prefSize.height);
        this.add(this.myInplaceEditorComponent);
        this.myInplaceEditorComponent.revalidate();
        JComponent componentToFocus = this.myInplaceEditor.getPreferredFocusedComponent(this.myInplaceEditorComponent);
        if (componentToFocus == null) {
            componentToFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.myInplaceEditorComponent);
        }
        if (componentToFocus == null) {
            componentToFocus = this.myInplaceEditorComponent;
        }
        if (componentToFocus.requestFocusInWindow()) {
            this.myFocusWatcher.install(this.myInplaceEditorComponent);
        } else {
            this.grabFocus();
            JComponent finalComponentToFocus = componentToFocus;
            ApplicationManager.getApplication().invokeLater(() -> {
                finalComponentToFocus.requestFocusInWindow();
                this.myFocusWatcher.install(this.myInplaceEditorComponent);
            });
        }
        this.enableEvents(16L);
        this.repaint();
    }

    private void adjustEditorComponentSize() {
        if (this.myInplaceEditorComponent == null) {
            return;
        }
        Dimension preferredSize = this.myInplaceEditorComponent.getPreferredSize();
        int width = Math.max(preferredSize.width, this.myPreferredBounds.width);
        width = Math.min(width, this.getWidth() - this.myInplaceEditorComponent.getX());
        this.myInplaceEditorComponent.setSize(width, this.myInplaceEditorComponent.getHeight());
        this.myInplaceEditorComponent.revalidate();
    }

    public void finishInplaceEditing() {
        if (this.myInplaceComponent == null || this.myInsideChange) {
            return;
        }
        this.myInsideChange = true;
        try {
            LOG.assertTrue(this.myInplaceEditor != null);
            if (!this.myEditor.isUndoRedoInProgress()) {
                CommandProcessor.getInstance().executeCommand(this.myInplaceComponent.getProject(), () -> {
                    try {
                        Object value = this.myInplaceEditor.getValue();
                        this.myInplaceProperty.setValue(this.myInplaceComponent, value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.myEditor.refreshAndSave(true);
                }, UIDesignerBundle.message("command.set.property.value", new Object[0]), null);
            }
            if (this.myInplaceEditorComponent != null) {
                this.removeInplaceEditorComponent();
                this.myFocusWatcher.deinstall(this.myInplaceEditorComponent);
            }
            this.myInplaceEditor.removePropertyEditorListener(this.myPropertyEditorListener);
            this.myInplaceComponent = null;
            this.myInplaceEditorComponent = null;
            this.myInplaceComponent = null;
            this.disableEvents(16L);
        }
        finally {
            this.myInsideChange = false;
        }
        this.repaint();
    }

    private void cancelInplaceEditing() {
        if (this.myInplaceComponent == null || this.myInsideChange) {
            return;
        }
        this.myInsideChange = true;
        try {
            LOG.assertTrue(this.myInplaceProperty != null);
            LOG.assertTrue(this.myInplaceEditor != null);
            this.removeInplaceEditorComponent();
            this.myInplaceEditor.removePropertyEditorListener(this.myPropertyEditorListener);
            this.myFocusWatcher.deinstall(this.myInplaceEditorComponent);
            this.myInplaceComponent = null;
            this.myInplaceEditorComponent = null;
            this.myInplaceComponent = null;
            this.disableEvents(16L);
        }
        finally {
            this.myInsideChange = false;
        }
        this.repaint();
    }

    private void removeInplaceEditorComponent() {
        this.remove(this.myInplaceEditorComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inplaceComponent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/designSurface/InplaceEditingLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startInplaceEditing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyPropertyEditorListener
    implements PropertyEditorListener {
        private MyPropertyEditorListener() {
        }

        @Override
        public void valueCommitted(@NotNull PropertyEditor source, boolean continueEditing, boolean closeEditorOnError) {
            if (source == null) {
                MyPropertyEditorListener.$$$reportNull$$$0(0);
            }
            InplaceEditingLayer.this.finishInplaceEditing();
        }

        @Override
        public void editingCanceled(@NotNull PropertyEditor source) {
            if (source == null) {
                MyPropertyEditorListener.$$$reportNull$$$0(1);
            }
            InplaceEditingLayer.this.cancelInplaceEditing();
        }

        @Override
        public void preferredSizeChanged(@NotNull PropertyEditor source) {
            if (source == null) {
                MyPropertyEditorListener.$$$reportNull$$$0(2);
            }
            InplaceEditingLayer.this.adjustEditorComponentSize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "source";
            objectArray2[1] = "com/intellij/uiDesigner/designSurface/InplaceEditingLayer$MyPropertyEditorListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueCommitted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editingCanceled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preferredSizeChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyFocusWatcher
    extends FocusWatcher {
        private MyFocusWatcher() {
        }

        protected void focusLostImpl(FocusEvent e) {
            Component opposite = e.getOppositeComponent();
            if (e.isTemporary() || opposite != null && SwingUtilities.isDescendingFrom(opposite, this.getTopComponent())) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> InplaceEditingLayer.this.finishInplaceEditing(), ModalityState.NON_MODAL);
        }
    }

    private final class MyComponentSelectionListener
    implements ComponentSelectionListener {
        private MyComponentSelectionListener() {
        }

        @Override
        public void selectedComponentChanged(@NotNull GuiEditor source) {
            if (source == null) {
                MyComponentSelectionListener.$$$reportNull$$$0(0);
            }
            InplaceEditingLayer.this.finishInplaceEditing();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/uiDesigner/designSurface/InplaceEditingLayer$MyComponentSelectionListener", "selectedComponentChanged"));
        }
    }
}

