/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.annotations.Nullable;

public class VcsScopeItem
implements ModelScopeItem {
    private final ChangeListManager myChangeListManager;
    private final DefaultComboBoxModel<LocalChangeList> myModel;
    private final Project myProject;

    @Nullable
    public static VcsScopeItem createIfHasVCS(Project project) {
        if (ChangeListManager.getInstance((Project)project).getAffectedFiles().isEmpty()) {
            return null;
        }
        return new VcsScopeItem(project);
    }

    public VcsScopeItem(Project project) {
        this.myProject = project;
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        assert (!this.myChangeListManager.getAffectedFiles().isEmpty());
        if (ChangesUtil.hasMeaningfulChangelists((Project)this.myProject)) {
            this.myModel = new DefaultComboBoxModel();
            this.myModel.addElement(null);
            List changeLists = this.myChangeListManager.getChangeLists();
            for (LocalChangeList changeList : changeLists) {
                this.myModel.addElement(changeList);
            }
        } else {
            this.myModel = null;
        }
    }

    @Override
    public AnalysisScope getScope() {
        LocalChangeList list2;
        ChangeList changeList;
        ChangeList changeList2 = changeList = this.myModel != null ? (ChangeList)this.myModel.getSelectedItem() : null;
        List files2 = changeList == null ? this.myChangeListManager.getAffectedFiles() : ((list2 = this.myChangeListManager.findChangeList(changeList.getName())) != null ? ChangesUtil.getAfterRevisionsFiles(list2.getChanges().stream()).collect(Collectors.toList()) : Collections.emptyList());
        return new AnalysisScope(this.myProject, new HashSet(files2));
    }

    @Nullable
    public DefaultComboBoxModel<LocalChangeList> getChangeListsModel() {
        return this.myModel;
    }
}

