/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.toolWindow.HighlightingFileRoot;
import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel$WhenMappings;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.ProblemNode;
import com.intellij.analysis.problemsView.toolWindow.ProblemNodeFinder;
import com.intellij.analysis.problemsView.toolWindow.ProblemsTreeModel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewState;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.analysis.problemsView.toolWindow.Status;
import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.TreeExpander;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 =2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001=B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0015\u0010#\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b$J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0016J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020\u0019H\u0016J\u000e\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u000206H\u0016J\u001a\u00107\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u00108\u001a\u000206H\u0002J\u001a\u00109\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u00108\u001a\u000206H\u0002J\b\u0010:\u001a\u00020\u0019H\u0002J\b\u0010;\u001a\u00020\u0019H\u0002J\b\u0010<\u001a\u00020\u0019H\u0002R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingPanel;", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/ide/PowerSaveMode$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewState;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/analysis/problemsView/toolWindow/ProblemsViewState;)V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "currentFile", "getCurrentFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setCurrentFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "currentRoot", "Lcom/intellij/analysis/problemsView/toolWindow/HighlightingFileRoot;", "getCurrentRoot$intellij_platform_lang_impl", "()Lcom/intellij/analysis/problemsView/toolWindow/HighlightingFileRoot;", "previousStatus", "Lcom/intellij/analysis/problemsView/toolWindow/Status;", "statusUpdateAlarm", "Lcom/intellij/util/SingleAlarm;", "fileClosed", "", "manager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "fileOpened", "findCurrentFile", "getCurrentStatus", "getData", "", "dataId", "", "getRoot", "getRoot$intellij_platform_lang_impl", "getSortFoldersFirst", "Lcom/intellij/openapi/actionSystem/ToggleOptionAction$Option;", "getToolWindowIcon", "Ljavax/swing/Icon;", "count", "", "getTreeExpander", "Lcom/intellij/ide/TreeExpander;", "powerSaveStateChanged", "selectHighlighter", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "selectionChangedTo", "selected", "", "statusAnalyzing", "filtered", "statusComplete", "updateCurrentFile", "updateCurrentFileIfLocalId", "updateStatus", "Companion", "intellij.platform.lang.impl"})
public final class HighlightingPanel
extends ProblemsViewPanel
implements FileEditorManagerListener,
PowerSaveMode.Listener {
    private final SingleAlarm statusUpdateAlarm;
    private Status previousStatus;
    @NotNull
    public static final String ID = "CurrentFile";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public ToggleOptionAction.Option getSortFoldersFirst() {
        return null;
    }

    @Override
    @Nullable
    public TreeExpander getTreeExpander() {
        return null;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.getCurrentFile();
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    public Icon getToolWindowIcon(int count) {
        boolean bl;
        block6: {
            if (ProblemsView.isProjectErrorsEnabled()) {
                return null;
            }
            HighlightingFileRoot highlightingFileRoot = this.getCurrentRoot$intellij_platform_lang_impl();
            if (highlightingFileRoot == null) {
                return AllIcons.Toolwindows.ToolWindowProblemsEmpty;
            }
            HighlightingFileRoot root2 = highlightingFileRoot;
            Iterable $this$any$iv = root2.getChildren(root2.getFile());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Node it = (Node)((Object)element$iv);
                    boolean bl2 = false;
                    Node node2 = it;
                    if (!(node2 instanceof ProblemNode)) {
                        node2 = null;
                    }
                    ProblemNode problemNode = (ProblemNode)node2;
                    Integer severity = problemNode != null ? Integer.valueOf(problemNode.getSeverity()) : null;
                    if (!(severity != null && severity >= HighlightSeverity.ERROR.myVal)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean problem = bl;
        return problem ? AllIcons.Toolwindows.ToolWindowProblems : AllIcons.Toolwindows.ToolWindowProblemsEmpty;
    }

    @Override
    public void selectionChangedTo(boolean selected2) {
        super.selectionChangedTo(selected2);
        if (selected2) {
            this.updateCurrentFile();
        }
    }

    public void powerSaveStateChanged() {
        this.statusUpdateAlarm.cancelAndRequest(true);
        this.updateToolWindowContent();
    }

    public void fileOpened(@NotNull FileEditorManager manager2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.updateCurrentFileIfLocalId();
    }

    public void fileClosed(@NotNull FileEditorManager manager2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.updateCurrentFileIfLocalId();
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateCurrentFileIfLocalId();
    }

    private final void updateCurrentFileIfLocalId() {
        if (Intrinsics.areEqual((Object)ClientId.Companion.getCurrent(), (Object)this.myClientId)) {
            this.updateCurrentFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateCurrentFile() {
        VirtualFile virtualFile2;
        ClientId.Companion companion = ClientId.Companion;
        ClientId clientId = this.myClientId;
        HighlightingPanel highlightingPanel = this;
        boolean $i$f$withClientId = false;
        ClientIdService clientIdService = ClientIdService.Companion.tryGetInstance();
        if (clientIdService == null) {
            boolean bl = false;
            virtualFile2 = this.findCurrentFile();
        } else {
            String string;
            void clientId$iv;
            ClientIdService service$iv = clientIdService;
            if (!service$iv.isValid((ClientId)clientId$iv)) {
                void this_$iv;
                Logger $this$trace$iv$iv = this_$iv.getClientIdLogger();
                boolean $i$f$trace = false;
                if ($this$trace$iv$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv$iv;
                    boolean bl = false;
                    String string2 = "Invalid ClientId " + clientId$iv + " replaced with null at " + new Throwable().fillInStackTrace();
                    logger.trace(string2);
                }
                string = null;
            } else {
                void v3 = clientId$iv;
                string = v3 != null ? v3.getValue() : null;
            }
            String newClientIdValue$iv = string;
            String oldClientIdValue$iv = service$iv.getClientIdValue();
            try {
                service$iv.setClientIdValue(newClientIdValue$iv);
                boolean bl = false;
                VirtualFile virtualFile3 = this.findCurrentFile();
                virtualFile2 = virtualFile3;
            }
            finally {
                service$iv.setClientIdValue(oldClientIdValue$iv);
            }
        }
        VirtualFile virtualFile4 = virtualFile2;
        highlightingPanel.setCurrentFile(virtualFile4);
    }

    @Nullable
    public final HighlightingFileRoot getCurrentRoot$intellij_platform_lang_impl() {
        ProblemsTreeModel problemsTreeModel = this.getTreeModel();
        Intrinsics.checkNotNullExpressionValue((Object)problemsTreeModel, (String)"treeModel");
        Root root2 = problemsTreeModel.getRoot();
        if (!(root2 instanceof HighlightingFileRoot)) {
            root2 = null;
        }
        return (HighlightingFileRoot)root2;
    }

    @Nullable
    public final VirtualFile getCurrentFile() {
        HighlightingFileRoot highlightingFileRoot = this.getCurrentRoot$intellij_platform_lang_impl();
        return highlightingFileRoot != null ? highlightingFileRoot.getFile() : null;
    }

    public final void setCurrentFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            if (this.getCurrentRoot$intellij_platform_lang_impl() == null) {
                return;
            }
            ProblemsTreeModel problemsTreeModel = this.getTreeModel();
            Intrinsics.checkNotNullExpressionValue((Object)problemsTreeModel, (String)"treeModel");
            problemsTreeModel.setRoot(null);
        } else {
            HighlightingFileRoot highlightingFileRoot = this.getCurrentRoot$intellij_platform_lang_impl();
            if (Intrinsics.areEqual((Object)(highlightingFileRoot != null ? highlightingFileRoot.getFile() : null), (Object)file2)) {
                return;
            }
            ProblemsTreeModel problemsTreeModel = this.getTreeModel();
            Intrinsics.checkNotNullExpressionValue((Object)problemsTreeModel, (String)"treeModel");
            problemsTreeModel.setRoot(this.getRoot$intellij_platform_lang_impl(file2));
            Intrinsics.checkNotNullExpressionValue((Object)TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)this.getTree())), (String)"TreeUtil.promiseSelectFirstLeaf(tree)");
        }
        this.powerSaveStateChanged();
    }

    @NotNull
    public final HighlightingFileRoot getRoot$intellij_platform_lang_impl(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new HighlightingFileRoot(this, file2);
    }

    public final void selectHighlighter(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Object object = this.getCurrentRoot$intellij_platform_lang_impl();
        if (object == null || (object = ((HighlightingFileRoot)object).findProblem(highlighter)) == null) {
            return;
        }
        Object problem = object;
        TreeUtil.promiseSelect((JTree)((JTree)this.getTree()), (TreeVisitor)new ProblemNodeFinder((Problem)problem));
    }

    private final VirtualFile findCurrentFile() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (project.isDisposed()) {
            return null;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
        if (fileEditorManager == null || (fileEditorManager = fileEditorManager.getSelectedEditor()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getIns\u2026ctedEditor ?: return null");
        FileEditorManager fileEditor = fileEditorManager;
        VirtualFile file2 = fileEditor.getFile();
        if (file2 != null) {
            return file2;
        }
        FileEditorManager fileEditorManager2 = fileEditor;
        if (!(fileEditorManager2 instanceof TextEditor)) {
            fileEditorManager2 = null;
        }
        TextEditor textEditor = (TextEditor)fileEditorManager2;
        if (textEditor == null) {
            return null;
        }
        TextEditor textEditor2 = textEditor;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Editor editor2 = textEditor2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"textEditor.editor");
        return fileDocumentManager.getFile(editor2.getDocument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateStatus() {
        Status status;
        Object object = ClientId.Companion;
        ClientId clientId$iv = this.myClientId;
        boolean $i$f$withClientId = false;
        ClientIdService clientIdService = ClientIdService.Companion.tryGetInstance();
        if (clientIdService == null) {
            boolean bl = false;
            status = this.getCurrentStatus();
        } else {
            String string;
            ClientIdService service$iv = clientIdService;
            if (!service$iv.isValid(clientId$iv)) {
                void this_$iv;
                Logger $this$trace$iv$iv = this_$iv.getClientIdLogger();
                boolean $i$f$trace = false;
                if ($this$trace$iv$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv$iv;
                    boolean bl = false;
                    String string2 = "Invalid ClientId " + clientId$iv + " replaced with null at " + new Throwable().fillInStackTrace();
                    logger.trace(string2);
                }
                string = null;
            } else {
                ClientId clientId = clientId$iv;
                string = clientId != null ? clientId.getValue() : null;
            }
            String newClientIdValue$iv = string;
            String oldClientIdValue$iv = service$iv.getClientIdValue();
            try {
                service$iv.setClientIdValue(newClientIdValue$iv);
                boolean bl = false;
                Status status2 = this.getCurrentStatus();
                status = status2;
            }
            finally {
                service$iv.setClientIdValue(oldClientIdValue$iv);
            }
        }
        Status status3 = status;
        if (Intrinsics.areEqual((Object)this.previousStatus, (Object)status3) ^ true) {
            this.previousStatus = status3;
            Tree tree = this.getTree();
            Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"tree");
            StatusText statusText2 = tree.getEmptyText();
            Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"tree.emptyText");
            statusText2.setText(status3.getTitle());
            object = status3.getDetails();
            boolean bl = false;
            if (object.length() > 0) {
                Tree tree2 = this.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"tree");
                tree2.getEmptyText().appendLine(status3.getDetails());
            }
        }
        if (status3.getRequest()) {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.statusUpdateAlarm, (boolean)false, (int)1, null);
        }
    }

    private final Status getCurrentStatus() {
        Status status;
        VirtualFile virtualFile2 = this.getCurrentFile();
        if (virtualFile2 == null) {
            String string = ProblemsViewBundle.message("problems.view.highlighting.no.selected.file", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProblemsViewBundle.messa\u2026ghting.no.selected.file\")");
            return new Status(string, null, false, 6, null);
        }
        VirtualFile file2 = virtualFile2;
        if (PowerSaveMode.isEnabled()) {
            String string = ProblemsViewBundle.message("problems.view.highlighting.power.save.mode", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProblemsViewBundle.messa\u2026ighting.power.save.mode\")");
            return new Status(string, null, false, 6, null);
        }
        Document document = ProblemsView.getDocument(this.getProject(), file2);
        if (document == null) {
            return HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"ProblemsView.getDocument\u2026urn statusAnalyzing(file)");
        Document document2 = document;
        Editor editor2 = EditorFactory.getInstance().editors(document2, this.getProject()).findFirst().orElse(null);
        if (editor2 == null) {
            return HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
        }
        Editor editor3 = editor2;
        MarkupModel markupModel = editor3.getMarkupModel();
        if (!(markupModel instanceof EditorMarkupModel)) {
            markupModel = null;
        }
        EditorMarkupModel editorMarkupModel = (EditorMarkupModel)markupModel;
        if (editorMarkupModel == null) {
            return HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
        }
        EditorMarkupModel model2 = editorMarkupModel;
        ErrorStripeRenderer errorStripeRenderer = model2.getErrorStripeRenderer();
        if (errorStripeRenderer == null || (errorStripeRenderer = errorStripeRenderer.getStatus()) == null) {
            return HighlightingPanel.statusComplete$default(this, file2, false, 2, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)errorStripeRenderer, (String)"model.errorStripeRendere\u2026turn statusComplete(file)");
        ErrorStripeRenderer status2 = errorStripeRenderer;
        switch (HighlightingPanel$WhenMappings.$EnumSwitchMapping$0[status2.getAnalyzingType().ordinal()]) {
            case 1: {
                status = new Status(status2.getTitle(), status2.getDetails(), true);
                break;
            }
            case 2: {
                Collection collection = this.getState().getHideBySeverity();
                boolean bl = false;
                status = this.statusComplete(file2, !collection.isEmpty());
                break;
            }
            case 3: {
                Collection collection = this.getState().getHideBySeverity();
                boolean bl = false;
                status = this.statusAnalyzing(file2, !collection.isEmpty());
                break;
            }
            default: {
                status = HighlightingPanel.statusAnalyzing$default(this, file2, false, 2, null);
            }
        }
        return status;
    }

    private final Status statusAnalyzing(VirtualFile file2, boolean filtered2) {
        String string = ProblemsViewBundle.message("problems.view.highlighting.problems.analyzing", file2.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProblemsViewBundle.messa\u2026ms.analyzing\", file.name)");
        String title2 = string;
        if (filtered2) {
            String string2 = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found.filter", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ProblemsViewBundle.messa\u2026oblems.not.found.filter\")");
            String details2 = string2;
            return new Status(title2, details2, true);
        }
        return new Status(title2, null, true, 2, null);
    }

    static /* synthetic */ Status statusAnalyzing$default(HighlightingPanel highlightingPanel, VirtualFile virtualFile2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return highlightingPanel.statusAnalyzing(virtualFile2, bl);
    }

    private final Status statusComplete(VirtualFile file2, boolean filtered2) {
        String string = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found", file2.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProblemsViewBundle.messa\u2026ms.not.found\", file.name)");
        String title2 = string;
        if (filtered2) {
            String string2 = ProblemsViewBundle.message("problems.view.highlighting.problems.not.found.filter", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ProblemsViewBundle.messa\u2026oblems.not.found.filter\")");
            String details2 = string2;
            return new Status(title2, details2, false, 4, null);
        }
        return new Status(title2, null, false, 6, null);
    }

    static /* synthetic */ Status statusComplete$default(HighlightingPanel highlightingPanel, VirtualFile virtualFile2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return highlightingPanel.statusComplete(virtualFile2, bl);
    }

    public HighlightingPanel(@NotNull Project project, @NotNull ProblemsViewState state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super(project, ID, state, ProblemsViewBundle.messagePointer("problems.view.highlighting", new Object[0]));
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                HighlightingPanel.access$updateStatus((HighlightingPanel)this.receiver);
            }
        };
        Runnable runnable2 = new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        };
        ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)((Object)this)));
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(this)");
        this.statusUpdateAlarm = new SingleAlarm(runnable2, 200, modalityState, (Disposable)this);
        Tree tree = this.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"tree");
        tree.setShowsRootHandles(false);
        this.updateCurrentFile();
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
        application.getMessageBus().connect((Disposable)this).subscribe(PowerSaveMode.TOPIC, (Object)this);
    }

    public static final /* synthetic */ void access$updateStatus(HighlightingPanel $this) {
        $this.updateStatus();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/HighlightingPanel$Companion;", "", "()V", "ID", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

