/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SystemProperties;

public final class EditorFontsConstants {
    public static int getMinEditorFontSize() {
        return JBUIScale.scale((int)4);
    }

    public static int getMaxEditorFontSize() {
        return JBUIScale.scale((int)SystemProperties.getIntProperty((String)"ide.editor.max.font.size", (int)40));
    }

    public static int getDefaultEditorFontSize() {
        return JBUIScale.scale((int)12);
    }

    public static float getMinEditorLineSpacing() {
        return 0.6f;
    }

    public static float getMaxEditorLineSpacing() {
        return 3.0f;
    }

    public static float getDefaultEditorLineSpacing() {
        return 1.0f;
    }

    public static int checkAndFixEditorFontSize(int size) {
        return EditorFontsConstants.round(EditorFontsConstants.getMinEditorFontSize(), EditorFontsConstants.getMaxEditorFontSize(), size);
    }

    public static float checkAndFixEditorLineSpacing(float lineSpacing) {
        return EditorFontsConstants.round(EditorFontsConstants.getMinEditorLineSpacing(), EditorFontsConstants.getMaxEditorLineSpacing(), lineSpacing);
    }

    private static int round(int min, int max, int val) {
        return Math.max(min, Math.min(max, val));
    }

    private static float round(float min, float max, float val) {
        return Math.max(min, Math.min(max, val));
    }

    private EditorFontsConstants() {
    }
}

