/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementEditorComponent;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchNodeComponentFactory;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.EmptyArrangementRuleComponent;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementEditorAware;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementRepresentationAware;
import com.intellij.application.options.codeStyle.arrangement.util.ArrangementListRowDecorator;
import com.intellij.application.options.codeStyle.arrangement.util.IntObjectMap;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ArrangementMatchingRulesControl
extends JBTable {
    @NotNull
    protected final IntObjectMap<ArrangementListRowDecorator> myComponents;
    @NotNull
    private final IntList mySelectedRows;
    @NotNull
    private final ArrangementMatchNodeComponentFactory myFactory;
    @NotNull
    protected ArrangementMatchingRuleEditor myEditor;
    @NotNull
    private final RepresentationCallback myRepresentationCallback;
    @NotNull
    private final MatchingRulesRendererBase myRenderer;
    private ArrangementMatchingRulesValidator myValidator;
    private final int myMinRowHeight;
    private int myRowUnderMouse;
    private int myEditorRow;
    private boolean mySkipSelectionChange;

    public ArrangementMatchingRulesControl(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull RepresentationCallback callback2) {
        if (settingsManager == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(0);
        }
        if (colorsProvider == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(1);
        }
        if (callback2 == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(2);
        }
        super((TableModel)new ArrangementMatchingRulesModel());
        this.myComponents = new IntObjectMap();
        this.mySelectedRows = new IntArrayList();
        this.myRowUnderMouse = -1;
        this.myEditorRow = -1;
        this.myRepresentationCallback = callback2;
        this.myFactory = new ArrangementMatchNodeComponentFactory(settingsManager, colorsProvider, this);
        this.myRenderer = this.createRender();
        this.setDefaultRenderer(Object.class, this.myRenderer);
        this.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)new MyEditor()));
        this.setSelectionMode(2);
        this.setShowColumns(false);
        this.setShowGrid(false);
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ArrangementAtomMatchCondition condition = new ArrangementAtomMatchCondition(StdArrangementTokens.EntryType.CLASS);
        StdArrangementMatchRule rule = new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)condition));
        ArrangementUiComponent component2 = this.myFactory.getComponent((ArrangementMatchCondition)condition, rule, true);
        this.myMinRowHeight = new ArrangementListRowDecorator((ArrangementUiComponent)component2, (ArrangementMatchingRulesControl)this).getPreferredSize().height;
        this.myEditor = new ArrangementMatchingRuleEditor(settingsManager, colorsProvider, this);
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ArrangementMatchingRulesControl.this.onMouseMoved(e);
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ArrangementMatchingRulesControl.this.onSelectionChange(e);
            }
        });
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ArrangementMatchingRulesControl.this.onTableChange(e);
            }
        });
    }

    protected MatchingRulesRendererBase createRender() {
        return new MatchingRulesRendererBase();
    }

    @NotNull
    protected ArrangementMatchingRulesValidator createValidator() {
        return new ArrangementMatchingRulesValidator(this.getModel());
    }

    private ArrangementMatchingRulesValidator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = this.createValidator();
        }
        return this.myValidator;
    }

    @NotNull
    public ArrangementMatchingRulesModel getModel() {
        ArrangementMatchingRulesModel arrangementMatchingRulesModel = (ArrangementMatchingRulesModel)super.getModel();
        if (arrangementMatchingRulesModel == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(3);
        }
        return arrangementMatchingRulesModel;
    }

    protected void processMouseEvent(MouseEvent e) {
        int id2 = e.getID();
        switch (id2) {
            case 504: {
                this.onMouseEntered(e);
                break;
            }
            case 505: {
                this.onMouseExited();
                break;
            }
            case 502: {
                this.onMouseReleased(e);
                break;
            }
            case 500: {
                this.onMouseClicked(e);
            }
        }
        if (!e.isConsumed()) {
            super.processMouseEvent(e);
        }
    }

    private void onMouseClicked(@NotNull MouseEvent e) {
        int count;
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(4);
        }
        if ((count = e.getClickCount()) != 2) {
            return;
        }
        IntList rows = this.getSelectedModelRows();
        if (rows.size() != 1) {
            return;
        }
        int row2 = rows.getInt(0);
        this.showEditor(row2);
        this.scrollRowToVisible(row2);
    }

    private void onMouseMoved(@NotNull MouseEvent e) {
        ArrangementListRowDecorator decorator;
        int i2;
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(5);
        }
        if ((i2 = this.rowAtPoint(e.getPoint())) != this.myRowUnderMouse) {
            this.onMouseExited();
        }
        if (i2 < 0) {
            return;
        }
        if (i2 != this.myRowUnderMouse) {
            this.onMouseEntered(e);
        }
        if ((decorator = this.myComponents.get(i2)) == null) {
            return;
        }
        Rectangle rectangle = decorator.onMouseMove(e);
        if (rectangle != null) {
            this.repaintScreenBounds(rectangle);
        }
    }

    private void repaintScreenBounds(@NotNull Rectangle bounds2) {
        if (bounds2 == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(6);
        }
        Point location = bounds2.getLocation();
        SwingUtilities.convertPointFromScreen(location, (Component)((Object)this));
        int x = location.x;
        int width = bounds2.width;
        this.repaint(x, location.y, width, bounds2.height);
    }

    private void onMouseReleased(@NotNull MouseEvent e) {
        int i2;
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(7);
        }
        if ((i2 = this.rowAtPoint(e.getPoint())) < 0) {
            return;
        }
        ArrangementListRowDecorator decorator = this.myComponents.get(i2);
        if (decorator != null) {
            decorator.onMouseRelease(e);
        }
        if (!e.isConsumed() && this.myEditorRow > 0 && this.myEditorRow == i2 + 1) {
            this.hideEditor();
        }
    }

    private void onMouseExited() {
        if (this.myRowUnderMouse < 0) {
            return;
        }
        ArrangementListRowDecorator decorator = this.myComponents.get(this.myRowUnderMouse);
        if (decorator != null) {
            decorator.onMouseExited();
            this.repaintRows(this.myRowUnderMouse, this.myRowUnderMouse, false);
        }
        this.myRowUnderMouse = -1;
    }

    private void onMouseEntered(@NotNull MouseEvent e) {
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(8);
        }
        this.myRowUnderMouse = this.rowAtPoint(e.getPoint());
        ArrangementListRowDecorator decorator = this.myComponents.get(this.myRowUnderMouse);
        if (decorator != null) {
            decorator.onMouseEntered(e);
            this.repaintRows(this.myRowUnderMouse, this.myRowUnderMouse, false);
        }
    }

    public void runOperationIgnoreSelectionChange(@NotNull Runnable task2) {
        if (task2 == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(9);
        }
        this.mySkipSelectionChange = true;
        try {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            task2.run();
        }
        finally {
            this.mySkipSelectionChange = false;
            this.refreshEditor();
        }
    }

    private void onSelectionChange(@NotNull ListSelectionEvent e) {
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(10);
        }
        if (this.mySkipSelectionChange || e.getValueIsAdjusting()) {
            return;
        }
        this.refreshEditor();
    }

    public void removeRow(int rowIndex) {
        if (rowIndex < this.myEditorRow) {
            this.hideEditor();
        }
        this.getModel().removeRow(rowIndex);
    }

    public void refreshEditor() {
        ArrangementMatchingRulesModel model2 = this.getModel();
        if (this.myEditorRow >= model2.getSize()) {
            this.myEditorRow = -1;
            int max = model2.getSize();
            for (int i2 = 0; i2 < max; ++i2) {
                if (!(model2.getElementAt(i2) instanceof ArrangementEditorComponent)) continue;
                this.myEditorRow = i2;
                break;
            }
        }
        if (this.myEditorRow < 0) {
            return;
        }
        ListSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            this.hideEditor();
            return;
        }
        int selectedRow = selectionModel.getMinSelectionIndex();
        if (selectedRow != selectionModel.getMaxSelectionIndex()) {
            this.hideEditor();
            return;
        }
        if (selectedRow != this.myEditorRow && selectedRow != this.myEditorRow - 1) {
            this.hideEditor();
        }
    }

    public void hideEditor() {
        TableCellEditor editor2;
        if (this.myEditorRow < 0) {
            return;
        }
        if (this.isEditing() && (editor2 = this.getCellEditor()) != null) {
            editor2.stopCellEditing();
        }
        this.mySkipSelectionChange = true;
        try {
            ArrangementMatchingRulesModel model2 = this.getModel();
            model2.removeRow(this.myEditorRow);
            if (this.myEditorRow > 0 && model2.getElementAt(this.myEditorRow - 1) instanceof EmptyArrangementRuleComponent) {
                model2.removeRow(this.myEditorRow - 1);
            }
        }
        finally {
            this.mySkipSelectionChange = false;
        }
        this.myEditorRow = -1;
    }

    private void onTableChange(@NotNull TableModelEvent e) {
        int signum;
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(11);
        }
        switch (e.getType()) {
            case 1: {
                signum = 1;
                break;
            }
            case -1: {
                signum = -1;
                for (int i2 = e.getLastRow(); i2 >= e.getFirstRow(); --i2) {
                    this.myComponents.remove(i2);
                }
                break;
            }
            default: {
                return;
            }
        }
        int shift = Math.abs(e.getFirstRow() - e.getLastRow() + 1) * signum;
        this.myComponents.shiftKeys(e.getFirstRow(), shift);
        if (this.myRowUnderMouse >= e.getFirstRow()) {
            this.myRowUnderMouse = -1;
        }
        if (this.getModel().getSize() > 0) {
            this.repaintRows(0, this.getModel().getSize() - 1, false);
        }
    }

    public void showEditor(int rowToEdit) {
        this.showEditor(this.myEditor, rowToEdit);
    }

    public void scrollRowToVisible(int row2) {
        Rectangle rect = this.getCellRect(row2, 0, false);
        if (row2 != this.getEditingRow() - 1) {
            this.scrollRectToVisible(rect);
        } else {
            Rectangle editorRect = this.getCellRect(row2 + 1, 0, false);
            if (!rect.isEmpty() && !editorRect.isEmpty()) {
                int height = (int)(rect.getHeight() + editorRect.getHeight());
                Rectangle visibleRect = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), height);
                this.scrollRectToVisible(visibleRect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEditor(@NotNull ArrangementMatchingRuleEditor editor2, int rowToEdit) {
        if (editor2 == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(12);
        }
        if (this.myEditorRow == rowToEdit + 1) {
            return;
        }
        if (this.myEditorRow >= 0) {
            if (this.myEditorRow < rowToEdit) {
                --rowToEdit;
            }
            this.hideEditor();
        }
        this.myEditorRow = rowToEdit + 1;
        ArrangementEditorComponent editorComponent = new ArrangementEditorComponent(this, this.myEditorRow, editor2);
        editorComponent.applyAvailableWidth(this.getWidth());
        editor2.reset(rowToEdit);
        this.mySkipSelectionChange = true;
        try {
            this.getModel().insertRow(this.myEditorRow, new Object[]{editorComponent});
        }
        finally {
            this.mySkipSelectionChange = false;
        }
        Rectangle bounds2 = this.getRowsBounds(rowToEdit, this.myEditorRow);
        this.myRepresentationCallback.ensureVisible(bounds2);
        editorComponent.expand();
        this.repaintRows(rowToEdit, this.getModel().getRowCount() - 1, false);
        this.editCellAt(this.myEditorRow, 0);
    }

    public void repaintRows(int first, int last, boolean rowStructureChanged) {
        for (int i2 = first; i2 <= last; ++i2) {
            if (rowStructureChanged) {
                this.myComponents.remove(i2);
                continue;
            }
            this.setRowHeight(i2, this.myRenderer.getRendererComponent((int)i2).getPreferredSize().height);
        }
        this.getModel().fireTableRowsUpdated(first, last);
    }

    private Rectangle getRowsBounds(int first, int last) {
        Rectangle firstRect = this.getCellRect(first, 0, true);
        Rectangle lastRect = this.getCellRect(last, 0, true);
        return new Rectangle(firstRect.x, firstRect.y, lastRect.width, lastRect.y + lastRect.height - firstRect.y);
    }

    @NotNull
    public IntList getSelectedModelRows() {
        this.mySelectedRows.clear();
        int min = this.selectionModel.getMinSelectionIndex();
        if (min >= 0) {
            for (int i2 = this.selectionModel.getMaxSelectionIndex(); i2 >= min; --i2) {
                if ((this.myEditorRow < 0 || i2 != this.myEditorRow - 1) && (i2 == this.myEditorRow || !this.selectionModel.isSelectedIndex(i2))) continue;
                this.mySelectedRows.add(i2);
            }
        } else if (this.myEditorRow > 0) {
            this.mySelectedRows.add(this.myEditorRow - 1);
        }
        IntList intList = this.mySelectedRows;
        if (intList == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(13);
        }
        return intList;
    }

    public int getRowByRenderer(@NotNull ArrangementListRowDecorator renderer2) {
        if (renderer2 == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(14);
        }
        int max = this.getModel().getSize();
        for (int i2 = 0; i2 < max; ++i2) {
            if (this.myComponents.get(i2) != renderer2) continue;
            return i2;
        }
        return -1;
    }

    public int getEmptyRowHeight() {
        return this.myMinRowHeight;
    }

    @NotNull
    private JComponent adjustHeight(@NotNull JComponent component2, int row2) {
        int height;
        if (component2 == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(15);
        }
        if ((height = component2.getPreferredSize().height) < this.myMinRowHeight) {
            height = this.myMinRowHeight;
        }
        this.setRowHeight(row2, height);
        JComponent jComponent = component2;
        if (jComponent == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(16);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModelRows";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustHeight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 13: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onMouseClicked";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onMouseMoved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "repaintScreenBounds";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onMouseReleased";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onMouseEntered";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runOperationIgnoreSelectionChange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onSelectionChange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onTableChange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showEditor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRowByRenderer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "adjustHeight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface RepresentationCallback {
        public void ensureVisible(@NotNull Rectangle var1);
    }

    private class MyEditor
    extends AbstractTableCellEditor {
        private int myRow;

        private MyEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row2, int column2) {
            if (value2 instanceof ArrangementEditorAware) {
                this.myRow = row2;
                return ((ArrangementEditorAware)value2).getComponent();
            }
            return null;
        }

        public Object getCellEditorValue() {
            return this.myRow < ArrangementMatchingRulesControl.this.getModel().getSize() ? ArrangementMatchingRulesControl.this.getModel().getElementAt(this.myRow) : null;
        }
    }

    protected class MatchingRulesRendererBase
    implements TableCellRenderer {
        protected MatchingRulesRendererBase() {
        }

        public Component getRendererComponent(int row2) {
            return this.getTableCellRendererComponent((JTable)((Object)ArrangementMatchingRulesControl.this), ArrangementMatchingRulesControl.this.getModel().getElementAt(row2), false, false, row2, 0);
        }

        public boolean allowModifications(StdArrangementMatchRule rule) {
            return true;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            if (ArrangementMatchingRulesControl.this.isEditing() && ArrangementMatchingRulesControl.this.getEditingRow() == row2) {
                return new JLabel(ApplicationBundle.message((String)"arrangement.text.empty.rule", (Object[])new Object[0]));
            }
            if (value2 instanceof ArrangementRepresentationAware) {
                return ArrangementMatchingRulesControl.this.adjustHeight(((ArrangementRepresentationAware)value2).getComponent(), row2);
            }
            ArrangementListRowDecorator component2 = ArrangementMatchingRulesControl.this.myComponents.get(row2);
            if (component2 == null) {
                if (!(value2 instanceof StdArrangementMatchRule)) {
                    return new JLabel(ApplicationBundle.message((String)"arrangement.text.empty.rule", (Object[])new Object[0]));
                }
                StdArrangementMatchRule rule = (StdArrangementMatchRule)value2;
                boolean allowModifications = this.allowModifications(rule);
                ArrangementUiComponent ruleComponent = ArrangementMatchingRulesControl.this.myFactory.getComponent(rule.getMatcher().getCondition(), rule, allowModifications);
                component2 = new ArrangementListRowDecorator(ruleComponent, ArrangementMatchingRulesControl.this);
                component2.setError(ArrangementMatchingRulesControl.this.getValidator().validate(row2));
                ArrangementMatchingRulesControl.this.myComponents.set(row2, component2);
            }
            component2.setUnderMouse(ArrangementMatchingRulesControl.this.myRowUnderMouse == row2);
            component2.setRowIndex(ArrangementMatchingRulesControl.this.myEditorRow >= 0 && row2 > ArrangementMatchingRulesControl.this.myEditorRow ? row2 : row2 + 1);
            component2.setSelected(ArrangementMatchingRulesControl.this.getSelectionModel().isSelectedIndex(row2) || ArrangementMatchingRulesControl.this.myEditorRow >= 0 && row2 == ArrangementMatchingRulesControl.this.myEditorRow - 1);
            component2.setBeingEdited(ArrangementMatchingRulesControl.this.myEditorRow >= 0 && ArrangementMatchingRulesControl.this.myEditorRow == row2 + 1);
            boolean showSortIcon = value2 instanceof StdArrangementMatchRule && StdArrangementTokens.Order.BY_NAME.equals((Object)((StdArrangementMatchRule)value2).getOrderType());
            component2.setShowSortIcon(showSortIcon);
            return component2.getUiComponent();
        }
    }
}

