/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.IndentData;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiFile;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public final class CommentUtil
extends CommentUtilCore {
    private CommentUtil() {
    }

    public static IndentData getMinLineIndent(Document document, int line1, int line2, @NotNull PsiFile file2) {
        if (file2 == null) {
            CommentUtil.$$$reportNull$$$0(0);
        }
        CharSequence chars = document.getCharsSequence();
        IndentData minIndent = null;
        for (int line = line1; line <= line2; ++line) {
            int lineStart = document.getLineStartOffset(line);
            int textStart = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (String)" \t");
            if (textStart >= document.getTextLength()) {
                textStart = document.getTextLength();
            } else {
                char c = chars.charAt(textStart);
                if (c == '\n' || c == '\r') continue;
            }
            IndentData indent = IndentData.createFrom(chars, lineStart, textStart, CodeStyle.getIndentOptions((PsiFile)file2).TAB_SIZE);
            minIndent = IndentData.min(minIndent, indent);
        }
        if (minIndent == null && line1 == line2 && line1 < document.getLineCount() - 1) {
            return CommentUtil.getMinLineIndent(document, line1 + 1, line1 + 1, file2);
        }
        return minIndent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/CommentUtil", "getMinLineIndent"));
    }
}

