/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedTagInsertHandler
extends XmlTagInsertHandler {
    private static final Logger LOG = Logger.getInstance(ExtendedTagInsertHandler.class);
    protected final String myElementName;
    @Nullable
    protected final String myNamespace;
    @Nullable
    protected final String myNamespacePrefix;

    public ExtendedTagInsertHandler(String elementName, @Nullable String namespace, @Nullable String namespacePrefix) {
        this.myElementName = elementName;
        this.myNamespace = namespace;
        this.myNamespacePrefix = namespacePrefix;
    }

    @Override
    public void handleInsert(final @NotNull InsertionContext context2, final @NotNull LookupElement item) {
        if (context2 == null) {
            ExtendedTagInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            ExtendedTagInsertHandler.$$$reportNull$$$0(1);
        }
        XmlFile contextFile = (XmlFile)context2.getFile();
        XmlExtension extension2 = XmlExtension.getExtension((PsiFile)contextFile);
        final XmlFile file2 = extension2.getContainingFile((PsiElement)contextFile);
        final Project project = context2.getProject();
        assert (file2 != null);
        PsiElement psiElement = file2.findElementAt(context2.getStartOffset());
        assert (psiElement != null);
        if (this.isNamespaceBound(psiElement)) {
            this.doDefault(context2, item);
            return;
        }
        final Editor editor2 = context2.getEditor();
        final Document document = editor2.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int caretOffset = editor2.getCaretModel().getOffset();
        final RangeMarker caretMarker = document.createRangeMarker(caretOffset, caretOffset);
        caretMarker.setGreedyToRight(true);
        XmlNamespaceHelper.Runner<String, IncorrectOperationException> runAfter = new XmlNamespaceHelper.Runner<String, IncorrectOperationException>(){

            @Override
            public void run(String namespacePrefix) {
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                PsiElement element2 = file2.findElementAt(context2.getStartOffset());
                if (element2 != null) {
                    ExtendedTagInsertHandler.this.qualifyWithPrefix(namespacePrefix, element2, document);
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                }
                editor2.getCaretModel().moveToOffset(caretMarker.getEndOffset());
                ExtendedTagInsertHandler.this.doDefault(context2, item);
            }
        };
        try {
            String prefixByNamespace = ExtendedTagInsertHandler.getPrefixByNamespace(file2, this.myNamespace);
            if (this.myNamespacePrefix != null || StringUtil.isEmpty((String)prefixByNamespace)) {
                String nsPrefix = this.myNamespacePrefix == null ? ExtendedTagInsertHandler.suggestPrefix(file2, this.myNamespace) : this.myNamespacePrefix;
                XmlNamespaceHelper.getHelper((PsiFile)file2).insertNamespaceDeclaration(file2, editor2, Collections.singleton(this.myNamespace), nsPrefix, runAfter);
                FeatureUsageTracker.getInstance().triggerFeatureUsed("tag.name.completion");
            } else {
                runAfter.run(prefixByNamespace);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void doDefault(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        if (context2 == null) {
            ExtendedTagInsertHandler.$$$reportNull$$$0(2);
        }
        if (item == null) {
            ExtendedTagInsertHandler.$$$reportNull$$$0(3);
        }
        super.handleInsert(context2, item);
    }

    protected boolean isNamespaceBound(PsiElement psiElement) {
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof XmlTag)) {
            return false;
        }
        XmlTag tag2 = (XmlTag)parent;
        XmlElementDescriptor tagDescriptor = tag2.getDescriptor();
        String tagNamespace = tag2.getNamespace();
        assert (this.myNamespace != null);
        return tagDescriptor != null && !(tagDescriptor instanceof AnyXmlElementDescriptor) && this.myNamespace.equals(tagNamespace);
    }

    @Nullable
    public static String getPrefixByNamespace(XmlFile file2, String namespace) {
        XmlTag tag2 = file2.getRootTag();
        return tag2 == null ? null : tag2.getPrefixByNamespace(namespace);
    }

    @Nullable
    public static String suggestPrefix(XmlFile file2, @Nullable String namespace) {
        if (namespace == null) {
            return null;
        }
        for (XmlSchemaProvider provider2 : XmlSchemaProvider.getAvailableProviders((XmlFile)file2)) {
            String prefix = provider2.getDefaultPrefix(namespace, file2);
            if (prefix == null) continue;
            return prefix;
        }
        return null;
    }

    protected Set<String> getNamespaces(XmlFile file2) {
        return XmlNamespaceHelper.getHelper((PsiFile)file2).getNamespacesByTagName(this.myElementName, file2);
    }

    protected void qualifyWithPrefix(String namespacePrefix, PsiElement element2, Document document) {
        ExtendedTagInsertHandler.qualifyWithPrefix(namespacePrefix, element2);
    }

    public static void qualifyWithPrefix(String namespacePrefix, PsiElement element2) {
        String prefix;
        PsiElement tag2 = element2.getParent();
        if (tag2 instanceof XmlTag && !(prefix = ((XmlTag)tag2).getNamespacePrefix()).equals(namespacePrefix) && StringUtil.isNotEmpty((String)namespacePrefix)) {
            String toInsert = namespacePrefix + ":";
            Document document = element2.getContainingFile().getViewProvider().getDocument();
            assert (document != null);
            ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag2.getNode());
            ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag2.getNode());
            if (endTagName != null) {
                document.insertString(endTagName.getStartOffset(), (CharSequence)toInsert);
            }
            if (startTagName != null) {
                document.insertString(startTagName.getStartOffset(), (CharSequence)toInsert);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/ExtendedTagInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doDefault";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

