/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.StartOnlyMatcher;
import com.intellij.codeInsight.completion.TagNameReferenceCompletionProvider;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.html.impl.util.MicrodataUtil;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.documentation.MimeTypeDictionary;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final String[] TARGET = new String[]{"_blank", "_top", "_self", "_parent"};
    public static final String[] ENCTYPE = new String[]{"multipart/form-data", "application/x-www-form-urlencoded"};
    public static final String[] REL = new String[]{"alternate", "author", "bookmark", "help", "icon", "license", "next", "nofollow", "noreferrer", "noopener", "prefetch", "prev", "search", "stylesheet", "tag", "start", "contents", "index", "glossary", "copyright", "chapter", "section", "subsection", "appendix", "script", "import", "apple-touch-icon", "apple-touch-icon-precomposed", "apple-touch-startup-image"};
    public static final String[] MEDIA = new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
    public static final String[] LANGUAGE = new String[]{"JavaScript", "VBScript", "JScript", "JavaScript1.2", "JavaScript1.3", "JavaScript1.4", "JavaScript1.5"};
    public static final String[] TYPE = new String[]{"text/css", "text/html", "text/plain", "text/xml"};
    public static final String[] SANDBOX = new String[]{"allow-forms", "allow-pointer-lock", "allow-popups", "allow-same-origin", "allow-scripts", "allow-top-navigation"};
    public static final String[] LANG = new String[]{"aa", "ab", "ae", "af", "ak", "am", "an", "ar", "as", "av", "ay", "az", "ba", "be", "bg", "bh", "bi", "bm", "bn", "bo", "br", "bs", "ca", "ce", "ch", "co", "cr", "cs", "cu", "cv", "cy", "da", "de", "dv", "dz", "ee", "el", "en", "eo", "es", "et", "eu", "fa", "ff", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "gv", "ha", "he", "hi", "ho", "hr", "ht", "hu", "hy", "hz", "ia", "id", "ie", "ig", "ii", "ik", "io", "is", "it", "iu", "ja", "jv", "ka", "kg", "ki", "kj", "kk", "kl", "km", "kn", "ko", "kr", "ks", "ku", "kv", "kw", "ky", "la", "lb", "lg", "li", "ln", "lo", "lt", "lu", "lv", "mg", "mh", "mi", "mk", "ml", "mn", "mr", "ms", "mt", "my", "na", "nb", "nd", "ne", "ng", "nl", "nn", "no", "nr", "nv", "ny", "oc", "oj", "om", "or", "os", "pa", "pi", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sc", "sd", "se", "sg", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ty", "ug", "uk", "ur", "uz", "ve", "vi", "vo", "wa", "wo", "xh", "yi", "yo", "za", "zh", "zu"};

    public HtmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue()), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
                PsiElement position;
                if (parameters2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!HtmlCompletionContributor.hasHtmlAttributesCompletion(position = parameters2.getPosition())) {
                    return;
                }
                XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttributeValue.class, (boolean)false);
                if (attributeValue != null && attributeValue.getParent() instanceof XmlAttribute) {
                    for (String element2 : HtmlCompletionContributor.addSpecificCompletions((XmlAttribute)attributeValue.getParent())) {
                        result2.addElement((LookupElement)LookupElementBuilder.create((String)element2));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/HtmlCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.extend(CompletionType.BASIC, HtmlCompletionContributor.getHtmlElementInTextPattern(), new HtmlElementInTextCompletionProvider());
    }

    public static boolean hasHtmlAttributesCompletion(PsiElement position) {
        if (PsiTreeUtil.getParentOfType((PsiElement)position, HtmlTag.class, (boolean)false) != null) {
            return true;
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)position, XmlTag.class, (boolean)false);
        return xmlTag != null && xmlTag.getLanguage() == XHTMLLanguage.INSTANCE;
    }

    public static @NonNls String @NotNull [] addSpecificCompletions(XmlAttribute attribute) {
        String namespace;
        @NonNls String name2 = attribute.getName();
        XmlTag tag2 = attribute.getParent();
        if (tag2 == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                HtmlCompletionContributor.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        @NonNls String tagName = tag2.getName();
        if (tag2.getDescriptor() instanceof HtmlElementDescriptorImpl) {
            name2 = StringUtil.toLowerCase((String)name2);
            tagName = StringUtil.toLowerCase((String)tagName);
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespace = tag2.getNamespace()) || "http://www.w3.org/1999/html".equals(namespace)) {
            if ("target".equals(name2) || "formtarget".equals(name2)) {
                if (TARGET == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(1);
                }
                return TARGET;
            }
            if (("lang".equals(name2) || "xml:lang".equals(name2)) && tagName.equalsIgnoreCase("html")) {
                if (LANG == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(2);
                }
                return LANG;
            }
            if ("enctype".equals(name2)) {
                if (ENCTYPE == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(3);
                }
                return ENCTYPE;
            }
            if ("rel".equals(name2) || "rev".equals(name2)) {
                if (REL == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(4);
                }
                return REL;
            }
            if ("media".equals(name2)) {
                if (MEDIA == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(5);
                }
                return MEDIA;
            }
            if ("language".equals(name2)) {
                if (LANGUAGE == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(6);
                }
                return LANGUAGE;
            }
            if ("sandbox".equals(name2)) {
                if (SANDBOX == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(7);
                }
                return SANDBOX;
            }
            if ("type".equals(name2) && "link".equals(tagName)) {
                if (TYPE == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(8);
                }
                return TYPE;
            }
            if ("http-equiv".equals(name2) && "meta".equals(tagName)) {
                if (HtmlUtil.RFC2616_HEADERS == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(9);
                }
                return HtmlUtil.RFC2616_HEADERS;
            }
            if ("content".equals(name2) && "meta".equals(tagName) && tag2.getAttribute("name") == null) {
                if (MimeTypeDictionary.HTML_CONTENT_TYPES == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(10);
                }
                return MimeTypeDictionary.HTML_CONTENT_TYPES;
            }
            if ("accept".equals(name2) && "input".equals(tagName)) {
                if (MimeTypeDictionary.HTML_CONTENT_TYPES == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(11);
                }
                return MimeTypeDictionary.HTML_CONTENT_TYPES;
            }
            if ("accept-charset".equals(name2) || "charset".equals(name2)) {
                Charset[] charSets = CharsetToolkit.getAvailableCharsets();
                String[] names2 = new String[charSets.length];
                for (int i2 = 0; i2 < names2.length; ++i2) {
                    names2[i2] = charSets[i2].toString();
                }
                if (names2 == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(12);
                }
                return names2;
            }
            if ("itemprop".equals(name2) && !DumbService.isDumb((Project)attribute.getProject())) {
                XmlTag scopeTag = MicrodataUtil.findScopeTag(tag2);
                String[] stringArray = scopeTag != null ? HtmlCompletionContributor.findItemProperties(scopeTag) : ArrayUtilRt.EMPTY_STRING_ARRAY;
                if (stringArray == null) {
                    HtmlCompletionContributor.$$$reportNull$$$0(13);
                }
                return stringArray;
            }
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(14);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static String[] findItemProperties(@NotNull XmlTag tag2) {
        XmlAttribute typeAttribute;
        if (tag2 == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(15);
        }
        if ((typeAttribute = tag2.getAttribute("itemtype")) != null) {
            XmlAttributeValue valueElement = typeAttribute.getValueElement();
            PsiReference[] references = valueElement != null ? valueElement.getReferences() : PsiReference.EMPTY_ARRAY;
            ArrayList<String> result2 = new ArrayList<String>();
            for (PsiReference reference2 : references) {
                PsiElement target2;
                PsiElement psiElement = target2 = reference2 != null ? reference2.resolve() : null;
                if (!(target2 instanceof PsiFile)) continue;
                result2.addAll(MicrodataUtil.extractProperties((PsiFile)target2, StringUtil.unquoteString((String)reference2.getCanonicalText())));
            }
            return ArrayUtilRt.toStringArray(result2);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Contract(value="null->false")
    private static boolean shouldTryDeselectingFirstPopupItem(@Nullable Lookup lookup2) {
        PsiFile file2 = (PsiFile)ObjectUtils.doIfNotNull((Object)lookup2, Lookup::getPsiFile);
        if (!(file2 instanceof HtmlFileImpl)) {
            return false;
        }
        PsiElement element2 = lookup2.getPsiElement();
        if (element2 == null) {
            return false;
        }
        IElementType elementType = element2.getNode().getElementType();
        if ((elementType == XmlTokenType.XML_DATA_CHARACTERS || element2.getNode().getElementType() == XmlTokenType.XML_WHITE_SPACE) && (element2.getParent() instanceof XmlText || element2.getParent() instanceof XmlDocument)) {
            return !element2.getText().endsWith("<");
        }
        if (elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            return element2.getText().contains("&");
        }
        return false;
    }

    @ApiStatus.Internal
    public static ElementPattern<PsiElement> getHtmlElementInTextPattern() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)XmlTokenType.XML_DATA_CHARACTERS).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(XmlText.class), PlatformPatterns.psiElement(XmlDocument.class)}))).inFile((ElementPattern)PlatformPatterns.psiFile(HtmlFileImpl.class));
    }

    @ApiStatus.Internal
    public static CompletionResultSet patchResultSetForHtmlElementInTextCompletion(@NotNull CompletionResultSet result2, @NotNull CompletionParameters parameters2) {
        if (result2 == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(16);
        }
        if (parameters2 == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(17);
        }
        result2 = result2.withRelevanceSorter(HtmlCompletionContributor.withoutLiveTemplatesWeigher(null, parameters2, result2.getPrefixMatcher()));
        if (parameters2.getInvocationCount() == 0) {
            result2 = result2.withPrefixMatcher((PrefixMatcher)new StartOnlyMatcher(result2.getPrefixMatcher()));
        }
        return result2;
    }

    @ApiStatus.Internal
    public static boolean canProvideHtmlElementInTextCompletion(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(18);
        }
        return ContainerUtil.and((Iterable)parameters2.getOriginalFile().getViewProvider().getAllFiles(), f -> f instanceof HtmlFileImpl);
    }

    private static CompletionSorter withoutLiveTemplatesWeigher(@Nullable CompletionSorter sorter, @NotNull CompletionParameters parameters2, @NotNull PrefixMatcher prefixMatcher) {
        if (parameters2 == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(19);
        }
        if (prefixMatcher == null) {
            HtmlCompletionContributor.$$$reportNull$$$0(20);
        }
        if (sorter == null) {
            sorter = CompletionService.getCompletionService().defaultSorter(parameters2, prefixMatcher);
        }
        return ((CompletionSorterImpl)sorter).withoutClassifiers(f -> "templates".equals(f.getId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/HtmlCompletionContributor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addSpecificCompletions";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/HtmlCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findItemProperties";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "patchResultSetForHtmlElementInTextCompletion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canProvideHtmlElementInTextCompletion";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withoutLiveTemplatesWeigher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HtmlElementInTextLookupManagerListener
    implements LookupManagerListener {
        @Override
        public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
            if (newLookup instanceof LookupImpl && HtmlCompletionContributor.shouldTryDeselectingFirstPopupItem(newLookup)) {
                final LookupImpl lookup2 = (LookupImpl)newLookup;
                lookup2.setPrefixChangeListener(new PrefixChangeListener(){

                    @Override
                    public void afterAppend(char c) {
                        if (lookup2.getCurrentItemOrEmpty() == null && HtmlElementInTextLookupManagerListener.hasTwoCharsAfterAmp(lookup2)) {
                            lookup2.setSelectedIndex(0);
                        }
                    }
                });
                lookup2.addLookupListener(new LookupListener(){

                    public void uiRefreshed() {
                        CompletionProcess currentCompletion = CompletionService.getCompletionService().getCurrentCompletion();
                        if (currentCompletion != null && currentCompletion.isAutopopupCompletion() && !lookup2.isSelectionTouched() && !HtmlElementInTextLookupManagerListener.hasTwoCharsAfterAmp(lookup2)) {
                            lookup2.getList().setSelectedValue(null, false);
                            ListSelectionModel selectionModel = lookup2.getList().getSelectionModel();
                            selectionModel.setAnchorSelectionIndex(-1);
                            selectionModel.setLeadSelectionIndex(-1);
                        }
                    }
                });
            }
        }

        private static boolean hasTwoCharsAfterAmp(LookupImpl lookup2) {
            int start2 = Math.max(lookup2.getLookupStart() - 1, 0);
            int end = lookup2.getEditor().getCaretModel().getOffset();
            if (end - start2 < 3) {
                return false;
            }
            Document doc = lookup2.getEditor().getDocument();
            return doc.getTextLength() > start2 && doc.getCharsSequence().charAt(start2) == '&';
        }
    }

    private static class HtmlElementInTextCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private HtmlElementInTextCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            if (parameters2 == null) {
                HtmlElementInTextCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                HtmlElementInTextCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                HtmlElementInTextCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!HtmlCompletionContributor.canProvideHtmlElementInTextCompletion(parameters2)) {
                return;
            }
            if (parameters2.getPosition().getContainingFile().isPhysical()) {
                return;
            }
            PsiFile completionFile = parameters2.getPosition().getContainingFile();
            int offset = parameters2.getOffset();
            OffsetsInFile offsets2 = new OffsetsInFile(completionFile);
            offsets2.getOffsets().addOffset(CompletionInitializationContext.START_OFFSET, offset);
            offsets2 = offsets2.copyWithReplacement(offset, offset, "<");
            PsiElement tag2 = (PsiElement)ObjectUtils.doIfNotNull((Object)offsets2.getFile().findElementAt(offset + 1), PsiElement::getParent);
            if (tag2 instanceof XmlTag) {
                CompletionResultSet patchedResultSet = HtmlCompletionContributor.patchResultSetForHtmlElementInTextCompletion(result2, parameters2);
                for (LookupElement variant : TagNameReferenceCompletionProvider.getTagNameVariants((XmlTag)tag2, "")) {
                    LookupElementDecorator<LookupElement> decorated = new LookupElementDecorator<LookupElement>(variant){

                        @NotNull
                        public String getLookupString() {
                            String string = "<" + super.getLookupString();
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        public void renderElement(LookupElementPresentation presentation2) {
                            super.renderElement(presentation2);
                            presentation2.setItemText("<" + presentation2.getItemText());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/HtmlCompletionContributor$HtmlElementInTextCompletionProvider$1", "getLookupString"));
                        }
                    };
                    if (variant instanceof PrioritizedLookupElement) {
                        decorated = PrioritizedLookupElement.withGrouping((LookupElement)PrioritizedLookupElement.withExplicitProximity((LookupElement)PrioritizedLookupElement.withPriority((LookupElement)decorated, (double)((PrioritizedLookupElement)variant).getPriority()), (int)((PrioritizedLookupElement)variant).getExplicitProximity()), (int)((PrioritizedLookupElement)variant).getGrouping());
                    }
                    patchedResultSet.consume((LookupElement)decorated);
                }
                patchedResultSet.runRemainingContributors(parameters2, r -> patchedResultSet.withPrefixMatcher(r.getPrefixMatcher()).withRelevanceSorter(HtmlCompletionContributor.withoutLiveTemplatesWeigher(r.getSorter(), parameters2, r.getPrefixMatcher())).addElement(r.getLookupElement()));
            }
            if (result2.getPrefixMatcher().getPrefix().length() < 2) {
                result2.restartCompletionOnAnyPrefixChange();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/HtmlCompletionContributor$HtmlElementInTextCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

