/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.impl.source.xml.XmlAttributeReference;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final Logger LOG = Logger.getInstance(XmlAttributeReferenceCompletionProvider.class);

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        PsiReference reference2;
        if (parameters2 == null) {
            XmlAttributeReferenceCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            XmlAttributeReferenceCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            XmlAttributeReferenceCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((reference2 = parameters2.getPosition().getContainingFile().findReferenceAt(parameters2.getOffset())) instanceof XmlAttributeReference) {
            XmlAttributeReferenceCompletionProvider.addAttributeReferenceCompletionVariants((XmlAttributeReference)reference2, result2, null);
        }
    }

    public static void addAttributeReferenceCompletionVariants(XmlAttributeReference reference2, CompletionResultSet result2, @Nullable InsertHandler<LookupElement> replacementInsertHandler) {
        XmlTag declarationTag = reference2.getElement().getParent();
        LOG.assertTrue(declarationTag.isValid());
        XmlElementDescriptor parentDescriptor = declarationTag.getDescriptor();
        if (parentDescriptor != null) {
            XmlAttribute[] attributes2 = declarationTag.getAttributes();
            XmlAttributeDescriptor[] descriptors = parentDescriptor.getAttributesDescriptors(declarationTag);
            descriptors = HtmlUtil.appendHtmlSpecificAttributeCompletions(declarationTag, descriptors, reference2.getElement());
            XmlAttributeReferenceCompletionProvider.addVariants(result2, attributes2, descriptors, reference2.getElement(), replacementInsertHandler);
        }
    }

    private static void addVariants(CompletionResultSet result2, XmlAttribute[] attributes2, XmlAttributeDescriptor[] descriptors, XmlAttribute attribute, @Nullable InsertHandler<LookupElement> replacementInsertHandler) {
        XmlTag tag2 = attribute.getParent();
        PsiFile file2 = tag2.getContainingFile();
        XmlExtension extension2 = XmlExtension.getExtension(file2);
        String prefix = attribute.getName().contains(":") && XmlAttributeImpl.getRealName(attribute).length() > 0 ? attribute.getNamespacePrefix() + ":" : null;
        for (XmlAttributeDescriptor descriptor2 : descriptors) {
            int separator2;
            if (!XmlAttributeReferenceCompletionProvider.isValidVariant(attribute, descriptor2, attributes2, extension2)) continue;
            String name2 = descriptor2.getName((PsiElement)tag2);
            XmlAttributeInsertHandler insertHandler = XmlAttributeInsertHandler.INSTANCE;
            if (tag2 instanceof HtmlTag && HtmlUtil.isShortNotationOfBooleanAttributePreferred() && HtmlUtil.isBooleanAttribute(descriptor2, (PsiElement)tag2)) {
                insertHandler = null;
            }
            if (replacementInsertHandler != null) {
                insertHandler = replacementInsertHandler;
            } else if (descriptor2 instanceof NamespaceAwareXmlAttributeDescriptor) {
                String namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor2).getNamespace(tag2);
                if (file2 instanceof XmlFile && namespace != null && namespace.length() > 0 && !name2.contains(":") && tag2.getPrefixByNamespace(namespace) == null) {
                    insertHandler = new XmlAttributeInsertHandler(namespace);
                }
            }
            if (prefix != null && !name2.startsWith(prefix)) continue;
            if (prefix != null && name2.length() > prefix.length()) {
                name2 = descriptor2.getName((PsiElement)tag2).substring(prefix.length());
            }
            LookupElementBuilder element2 = LookupElementBuilder.create((String)name2);
            if (descriptor2 instanceof PsiPresentableMetaData) {
                PsiPresentableMetaData presentableMetaData = (PsiPresentableMetaData)descriptor2;
                element2 = element2.withIcon(presentableMetaData.getIcon());
                String typeName = presentableMetaData.getTypeName();
                if (!StringUtil.isEmpty((String)typeName)) {
                    element2 = element2.withTypeText(typeName);
                }
            }
            if ((separator2 = name2.indexOf(58)) > 0) {
                element2 = element2.withLookupString(name2.substring(separator2 + 1));
            }
            element2 = element2.withCaseSensitivity(!(descriptor2 instanceof HtmlAttributeDescriptorImpl) || ((HtmlAttributeDescriptorImpl)descriptor2).isCaseSensitive()).withInsertHandler(insertHandler);
            result2.addElement((LookupElement)(descriptor2.isRequired() ? PrioritizedLookupElement.withPriority((LookupElement)element2.appendTailText("(required)", true), (double)100.0) : (HtmlUtil.isOwnHtmlAttribute(descriptor2) ? PrioritizedLookupElement.withPriority((LookupElement)element2, (double)50.0) : element2)));
        }
    }

    public static boolean isValidVariant(XmlAttribute attribute, @NotNull XmlAttributeDescriptor descriptor2, XmlAttribute[] attributes2, XmlExtension extension2) {
        if (descriptor2 == null) {
            XmlAttributeReferenceCompletionProvider.$$$reportNull$$$0(3);
        }
        if (extension2.isIndirectSyntax(descriptor2)) {
            return false;
        }
        String descriptorName = descriptor2.getName((PsiElement)attribute.getParent());
        if (descriptorName == null) {
            LOG.error("Null descriptor name for " + descriptor2 + " " + descriptor2.getClass() + " ");
            return false;
        }
        for (XmlAttribute otherAttr : attributes2) {
            if (otherAttr == attribute || !otherAttr.getName().equals(descriptorName)) continue;
            return false;
        }
        return !descriptorName.contains("IntellijIdeaRulezzz");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/XmlAttributeReferenceCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidVariant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

