/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.editorActions.XmlAutoPopupHandler;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;

public class XmlCharFilter
extends CharFilter {
    public static boolean isInXmlContext(Lookup lookup2) {
        if (!lookup2.isCompletion()) {
            return false;
        }
        PsiElement psiElement = lookup2.getPsiElement();
        PsiFile file2 = lookup2.getPsiFile();
        if (!(file2 instanceof XmlFile) && psiElement != null) {
            file2 = psiElement.getContainingFile();
        }
        if (file2 instanceof XmlFile) {
            if (psiElement != null) {
                Language language2;
                PsiElement elementToTest = psiElement;
                if (elementToTest instanceof PsiWhiteSpace) {
                    elementToTest = elementToTest.getParent();
                }
                if (!((language2 = elementToTest.getLanguage()) instanceof XMLLanguage)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isWithinTag(Lookup lookup2) {
        if (XmlCharFilter.isInXmlContext(lookup2)) {
            PsiElement parentElement;
            PsiElement psiElement = lookup2.getPsiElement();
            PsiElement psiElement2 = parentElement = psiElement != null ? psiElement.getParent() : null;
            if (parentElement instanceof XmlTag) {
                return true;
            }
            if (parentElement instanceof PsiErrorElement && parentElement.getParent() instanceof XmlDocument) {
                return true;
            }
            return !(!(parentElement instanceof XmlDocument) && !(parentElement instanceof XmlText) || !psiElement.textMatches((CharSequence)"<") && !psiElement.textMatches((CharSequence)"\""));
        }
        return false;
    }

    @Override
    public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup2) {
        if (!XmlCharFilter.isInXmlContext(lookup2)) {
            return null;
        }
        if (Character.isJavaIdentifierPart(c)) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        switch (c) {
            case '-': 
            case ':': 
            case '?': {
                return CharFilter.Result.ADD_TO_PREFIX;
            }
            case '/': {
                if (XmlCharFilter.isWithinTag(lookup2)) {
                    if (prefixLength > 0) {
                        return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                    }
                    XmlAutoPopupHandler.autoPopupXmlLookup(lookup2.getProject(), lookup2.getEditor());
                    return CharFilter.Result.HIDE_LOOKUP;
                }
                return CharFilter.Result.ADD_TO_PREFIX;
            }
            case '>': {
                if (prefixLength > 0) {
                    return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                }
            }
            case '\"': 
            case '\'': {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
        }
        return null;
    }
}

