/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ExternalToolPassFactory;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(ExternalToolPass.class);
    private final AnnotationHolderImpl myAnnotationHolder;
    private final ExternalToolPassFactory myExternalToolPassFactory;
    private final boolean myMainHighlightingPass;
    private final List<MyData<?, ?>> myAnnotationData;

    ExternalToolPass(@NotNull ExternalToolPassFactory factory2, @NotNull PsiFile file2, @NotNull Editor editor2, int startOffset, int endOffset) {
        if (factory2 == null) {
            ExternalToolPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ExternalToolPass.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            ExternalToolPass.$$$reportNull$$$0(2);
        }
        this(factory2, file2, editor2.getDocument(), editor2, startOffset, endOffset, new DefaultHighlightInfoProcessor(), false);
    }

    ExternalToolPass(@NotNull ExternalToolPassFactory factory2, @NotNull PsiFile file2, @NotNull Document document, @Nullable Editor editor2, int startOffset, int endOffset, @NotNull HighlightInfoProcessor processor2, boolean mainHighlightingPass) {
        if (factory2 == null) {
            ExternalToolPass.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ExternalToolPass.$$$reportNull$$$0(4);
        }
        if (document == null) {
            ExternalToolPass.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            ExternalToolPass.$$$reportNull$$$0(6);
        }
        super(file2.getProject(), document, LangBundle.message((String)"pass.external.annotators", (Object[])new Object[0]), file2, editor2, new TextRange(startOffset, endOffset), false, processor2);
        this.myAnnotationData = new ArrayList();
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2), false);
        this.myExternalToolPassFactory = factory2;
        this.myMainHighlightingPass = mainHighlightingPass;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            ExternalToolPass.$$$reportNull$$$0(7);
        }
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        HighlightingLevelManager highlightingManager = HighlightingLevelManager.getInstance(this.myProject);
        HashMap<PsiFile, List> allAnnotators = new HashMap<PsiFile, List>();
        int externalAnnotatorsInRoots = 0;
        InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        Function custom = (Function)this.myFile.getUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY);
        InspectionProfileImpl profile = custom != null ? ((InspectionProfileWrapper)custom.apply(currentProfile)).getInspectionProfile() : currentProfile;
        for (Language language2 : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language2);
            if (!highlightingManager.shouldInspect((PsiElement)psiRoot)) continue;
            List annotators = ExternalLanguageAnnotators.allForFile((Language)language2, (PsiFile)psiRoot);
            if ((annotators = ContainerUtil.filter((Collection)annotators, annotator -> {
                String shortName = annotator.getPairedBatchInspectionShortName();
                if (shortName != null) {
                    HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
                    if (key == null) {
                        if (!ApplicationManager.getApplication().isUnitTestMode()) {
                            ExternalToolPass.processError(new Exception("Paired tool '" + shortName + "' not found"), annotator, psiRoot);
                        }
                        return false;
                    }
                    return profile.isToolEnabled(key, (PsiElement)this.myFile);
                }
                return true;
            })).isEmpty()) continue;
            externalAnnotatorsInRoots += annotators.size();
            allAnnotators.put(psiRoot, annotators);
        }
        this.setProgressLimit(externalAnnotatorsInRoots);
        boolean errorFound = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().wasErrorFound(this.myDocument);
        Editor editor2 = this.getEditor();
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        for (Map.Entry entry2 : allAnnotators.entrySet()) {
            PsiFile psiRoot = (PsiFile)entry2.getKey();
            List annotators = (List)entry2.getValue();
            for (ExternalAnnotator annotator2 : annotators) {
                progress2.checkCanceled();
                if (dumbService.isDumb() && !DumbService.isDumbAware((Object)annotator2)) continue;
                Object collectedInfo = null;
                try {
                    collectedInfo = editor2 != null ? annotator2.collectInformation(psiRoot, editor2, errorFound) : annotator2.collectInformation(psiRoot);
                }
                catch (Throwable t) {
                    ExternalToolPass.processError(t, annotator2, psiRoot);
                }
                if (collectedInfo != null) {
                    this.myAnnotationData.add(new MyData(annotator2, psiRoot, collectedInfo));
                }
                this.advanceProgress(1L);
            }
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        if (this.myProject.isDisposed()) {
            List<HighlightInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                ExternalToolPass.$$$reportNull$$$0(8);
            }
            return list2;
        }
        if (this.myMainHighlightingPass) {
            this.doAnnotate();
            this.doApply();
            return this.getHighlights();
        }
        List<HighlightInfo> list3 = super.getInfos();
        if (list3 == null) {
            ExternalToolPass.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @Override
    protected void applyInformationWithProgress() {
        final long modificationStampBefore = this.myDocument.getModificationStamp();
        Update update2 = new Update(this.myFile){

            public void setRejected() {
                super.setRejected();
                ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
            }

            public void run() {
                if (!ExternalToolPass.this.documentChanged(modificationStampBefore) && !ExternalToolPass.this.myProject.isDisposed()) {
                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)ExternalToolPass.this.myProject, () -> {
                        ExternalToolPass.runChangeAware(ExternalToolPass.this.myDocument, () -> ExternalToolPass.this.doAnnotate());
                        ReadAction.run(() -> {
                            ProgressManager.checkCanceled();
                            if (!ExternalToolPass.this.documentChanged(modificationStampBefore)) {
                                ExternalToolPass.this.doApply();
                                ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
                            }
                        });
                    });
                }
            }
        };
        this.myExternalToolPassFactory.scheduleExternalActivity(update2);
    }

    private boolean documentChanged(long modificationStampBefore) {
        return this.myDocument.getModificationStamp() != modificationStampBefore;
    }

    private void doAnnotate() {
        for (MyData<?, ?> data2 : this.myAnnotationData) {
            ExternalToolPass.doAnnotate(data2);
        }
    }

    private static <K, V> void doAnnotate(@NotNull MyData<K, V> data2) {
        if (data2 == null) {
            ExternalToolPass.$$$reportNull$$$0(10);
        }
        try {
            data2.annotationResult = data2.annotator.doAnnotate(data2.collectedInfo);
        }
        catch (Throwable t) {
            ExternalToolPass.processError(t, data2.annotator, data2.psiRoot);
        }
    }

    private void doApply() {
        for (MyData<?, ?> data2 : this.myAnnotationData) {
            this.doApply(data2);
        }
        this.myAnnotationHolder.assertAllAnnotationsCreated();
    }

    private <K, V> void doApply(@NotNull MyData<K, V> data2) {
        if (data2 == null) {
            ExternalToolPass.$$$reportNull$$$0(11);
        }
        if (data2.annotationResult != null && data2.psiRoot != null && data2.psiRoot.isValid()) {
            try {
                this.myAnnotationHolder.applyExternalAnnotatorWithContext(data2.psiRoot, data2.annotator, data2.annotationResult);
            }
            catch (Throwable t) {
                ExternalToolPass.processError(t, data2.annotator, data2.psiRoot);
            }
        }
    }

    @NotNull
    private List<HighlightInfo> getHighlights() {
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.myAnnotationHolder.size());
        Iterator iterator2 = this.myAnnotationHolder.iterator();
        while (iterator2.hasNext()) {
            Annotation annotation = (Annotation)iterator2.next();
            infos.add(HighlightInfo.fromAnnotation(annotation));
        }
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            ExternalToolPass.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private void doFinish(List<? extends HighlightInfo> highlights, long modificationStampBefore) {
        Editor editor2 = this.getEditor();
        ModalityState modalityState = editor2 != null ? ModalityState.stateForComponent((Component)editor2.getComponent()) : ModalityState.defaultModalityState();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.documentChanged(modificationStampBefore) && !this.myProject.isDisposed()) {
                int start2 = this.myRestrictRange.getStartOffset();
                int end = this.myRestrictRange.getEndOffset();
                UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, start2, end, highlights, this.getColorsScheme(), this.getId());
                DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
            }
        }, modalityState, x -> !this.myFile.isValid());
    }

    private static void processError(Throwable t, ExternalAnnotator<?, ?> annotator, PsiFile root2) {
        if (t instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)t;
        }
        VirtualFile file2 = root2.getVirtualFile();
        String path2 = file2 != null ? file2.getPath() : root2.getName();
        String message2 = "annotator: " + annotator + " (" + annotator.getClass() + ")";
        PluginException pe = PluginException.createByClass((String)message2, (Throwable)t, annotator.getClass());
        LOG.error("ExternalToolPass: ", (Throwable)pe, new Attachment[]{new Attachment("root_path.txt", path2)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runChangeAware(@NotNull Document document, @NotNull Runnable runnable2) {
        if (document == null) {
            ExternalToolPass.$$$reportNull$$$0(13);
        }
        if (runnable2 == null) {
            ExternalToolPass.$$$reportNull$$$0(14);
        }
        final ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
        assert (currentIndicator != null);
        DocumentListener cancellingListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                currentIndicator.cancel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/ExternalToolPass$2", "documentChanged"));
            }
        };
        document.addDocumentListener(cancellingListener);
        try {
            runnable2.run();
        }
        finally {
            document.removeDocumentListener(cancellingListener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ExternalToolPass";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ExternalToolPass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doApply";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runChangeAware";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyData<K, V> {
        final ExternalAnnotator<K, V> annotator;
        final PsiFile psiRoot;
        final K collectedInfo;
        volatile V annotationResult;

        MyData(ExternalAnnotator<K, V> annotator, PsiFile psiRoot, K collectedInfo) {
            this.annotator = annotator;
            this.psiRoot = psiRoot;
            this.collectedInfo = collectedInfo;
        }
    }
}

