/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.ExternalToolPass;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExternalToolPassFactory
implements TextEditorHighlightingPassFactory,
MainHighlightingPassFactory {
    private final MergingUpdateQueue myExternalActivitiesQueue;

    private ExternalToolPassFactory(@NotNull Project project, @NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        if (project == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(0);
        }
        if (highlightingPassRegistrar == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(1);
        }
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, true, 8);
        this.myExternalActivitiesQueue = new MergingUpdateQueue("ExternalActivitiesQueue", 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)project, null, false).usePassThroughInUnitTestMode();
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        TextRange textRange;
        if (file2 == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(3);
        }
        TextRange textRange2 = textRange = FileStatusMap.getDirtyTextRange(editor2, 8) == null ? null : file2.getTextRange();
        if (textRange == null || !ExternalToolPassFactory.externalAnnotatorsDefined(file2)) {
            return null;
        }
        return new ExternalToolPass(this, file2, editor2, textRange.getStartOffset(), textRange.getEndOffset());
    }

    private static boolean externalAnnotatorsDefined(@NotNull PsiFile file2) {
        if (file2 == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(4);
        }
        for (Language language2 : file2.getViewProvider().getLanguages()) {
            List externalAnnotators = ExternalLanguageAnnotators.allForFile((Language)language2, (PsiFile)file2);
            if (externalAnnotators.isEmpty()) continue;
            return true;
        }
        return false;
    }

    void scheduleExternalActivity(@NotNull Update update2) {
        if (update2 == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(5);
        }
        this.myExternalActivitiesQueue.queue(update2);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        TextRange range2;
        if (file2 == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(6);
        }
        if (document == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(7);
        }
        if (highlightInfoProcessor == null) {
            ExternalToolPassFactory.$$$reportNull$$$0(8);
        }
        if ((range2 = file2.getTextRange()) == null || !ExternalToolPassFactory.externalAnnotatorsDefined(file2)) {
            return null;
        }
        return new ExternalToolPass(this, file2, document, null, range2.getStartOffset(), range2.getEndOffset(), highlightInfoProcessor, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingPassRegistrar";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "externalAnnotatorsDefined";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleExternalActivity";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createMainHighlightingPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class MyRegistrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        MyRegistrar() {
        }

        @Override
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            if (registrar == null) {
                MyRegistrar.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyRegistrar.$$$reportNull$$$0(1);
            }
            new ExternalToolPassFactory(project, registrar);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "registrar";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory$MyRegistrar";
            objectArray[2] = "registerHighlightingPassFactory";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

