/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.messages.MessageBusConnection;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@ApiStatus.Experimental
final class InspectionProfilerDataHolder {
    private static final Logger LOG = Logger.getInstance(InspectionProfilerDataHolder.class);
    private final Map<PsiFile, InspectionFileData> data = Collections.synchronizedMap(new FixedHashMap(10));

    static InspectionProfilerDataHolder getInstance(@NotNull Project project) {
        if (project == null) {
            InspectionProfilerDataHolder.$$$reportNull$$$0(0);
        }
        return (InspectionProfilerDataHolder)project.getService(InspectionProfilerDataHolder.class);
    }

    private InspectionProfilerDataHolder(Project project) {
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileChanged(@NotNull InspectionProfile profile) {
                if (profile == null) {
                    1.$$$reportNull$$$0(0);
                }
                InspectionProfilerDataHolder.this.clearProfileData();
            }

            public void profileActivated(@Nullable InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                InspectionProfilerDataHolder.this.clearProfileData();
            }

            public void profilesInitialized() {
                InspectionProfilerDataHolder.this.clearProfileData();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInsight/daemon/impl/InspectionProfilerDataHolder$1", "profileChanged"));
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                InspectionProfilerDataHolder.this.clearProfileData();
            }

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                InspectionProfilerDataHolder.this.clearProfileData();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InspectionProfilerDataHolder$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosing";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                InspectionProfilerDataHolder.this.clearProfileData();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                InspectionProfilerDataHolder.this.clearProfileData();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InspectionProfilerDataHolder$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePluginUnload";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void clearProfileData() {
        this.data.clear();
    }

    public void saveStats(@NotNull PsiFile file2, @NotNull List<? extends LocalInspectionsPass.InspectionContext> contexts, long totalHighlightingNanos) {
        if (file2 == null) {
            InspectionProfilerDataHolder.$$$reportNull$$$0(1);
        }
        if (contexts == null) {
            InspectionProfilerDataHolder.$$$reportNull$$$0(2);
        }
        Latencies[] latencies = new Latencies[3];
        HashMap<String, PsiElement> favoriteElement = new HashMap<String, PsiElement>();
        Arrays.setAll(latencies, __ -> new Latencies());
        for (LocalInspectionsPass.InspectionContext inspectionContext : contexts) {
            latencies[0].save(inspectionContext, inspectionContext.holder.errorStamp);
            latencies[1].save(inspectionContext, inspectionContext.holder.warningStamp);
            latencies[2].save(inspectionContext, inspectionContext.holder.otherStamp);
            if (inspectionContext.myFavoriteElement == null) continue;
            favoriteElement.putIfAbsent(inspectionContext.tool.getID(), inspectionContext.myFavoriteElement);
        }
        this.data.put(file2, new InspectionFileData(latencies, favoriteElement));
        if (LOG.isTraceEnabled()) {
            String s0 = latencies[0].topSmallestLatenciesStat("ERROR");
            String string = latencies[1].topSmallestLatenciesStat("WARNING");
            String s2 = latencies[2].topSmallestLatenciesStat("INFO");
            LOG.trace(String.format("Sort inspections: %b; total tools: %4d; total highlighting time: %4dms; in %s:", InspectionProfilerDataHolder.isInspectionSortByLatencyEnabled(), contexts.size(), totalHighlightingNanos / 1000000L, file2.getName()) + StringUtil.notNullize((String)s0) + StringUtil.notNullize((String)string) + StringUtil.notNullize((String)s2));
        }
    }

    void sort(@NotNull PsiFile file2, @NotNull List<? extends LocalInspectionsPass.InspectionContext> init2) {
        InspectionFileData data2;
        if (file2 == null) {
            InspectionProfilerDataHolder.$$$reportNull$$$0(3);
        }
        if (init2 == null) {
            InspectionProfilerDataHolder.$$$reportNull$$$0(4);
        }
        if ((data2 = this.data.get(file2)) == null) {
            return;
        }
        init2.sort((context1, context2) -> {
            String id1 = context1.tool.getID();
            String id2 = context2.tool.getID();
            for (int i2 = 0; i2 < data2.latencies.length; ++i2) {
                Latencies l = data2.latencies[i2];
                int err = InspectionProfilerDataHolder.compareLatencies(id1, id2, l.idToLatency);
                if (err == 0) continue;
                return err;
            }
            return 0;
        });
    }

    private static int compareLatencies(String id1, String id2, @NotNull Object2LongMap<String> latencies) {
        if (latencies == null) {
            InspectionProfilerDataHolder.$$$reportNull$$$0(5);
        }
        long latency1 = latencies.getOrDefault((Object)id1, Long.MAX_VALUE);
        long latency2 = latencies.getOrDefault((Object)id2, Long.MAX_VALUE);
        return Long.compare(latency1, latency2);
    }

    void retrieveFavoriteElements(@NotNull PsiFile file2, @NotNull List<? extends LocalInspectionsPass.InspectionContext> init2) {
        InspectionFileData data2;
        if (file2 == null) {
            InspectionProfilerDataHolder.$$$reportNull$$$0(6);
        }
        if (init2 == null) {
            InspectionProfilerDataHolder.$$$reportNull$$$0(7);
        }
        if ((data2 = this.data.get(file2)) == null) {
            return;
        }
        Map<String, PsiElement> favoriteElement = data2.favoriteElement;
        for (LocalInspectionsPass.InspectionContext inspectionContext : init2) {
            PsiElement element2 = favoriteElement.get(inspectionContext.tool.getID());
            if (element2 != null && !element2.isValid()) {
                element2 = null;
            }
            if (element2 == null) continue;
            inspectionContext.myFavoriteElement = element2;
        }
    }

    static boolean isInspectionSortByLatencyEnabled() {
        return Registry.is((String)"inspection.sort") && System.getProperty("no.inspection.sort") == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latencies";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InspectionProfilerDataHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "saveStats";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sort";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "compareLatencies";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "retrieveFavoriteElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Latencies {
        final Object2LongMap<String> idToLatency = new Object2LongOpenHashMap();
        long minLatency = Long.MAX_VALUE;
        String minId;

        Latencies() {
        }

        void save(@NotNull LocalInspectionsPass.InspectionContext context2, long stampOf1st) {
            long latency;
            if (context2 == null) {
                Latencies.$$$reportNull$$$0(0);
            }
            if (stampOf1st != 0L) {
                latency = stampOf1st - context2.holder.initTimeStamp;
                this.idToLatency.put((Object)context2.tool.getID(), latency);
            } else {
                latency = Long.MAX_VALUE;
            }
            if (latency < this.minLatency) {
                this.minLatency = latency;
                this.minId = context2.tool.getID();
            }
        }

        String topSmallestLatenciesStat(String mySeverity) {
            ArrayList<Pair> result2 = new ArrayList<Pair>();
            int REPORT_TOP_N = 5;
            Object2LongMap.Entry[] entries2 = (Object2LongMap.Entry[])this.idToLatency.object2LongEntrySet().toArray((Object[])new Object2LongMap.Entry[0]);
            Arrays.sort(entries2, Comparator.comparingLong(Object2LongMap.Entry::getLongValue));
            for (int i2 = 0; i2 < Math.min(REPORT_TOP_N, entries2.length); ++i2) {
                Object2LongMap.Entry entry2 = entries2[i2];
                result2.add(Pair.create((Object)((String)entry2.getKey()), (Object)entry2.getLongValue()));
            }
            if (result2.isEmpty()) {
                return null;
            }
            String s = StringUtil.join(result2, p -> String.format("    % 4dms (%s)", (Long)p.second / 1000000L, p.first), (String)"\n");
            return "\n" + this.idToLatency.size() + " inspections reported at least one " + mySeverity + "; top " + result2.size() + " smallest latencies to the first " + mySeverity + ":\n" + s;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/InspectionProfilerDataHolder$Latencies", "save"));
        }
    }

    private static class InspectionFileData {
        @NotNull
        private final @NotNull Latencies @NotNull [] latencies;
        private final Map<String, PsiElement> favoriteElement;

        private InspectionFileData(@NotNull @NotNull Latencies @NotNull [] latencies, @NotNull Map<String, PsiElement> favoriteElement) {
            if (latencies == null) {
                InspectionFileData.$$$reportNull$$$0(0);
            }
            if (favoriteElement == null) {
                InspectionFileData.$$$reportNull$$$0(1);
            }
            this.latencies = latencies;
            this.favoriteElement = favoriteElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "latencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "favoriteElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/InspectionProfilerDataHolder$InspectionFileData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

