/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XmlEnclosingTagUnwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RemoveTagAndPromoteChildrenIntentionAction
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = XmlAnalysisBundle.message((String)"xml.quickfix.remove.tag.family", (Object[])new Object[0]);
        if (string == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        XmlTag tag2;
        if (project == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(2);
        }
        if ((tag2 = RemoveTagAndPromoteChildrenIntentionAction.getTag(editor2, file2)) == null) {
            return false;
        }
        int offset = editor2.getCaretModel().getOffset();
        ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag2.getNode());
        if (startEnd == null || offset <= startEnd.getStartOffset()) {
            return true;
        }
        ASTNode endStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tag2.getNode());
        return endStart == null || offset >= startEnd.getStartOffset();
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(3);
        }
        new XmlEnclosingTagUnwrapper().unwrap(editor2, (PsiElement)RemoveTagAndPromoteChildrenIntentionAction.getTag(editor2, file2));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static XmlTag getTag(Editor editor2, PsiFile file2) {
        PsiElement parent;
        int offset = editor2.getCaretModel().getOffset();
        PsiElement element2 = file2.findElementAt(offset);
        PsiElement psiElement = parent = element2 != null ? element2.getParent() : null;
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        if (parent instanceof XmlAttribute) {
            return null;
        }
        element2 = file2.findElementAt(offset - 1);
        PsiElement psiElement2 = parent = element2 != null ? element2.getParent() : null;
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveTagAndPromoteChildrenIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveTagAndPromoteChildrenIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

