/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlNSColorProvider;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;

public class XmlNamespaceAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        if (element2 == null) {
            XmlNamespaceAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            XmlNamespaceAnnotator.$$$reportNull$$$0(1);
        }
        if (element2 instanceof XmlTag) {
            XmlTag tag2 = (XmlTag)element2;
            String namespace = tag2.getNamespace();
            for (XmlNSColorProvider provider2 : XmlNSColorProvider.EP_NAME.getExtensionList()) {
                TextRange endTagRange;
                TextAttributesKey key = provider2.getKeyForNamespace(namespace, (XmlElement)tag2);
                if (key == null) continue;
                TextRange range2 = XmlTagUtil.getStartTagRange((XmlTag)tag2);
                if (range2 != null) {
                    holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range2).textAttributes(key).create();
                }
                if ((endTagRange = XmlTagUtil.getEndTagRange((XmlTag)tag2)) != null) {
                    holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(endTagRange).textAttributes(key).create();
                }
                return;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlNamespaceAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

