/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.quickfix.BaseExtResourceAction;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchExtResourceAction
extends BaseExtResourceAction {
    private static final Logger LOG = Logger.getInstance(FetchExtResourceAction.class);
    @NonNls
    private static final String HTML_MIME = "text/html";
    @NonNls
    private static final String HTTP_PROTOCOL = "http://";
    @NonNls
    private static final String HTTPS_PROTOCOL = "https://";
    @NonNls
    private static final String FTP_PROTOCOL = "ftp://";
    @NonNls
    private static final String EXT_RESOURCES_FOLDER = "extResources";
    private final boolean myForceResultIsValid;
    private static final String KEY = "xml.intention.fetch.name";

    public FetchExtResourceAction() {
        this.myForceResultIsValid = false;
    }

    public FetchExtResourceAction(boolean forceResultIsValid) {
        this.myForceResultIsValid = forceResultIsValid;
    }

    @Override
    protected String getQuickFixKeyId() {
        return KEY;
    }

    @Override
    protected boolean isAcceptableUri(String uri) {
        return uri.startsWith(HTTP_PROTOCOL) || uri.startsWith(FTP_PROTOCOL) || uri.startsWith(HTTPS_PROTOCOL);
    }

    public static String findUrl(PsiFile file2, int offset, String uri) {
        String attrValue;
        String prefix;
        XmlTag tag2;
        PsiElement currentElement = file2.findElementAt(offset);
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlAttribute.class);
        if (attribute != null && (tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlTag.class)) != null && (prefix = tag2.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema-instance")) != null && (attrValue = tag2.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(attrValue);
            while (tokenizer.hasMoreElements()) {
                if (uri.equals(tokenizer.nextToken())) {
                    if (!tokenizer.hasMoreElements()) {
                        return uri;
                    }
                    String url = tokenizer.nextToken();
                    return url.startsWith(HTTP_PROTOCOL) ? url : uri;
                }
                if (!tokenizer.hasMoreElements()) {
                    return uri;
                }
                tokenizer.nextToken();
            }
        }
        return uri;
    }

    @NotNull
    private static Path checkExists(String dir) {
        Path path2 = Paths.get(dir, new String[0]);
        try {
            Files.createDirectories(path2, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.warn("Unable to create: " + path2, (Throwable)e);
        }
        Path path3 = path2;
        if (path3 == null) {
            FetchExtResourceAction.$$$reportNull$$$0(0);
        }
        return path3;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void doInvoke(final @NotNull PsiFile file2, int offset, final @NotNull String uri, Editor editor2) throws IncorrectOperationException {
        if (file2 == null) {
            FetchExtResourceAction.$$$reportNull$$$0(1);
        }
        if (uri == null) {
            FetchExtResourceAction.$$$reportNull$$$0(2);
        }
        final String url = FetchExtResourceAction.findUrl(file2, offset, uri);
        final Project project = file2.getProject();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, XmlBundle.message((String)"xml.intention.fetch.progress.fetching.resource", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                while (true) {
                    try {
                        HttpConfigurable.getInstance().prepareURL(url);
                        FetchExtResourceAction.this.fetchDtd(project, uri, url, indicator2);
                        ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)project).restart(file2));
                        return;
                    }
                    catch (IOException ex) {
                        LOG.info((Throwable)ex);
                        String problemUrl = ex instanceof FetchingResourceIOException ? ((FetchingResourceIOException)ex).url : url;
                        String message2 = XmlBundle.message((String)"xml.intention.fetch.error.fetching.title", (Object[])new Object[0]);
                        if (url.equals(problemUrl)) continue;
                        message2 = XmlBundle.message((String)"xml.intention.fetch.error.fetching.dependent.resource", (Object[])new Object[0]);
                        if (IOExceptionDialog.showErrorDialog((String)message2, (String)XmlBundle.message((String)"xml.intention.fetch.error.fetching.resource", (Object[])new Object[]{problemUrl}))) continue;
                        return;
                    }
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction$1", "run"));
            }
        });
    }

    private void fetchDtd(Project project, String dtdUrl, String url, ProgressIndicator indicator2) throws IOException {
        String extResourcesPath = FetchExtResourceAction.getExternalResourcesPath();
        File extResources = new File(extResourcesPath);
        LOG.assertTrue(extResources.mkdirs() || extResources.exists(), (Object)extResources);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> {
            String path2 = FileUtil.toSystemIndependentName((String)extResources.getAbsolutePath());
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
            LOG.assertTrue(vFile != null, (Object)path2);
        }));
        LinkedList<String> downloadedResources = new LinkedList<String>();
        LinkedList<String> resourceUrls = new LinkedList<String>();
        IOException[] nestedException = new IOException[1];
        try {
            String resPath = this.fetchOneFile(indicator2, url, project, extResourcesPath, null);
            if (resPath == null) {
                return;
            }
            resourceUrls.add(dtdUrl);
            downloadedResources.add(resPath);
            VirtualFile virtualFile2 = FetchExtResourceAction.findFileByPath(resPath, dtdUrl, project);
            HashSet<String> processedLinks = new HashSet<String>();
            HashMap<String, Object> baseUrls = new HashMap<String, Object>();
            HashMap<String, Object> parentRefs = new HashMap<String, Object>();
            VirtualFile contextFile = virtualFile2;
            HashSet<String> linksToProcess = new HashSet<String>(FetchExtResourceAction.extractEmbeddedFileReferences(virtualFile2, null, psiManager, url));
            while (!linksToProcess.isEmpty()) {
                String resourcePath;
                String parentRef;
                Object resourceUrl;
                boolean absoluteUrl;
                String s = (String)linksToProcess.iterator().next();
                linksToProcess.remove(s);
                processedLinks.add(s);
                boolean bl = absoluteUrl = s.startsWith(HTTP_PROTOCOL) || s.startsWith(HTTPS_PROTOCOL);
                if (absoluteUrl) {
                    resourceUrl = s;
                } else {
                    String baseUrl = (String)baseUrls.get(s);
                    if (baseUrl == null) {
                        baseUrl = url;
                    }
                    resourceUrl = baseUrl.substring(0, baseUrl.lastIndexOf(47) + 1) + s;
                    try {
                        URL base = new URL(baseUrl);
                        resourceUrl = new URL(base, s).toString();
                    }
                    catch (MalformedURLException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                Object refName = s;
                if (absoluteUrl) {
                    refName = Integer.toHexString(s.hashCode()) + "_" + ((String)refName).substring(((String)refName).lastIndexOf(47) + 1);
                } else if (!((String)refName).startsWith("/") && (parentRef = (String)parentRefs.get(refName)) != null && !parentRef.startsWith("/") && parentRef.contains("/")) {
                    refName = new File(new File(parentRef).getParent(), (String)refName).getPath();
                }
                try {
                    resourcePath = this.fetchOneFile(indicator2, (String)resourceUrl, project, extResourcesPath, (String)refName);
                }
                catch (IOException e) {
                    nestedException[0] = new FetchingResourceIOException(e, (String)resourceUrl);
                    break;
                }
                if (resourcePath != null) {
                    virtualFile2 = FetchExtResourceAction.findFileByPath(resourcePath, absoluteUrl ? s : null, project);
                    downloadedResources.add(resourcePath);
                    if (absoluteUrl) {
                        resourceUrls.add(s);
                    }
                    Set<String> newLinks = FetchExtResourceAction.extractEmbeddedFileReferences(virtualFile2, contextFile, psiManager, (String)resourceUrl);
                    for (String u : newLinks) {
                        baseUrls.put(u, resourceUrl);
                        parentRefs.put(u, refName);
                        if (processedLinks.contains(u)) continue;
                        linksToProcess.add(u);
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            nestedException[0] = ex;
        }
        if (nestedException[0] != null) {
            this.cleanup(resourceUrls, downloadedResources);
            throw nestedException[0];
        }
    }

    private static VirtualFile findFileByPath(String resPath, @Nullable String dtdUrl, Project project) {
        Ref ref = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            ref.set((Object)LocalFileSystem.getInstance().refreshAndFindFileByPath(resPath.replace(File.separatorChar, '/')));
            if (dtdUrl != null) {
                ExternalResourceManager.getInstance().addResource(dtdUrl, resPath);
            } else if (!project.isDisposed()) {
                ExternalResourceManager.getInstance().incModificationCount();
                PsiManager.getInstance((Project)project).dropPsiCaches();
            }
        }));
        return (VirtualFile)ref.get();
    }

    public static String getExternalResourcesPath() {
        return PathManager.getSystemPath() + File.separator + EXT_RESOURCES_FOLDER;
    }

    private void cleanup(final List<String> resourceUrls, final List<String> downloadedResources) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        for (String resourcesUrl : resourceUrls) {
                            ExternalResourceManager.getInstance().removeResource(resourcesUrl);
                        }
                        for (String downloadedResource : downloadedResources) {
                            VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByIoFile(new File(downloadedResource));
                            if (virtualFile2 == null) continue;
                            try {
                                virtualFile2.delete((Object)this);
                            }
                            catch (IOException iOException) {}
                        }
                    }
                });
            }
        });
    }

    @Nullable
    private String fetchOneFile(ProgressIndicator indicator2, String resourceUrl, Project project, String extResourcesPath, @Nullable String refname) throws IOException {
        SwingUtilities.invokeLater(() -> indicator2.setText(XmlBundle.message((String)"xml.intention.fetch.progress.fetching", (Object[])new Object[]{resourceUrl})));
        FetchResult result2 = FetchExtResourceAction.fetchData(project, resourceUrl, indicator2);
        if (result2 == null) {
            return null;
        }
        if (!this.resultIsValid(project, indicator2, resourceUrl, result2)) {
            return null;
        }
        String resPath = extResourcesPath + File.separatorChar;
        if (refname != null) {
            int refNameSlashIndex = (resPath = resPath + refname).lastIndexOf(47);
            if (refNameSlashIndex != -1) {
                FetchExtResourceAction.checkExists(resPath.substring(0, refNameSlashIndex));
            }
        } else {
            int slashIndex = resourceUrl.lastIndexOf(47);
            resPath = resPath + Integer.toHexString(resourceUrl.hashCode()) + "_" + resourceUrl.substring(slashIndex + 1);
        }
        int lastDoPosInResourceUrl = resourceUrl.lastIndexOf(46);
        if (lastDoPosInResourceUrl == -1 || FileTypeManager.getInstance().getFileTypeByExtension(resourceUrl.substring(lastDoPosInResourceUrl + 1)) == FileTypes.UNKNOWN) {
            String extension2 = result2.contentType != null && result2.contentType.contains(HTML_MIME) ? HtmlFileType.INSTANCE.getDefaultExtension() : XmlFileType.INSTANCE.getDefaultExtension();
            resPath = resPath + "." + extension2;
        }
        File res2 = new File(resPath);
        FileUtil.writeToFile((File)res2, (byte[])result2.bytes);
        return resPath;
    }

    private boolean resultIsValid(Project project, ProgressIndicator indicator2, String resourceUrl, FetchResult result2) {
        if (this.myForceResultIsValid) {
            return true;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && result2.contentType != null && result2.contentType.contains(HTML_MIME) && new String(result2.bytes, StandardCharsets.UTF_8).contains("<html")) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project, (String)XmlBundle.message((String)"xml.intention.fetch.error.invalid.url.no.xml.file.at.location", (Object[])new Object[]{resourceUrl}), (String)XmlBundle.message((String)"xml.intention.fetch.error.invalid.url.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()), indicator2.getModalityState());
            return false;
        }
        return true;
    }

    private static Set<String> extractEmbeddedFileReferences(XmlFile file2, XmlFile context2, String url) {
        if (context2 != null) {
            XmlEntityCache.copyEntityCaches((PsiFile)file2, (PsiFile)context2);
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        XmlUtil.processXmlElements((XmlElement)file2, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element2 -> {
            block7: {
                String schemaLocation;
                XmlTag tag2;
                block9: {
                    block8: {
                        if (!(element2 instanceof XmlEntityDecl)) break block8;
                        String candidateName = null;
                        for (PsiElement e = element2.getLastChild(); e != null; e = e.getPrevSibling()) {
                            if (e instanceof XmlAttributeValue && candidateName == null) {
                                candidateName = e.getText().substring(1, e.getTextLength() - 1);
                                continue;
                            }
                            if (!(e instanceof XmlToken) || candidateName == null || ((XmlToken)e).getTokenType() != XmlTokenType.XML_DOCTYPE_PUBLIC && ((XmlToken)e).getTokenType() != XmlTokenType.XML_DOCTYPE_SYSTEM) continue;
                            result2.add(candidateName);
                            break block7;
                        }
                        break block7;
                    }
                    if (!(element2 instanceof XmlTag)) break block7;
                    tag2 = (XmlTag)element2;
                    schemaLocation = tag2.getAttributeValue("schemaLocation");
                    if (schemaLocation == null) break block9;
                    PsiReference[] references = tag2.getAttribute("schemaLocation").getValueElement().getReferences();
                    if (references.length <= 0) break block7;
                    String extension2 = FileUtilRt.getExtension((String)new File(url).getName());
                    String namespace = tag2.getAttributeValue("namespace");
                    if (namespace != null && schemaLocation.indexOf(47) == -1 && !extension2.equals(FileUtilRt.getExtension((String)schemaLocation))) {
                        result2.add(namespace.substring(0, namespace.lastIndexOf(47) + 1) + schemaLocation);
                    } else {
                        result2.add(schemaLocation);
                    }
                    break block7;
                }
                schemaLocation = tag2.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
                if (schemaLocation != null) {
                    StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
                    while (tokenizer.hasMoreTokens()) {
                        tokenizer.nextToken();
                        if (tokenizer.hasMoreTokens()) {
                            String location = tokenizer.nextToken();
                            result2.add(location);
                            continue;
                        }
                        break;
                    }
                }
            }
            return true;
        }), true, true);
        return result2;
    }

    public static Set<String> extractEmbeddedFileReferences(VirtualFile vFile, @Nullable VirtualFile contextVFile, PsiManager psiManager, String url) {
        return (Set)ReadAction.compute(() -> {
            PsiFile file2 = psiManager.findFile(vFile);
            if (file2 instanceof XmlFile) {
                PsiFile contextFile = contextVFile != null ? psiManager.findFile(contextVFile) : null;
                return FetchExtResourceAction.extractEmbeddedFileReferences((XmlFile)file2, contextFile instanceof XmlFile ? (XmlFile)contextFile : null, url);
            }
            return Collections.emptySet();
        });
    }

    @Nullable
    private static FetchResult fetchData(Project project, String dtdUrl, ProgressIndicator indicator2) throws IOException {
        try {
            return (FetchResult)HttpRequests.request((String)dtdUrl).accept("text/xml,application/xml,text/html,*/*").connect(request2 -> {
                FetchResult result2 = new FetchResult();
                result2.bytes = request2.readBytes(indicator2);
                result2.contentType = request2.getConnection().getContentType();
                return result2;
            });
        }
        catch (MalformedURLException e) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)project, (String)XmlBundle.message((String)"xml.intention.fetch.error.invalid.url.message", (Object[])new Object[]{dtdUrl}), (String)XmlBundle.message((String)"xml.intention.fetch.error.invalid.url.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()), indicator2.getModalityState());
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "checkExists";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class FetchResult {
        byte[] bytes;
        String contentType;

        protected FetchResult() {
        }
    }

    static final class FetchingResourceIOException
    extends IOException {
        private final String url;

        FetchingResourceIOException(Throwable cause, String url) {
            this.initCause(cause);
            this.url = url;
        }
    }

    static final class MyWatchedRootsProvider
    implements WatchedRootsProvider {
        MyWatchedRootsProvider() {
        }

        @NotNull
        public Set<String> getRootsToWatch(@NotNull Project project) {
            if (project == null) {
                MyWatchedRootsProvider.$$$reportNull$$$0(0);
            }
            String path2 = FetchExtResourceAction.getExternalResourcesPath();
            Path file2 = FetchExtResourceAction.checkExists(path2);
            Set<String> set2 = Collections.singleton(file2.toAbsolutePath().toString());
            if (set2 == null) {
                MyWatchedRootsProvider.$$$reportNull$$$0(1);
            }
            return set2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction$MyWatchedRootsProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction$MyWatchedRootsProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootsToWatch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootsToWatch";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

