/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.dataflow.map;

import com.intellij.codeInsight.dataflow.SetUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DFAMap<V> {
    private String myK;
    private V myV;
    private HashMap<String, V> myAll;
    private static final DFAMap ourEmptyMap = new DFAMap(){

        public void put(String key, Object value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(String name2) {
            throw new UnsupportedOperationException();
        }

        public DFAMap asWritable() {
            return new DFAMap();
        }
    };

    public DFAMap() {
    }

    public DFAMap(DFAMap<? extends V> initialMap) {
        this.myK = initialMap.myK;
        this.myV = initialMap.myV;
        this.myAll = initialMap.myAll == null ? null : new HashMap<String, V>(initialMap.myAll);
    }

    public static <V> DFAMap<V> empty() {
        return ourEmptyMap;
    }

    public void addKeys(HashSet<? super String> allNames) {
        if (this.myAll != null) {
            allNames.addAll(this.myAll.keySet());
        } else if (this.myK != null) {
            allNames.add(this.myK);
        }
    }

    public void put(String key, V value2) {
        if ((this.myK == null || this.myK.equals(key)) && this.myAll == null) {
            this.myK = key;
            this.myV = value2;
        } else {
            if (this.myAll == null) {
                this.myAll = new HashMap();
                this.myAll.put(this.myK, this.myV);
            }
            this.myAll.put(key, value2);
        }
    }

    @Nullable
    public V get(String key) {
        if (this.myAll != null) {
            return this.myAll.get(key);
        }
        if (key.equals(this.myK)) {
            return this.myV;
        }
        return null;
    }

    public void remove(String name2) {
        if (this.myAll != null) {
            this.myAll.remove(name2);
            if (this.myAll.size() == 1) {
                Map.Entry<String, V> e = this.myAll.entrySet().iterator().next();
                this.myK = e.getKey();
                this.myV = e.getValue();
                this.myAll = null;
            }
        } else if (name2.equals(this.myK)) {
            this.myK = null;
            this.myV = null;
        }
    }

    public boolean containsKey(String name2) {
        if (this.myAll != null) {
            return this.myAll.containsKey(name2);
        }
        return name2.equals(this.myK);
    }

    public Set<String> intersectKeys(@Nullable Set<String> names2Include) {
        if (this.myAll != null) {
            if (names2Include == null) {
                return this.myAll.keySet();
            }
            return SetUtil.intersect(names2Include, this.myAll.keySet());
        }
        if (this.myK != null && (names2Include == null || names2Include.contains(this.myK))) {
            if (names2Include != null && names2Include.size() == 1) {
                return names2Include;
            }
            HashSet<String> result2 = new HashSet<String>();
            result2.add(this.myK);
            return result2;
        }
        return Collections.emptySet();
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof DFAMap)) {
            return false;
        }
        DFAMap rhs = (DFAMap)obj2;
        if (this.myAll == null) {
            if (rhs.myAll != null) {
                return false;
            }
            if (this.myK == null) {
                return rhs.myK == null;
            }
            return this.myK.equals(rhs.myK) && this.myV.equals(rhs.myV);
        }
        if (rhs.myAll == null) {
            return false;
        }
        return this.myAll.equals(rhs.myAll);
    }

    public Collection<V> values() {
        if (this.myAll != null) {
            return this.myAll.values();
        }
        if (this.myV != null) {
            return Collections.singletonList(this.myV);
        }
        return Collections.emptyList();
    }

    public Collection<? extends Map.Entry<String, V>> entrySet() {
        if (this.myAll != null) {
            return this.myAll.entrySet();
        }
        if (this.myK != null) {
            return Collections.singleton(new Map.Entry<String, V>(){

                @Override
                public String getKey() {
                    return DFAMap.this.myK;
                }

                @Override
                public V getValue() {
                    return DFAMap.this.myV;
                }

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return Collections.emptyList();
    }

    public Map<String, V> toMap() {
        if (this.myAll != null) {
            return this.myAll;
        }
        if (this.myK != null) {
            return Collections.singletonMap(this.myK, this.myV);
        }
        return Collections.emptyMap();
    }

    public DFAMap<V> asWritable() {
        return new DFAMap<V>(this);
    }

    @NonNls
    public String toString() {
        if (this == ourEmptyMap) {
            return "Empty Map";
        }
        if (this.myAll != null) {
            return this.myAll.toString();
        }
        if (this.myK != null) {
            return "{" + this.myK + "=" + this.myV + "}";
        }
        return "Empty";
    }

    public Set<String> keySet() {
        if (this.myAll != null) {
            return this.myAll.keySet();
        }
        return this.myK != null ? Collections.singleton(this.myK) : Collections.emptySet();
    }
}

