/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationHtmlFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.impl.EditorCssFontResolver;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DocumentationHtmlEditorKit
extends JBHtmlEditorKit {
    @NotNull
    private final DocumentationHtmlFactory myHtmlFactory;

    DocumentationHtmlEditorKit(@NotNull Component referenceComponent) {
        if (referenceComponent == null) {
            DocumentationHtmlEditorKit.$$$reportNull$$$0(0);
        }
        super(true, true);
        this.myHtmlFactory = new DocumentationHtmlFactory(referenceComponent);
        DocumentationHtmlEditorKit.prepareCSS(this);
    }

    public DocumentationHtmlFactory getViewFactory() {
        return this.myHtmlFactory;
    }

    private static int getMonospaceFontSizeCorrection() {
        return SystemInfo.isWin10OrNewer && !ApplicationManager.getApplication().isUnitTestMode() ? 96 : 100;
    }

    private static void prepareCSS(@NotNull JBHtmlEditorKit editorKit) {
        if (editorKit == null) {
            DocumentationHtmlEditorKit.$$$reportNull$$$0(1);
        }
        editorKit.setFontResolver((JBHtmlEditorKit.FontResolver)EditorCssFontResolver.getGlobalInstance());
        int leftPadding = 8;
        int definitionTopPadding = 4;
        String linkColor = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED);
        String borderColor = ColorUtil.toHtmlColor((Color)UIUtil.getTooltipSeparatorColor());
        String sectionColor = ColorUtil.toHtmlColor((Color)DocumentationComponent.SECTION_COLOR);
        String editorFontStyle = "{font-family:\"_EditorFontNoLigatures_\";font-size:" + DocumentationHtmlEditorKit.getMonospaceFontSizeCorrection() + "%;}";
        StyleSheet styleSheet = editorKit.getStyleSheet();
        styleSheet.addRule("tt" + editorFontStyle);
        styleSheet.addRule("code" + editorFontStyle);
        styleSheet.addRule("pre" + editorFontStyle);
        styleSheet.addRule(".pre" + editorFontStyle);
        styleSheet.addRule("html { padding-bottom: 8px; }");
        styleSheet.addRule("h1, h2, h3, h4, h5, h6 { margin-top: 0; padding-top: 1px; }");
        styleSheet.addRule("a { color: " + linkColor + "; text-decoration: none;}");
        styleSheet.addRule(".definition { padding: " + definitionTopPadding + "px 17px 1px " + leftPadding + "px; border-bottom: thin solid " + borderColor + "; }");
        styleSheet.addRule(".definition-only { padding: " + definitionTopPadding + "px 17px 0 " + leftPadding + "px; }");
        styleSheet.addRule(".definition-only pre { margin-bottom: 0 }");
        styleSheet.addRule(".content { padding: 5px 16px 0 " + leftPadding + "px; max-width: 100% }");
        styleSheet.addRule(".content-separated { padding: 5px 16px 5px " + leftPadding + "px; max-width: 100%;                     border-bottom: thin solid " + borderColor + "; }");
        styleSheet.addRule(".content-only { padding: 8px 16px 0 " + leftPadding + "px; max-width: 100% }");
        styleSheet.addRule(".bottom { padding: 3px 16px 0 " + leftPadding + "px; }");
        styleSheet.addRule(".bottom-no-content { padding: 5px 16px 0 " + leftPadding + "px; }");
        styleSheet.addRule("p { padding: 1px 0 2px 0; }");
        styleSheet.addRule("ol { padding: 0 16px 0 0; }");
        styleSheet.addRule("ul { padding: 0 16px 0 0; }");
        styleSheet.addRule("li { padding: 1px 0 2px 0; }");
        styleSheet.addRule(".grayed { color: #909090; display: inline;}");
        styleSheet.addRule(".centered { text-align: center}");
        styleSheet.addRule(".sections { padding: 0 16px 0 " + leftPadding + "px; border-spacing: 0; }");
        styleSheet.addRule("tr { margin: 0 0 0 0; padding: 0 0 0 0; }");
        styleSheet.addRule("table p { padding-bottom: 0}");
        styleSheet.addRule("td { margin: 4px 0 0 0; padding: 0 0 0 0; }");
        styleSheet.addRule("th { text-align: left; }");
        styleSheet.addRule("td pre { padding: 1px 0 0 0; margin: 0 0 0 0 }");
        styleSheet.addRule(".section { color: " + sectionColor + "; padding-right: 4px; white-space:nowrap;}");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorKit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationHtmlEditorKit";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareCSS";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

