/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationScalingImageView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.UnknownModuleType;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBHtmlEditorKit;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.ImageView;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DocumentationHtmlFactory
extends JBHtmlEditorKit.JBHtmlFactory {
    @NotNull
    private final Component myReferenceComponent;
    @NotNull
    private final List<Icon> myIcons;

    DocumentationHtmlFactory(@NotNull Component referenceComponent) {
        if (referenceComponent == null) {
            DocumentationHtmlFactory.$$$reportNull$$$0(0);
        }
        this.myIcons = new SmartList();
        this.myReferenceComponent = referenceComponent;
    }

    public View create(Element elem) {
        View view = super.create(elem);
        if (view instanceof ImageView) {
            return new DocumentationScalingImageView(elem, this.myReferenceComponent);
        }
        return view;
    }

    @Nullable
    protected Icon getIcon(@NotNull String src) {
        Icon icon2;
        if (src == null) {
            DocumentationHtmlFactory.$$$reportNull$$$0(1);
        }
        if ((icon2 = this.registeredIcon(src)) != null) {
            return icon2;
        }
        icon2 = DocumentationHtmlFactory.moduleIcon(src);
        if (icon2 != null) {
            return icon2;
        }
        return super.getIcon(src);
    }

    @Nullable
    private Icon registeredIcon(@NotNull String src) {
        Integer iconIndexOrNull;
        if (src == null) {
            DocumentationHtmlFactory.$$$reportNull$$$0(2);
        }
        if ((iconIndexOrNull = StringsKt.toIntOrNull((String)src)) == null) {
            return null;
        }
        int index2 = iconIndexOrNull;
        if (index2 >= this.myIcons.size()) {
            return null;
        }
        return this.myIcons.get(index2);
    }

    @RequiresEdt
    public void clearIcons() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myIcons.clear();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public String registerIcon(@NotNull Icon icon2) {
        void icon3;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (icon3 == null) {
            DocumentationHtmlFactory.$$$reportNull$$$0(3);
        }
        this.myIcons.add((Icon)icon3);
        String string = String.valueOf(this.myIcons.size() - 1);
        if (string == null) {
            DocumentationHtmlFactory.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static Icon moduleIcon(@NotNull String src) {
        ModuleType moduleType;
        if (src == null) {
            DocumentationHtmlFactory.$$$reportNull$$$0(5);
        }
        return (moduleType = ModuleTypeManager.getInstance().findByID(src)) == null || moduleType instanceof UnknownModuleType ? null : moduleType.getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceComponent";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationHtmlFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationHtmlFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "registerIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registeredIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerIcon";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "moduleIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

