/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.CopyAction;
import com.intellij.openapi.editor.actions.DocumentGuardedTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CutHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public CutHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(@NotNull Editor editor2, Caret caret, DataContext dataContext) {
        if (editor2 == null) {
            CutHandler.$$$reportNull$$$0(0);
        }
        assert (caret == null) : "Invocation of 'cut' operation for specific caret is not supported";
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor2.getContentComponent()));
        if (project == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor2, null, dataContext);
            }
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor2, null, dataContext);
            }
            return;
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (!selectionModel.hasSelection(true)) {
            if (CopyAction.isSkipCopyPasteForEmptySelection()) {
                return;
            }
            editor2.getCaretModel().runForEachCaret(__ -> selectionModel.selectLineAtCaret());
            if (!selectionModel.hasSelection(true)) {
                return;
            }
        }
        int start2 = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        ArrayList selections2 = new ArrayList();
        if (editor2.getCaretModel().supportsMultipleCarets()) {
            editor2.getCaretModel().runForEachCaret(__ -> selections2.add(new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd())));
        }
        EditorActionManager.getInstance().getActionHandler("EditorCopy").execute(editor2, null, dataContext);
        if (editor2.getCaretModel().supportsMultipleCarets()) {
            Collections.reverse(selections2);
            Iterator it = selections2.iterator();
            editor2.getCaretModel().runForEachCaret(__ -> {
                TextRange range2 = (TextRange)it.next();
                editor2.getCaretModel().moveToOffset(range2.getStartOffset());
                selectionModel.removeSelection();
                DocumentGuardedTextUtil.deleteString(editor2.getDocument(), range2.getStartOffset(), range2.getEndOffset());
            });
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        } else if (start2 != end) {
            editor2.getDocument().deleteString(start2, end);
        } else {
            EditorModificationUtil.deleteSelectedText((Editor)editor2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/CutHandler", "executeWriteAction"));
    }
}

