/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class EnterBetweenXmlTagsHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file2 == null) {
            EnterBetweenXmlTagsHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EnterBetweenXmlTagsHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            EnterBetweenXmlTagsHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterBetweenXmlTagsHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterBetweenXmlTagsHandler.$$$reportNull$$$0(4);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if ((file2 instanceof XmlFile || HtmlUtil.supportsXmlTypedHandlers(file2)) && EnterBetweenXmlTagsHandler.isBetweenXmlTags(project, editor2, file2, (Integer)caretOffset.get())) {
            editor2.getDocument().insertString(((Integer)caretOffset.get()).intValue(), (CharSequence)"\n");
            if (project != null) {
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(editor2.getDocument(), (Integer)caretOffset.get() + 1);
            }
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isBetweenXmlTags(Project project, Editor editor2, PsiFile file2, int offset) {
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor2.getDocument().getCharsSequence();
        if (chars.charAt(offset - 1) != '>') {
            return false;
        }
        EditorHighlighter highlighter = editor2.getHighlighter();
        HighlighterIterator iterator2 = highlighter.createIterator(offset - 1);
        if (iterator2.getTokenType() != XmlTokenType.XML_TAG_END) {
            return false;
        }
        if (EnterBetweenXmlTagsHandler.isAtTheEndOfEmptyTag(project, editor2, file2, iterator2)) {
            return false;
        }
        iterator2.retreat();
        int retrieveCount = 1;
        while (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            if (tokenType == XmlTokenType.XML_END_TAG_START) {
                return false;
            }
            if (tokenType == XmlTokenType.XML_START_TAG_START) break;
            ++retrieveCount;
            iterator2.retreat();
        }
        for (int i2 = 0; i2 < retrieveCount; ++i2) {
            iterator2.advance();
        }
        iterator2.advance();
        return !iterator2.atEnd() && iterator2.getTokenType() == XmlTokenType.XML_END_TAG_START;
    }

    private static boolean isAtTheEndOfEmptyTag(Project project, Editor editor2, PsiFile file2, HighlighterIterator iterator2) {
        if (iterator2.getTokenType() != XmlTokenType.XML_TAG_END) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
        PsiElement element2 = file2.findElementAt(iterator2.getStart());
        if (element2 == null) {
            return false;
        }
        PsiElement parent = element2.getParent();
        return parent instanceof XmlTag && parent.getTextRange().getEndOffset() == iterator2.getEnd();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/EnterBetweenXmlTagsHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

