/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class SimpleTokenSetQuoteHandler
implements QuoteHandler {
    protected final TokenSet myLiteralTokenSet;

    public SimpleTokenSetQuoteHandler(IElementType ... _literalTokens) {
        this(TokenSet.create((IElementType[])_literalTokens));
    }

    public SimpleTokenSetQuoteHandler(TokenSet tokenSet) {
        this.myLiteralTokenSet = tokenSet;
    }

    @Override
    public boolean isClosingQuote(HighlighterIterator iterator2, int offset) {
        IElementType tokenType = iterator2.getTokenType();
        if (this.myLiteralTokenSet.contains(tokenType)) {
            int start2 = iterator2.getStart();
            int end = iterator2.getEnd();
            return end - start2 >= 1 && offset == end - 1;
        }
        return false;
    }

    @Override
    public boolean isOpeningQuote(HighlighterIterator iterator2, int offset) {
        if (this.myLiteralTokenSet.contains(iterator2.getTokenType())) {
            int start2 = iterator2.getStart();
            return offset == start2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNonClosedLiteral(Editor editor2, HighlighterIterator iterator2, int offset) {
        int start2 = iterator2.getStart();
        try {
            Document doc = editor2.getDocument();
            CharSequence chars = doc.getCharsSequence();
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            while (!iterator2.atEnd() && iterator2.getStart() < lineEnd) {
                IElementType tokenType = iterator2.getTokenType();
                if (this.myLiteralTokenSet.contains(tokenType) && this.isNonClosedLiteral(iterator2, chars)) {
                    boolean bl = true;
                    return bl;
                }
                iterator2.advance();
            }
        }
        finally {
            while (iterator2.atEnd() || iterator2.getStart() != start2) {
                iterator2.retreat();
            }
        }
        return false;
    }

    protected boolean isNonClosedLiteral(HighlighterIterator iterator2, CharSequence chars) {
        return iterator2.getStart() >= iterator2.getEnd() - 1 || chars.charAt(iterator2.getEnd() - 1) != '\"' && chars.charAt(iterator2.getEnd() - 1) != '\'';
    }

    @Override
    public boolean isInsideLiteral(HighlighterIterator iterator2) {
        return this.myLiteralTokenSet.contains(iterator2.getTokenType());
    }
}

