/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterBetweenBracesFinalHandler
extends EnterHandlerDelegateAdapter {
    protected static EnterBetweenBracesDelegate ourDefaultBetweenDelegate = new EnterBetweenBracesDelegate();

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        EnterBetweenBracesDelegate helper2;
        int caretOffset;
        if (file2 == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(4);
        }
        if (!CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor2.getDocument();
        CharSequence text2 = document.getCharsSequence();
        if (!this.isApplicable(file2, editor2, text2, caretOffset = ((Integer)caretOffsetRef.get()).intValue(), helper2 = this.getLanguageImplementation(EnterHandler.getLanguage(dataContext)))) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int line = document.getLineNumber(caretOffset);
        int start2 = document.getLineStartOffset(line);
        CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(file2, text2, caretOffset, start2);
        String indentInsideJavadoc = helper2.isInComment(file2, editor2, caretOffset) && commentContext.docAsterisk ? CodeDocumentationUtil.getIndentInsideJavadoc(document, caretOffset) : null;
        originalHandler.execute(editor2, editor2.getCaretModel().getCurrentCaret(), dataContext);
        Project project = editor2.getProject();
        if (indentInsideJavadoc != null && project != null && CodeStyleManager.getInstance((Project)project).getDocCommentSettings(file2).isLeadingAsteriskEnabled()) {
            document.insertString(editor2.getCaretModel().getOffset(), (CharSequence)("*" + indentInsideJavadoc));
        }
        helper2.formatAtOffset(file2, editor2, editor2.getCaretModel().getOffset(), EnterHandler.getLanguage(dataContext));
        return indentInsideJavadoc == null ? EnterHandlerDelegate.Result.Continue : EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    protected boolean isApplicable(@NotNull PsiFile file2, @NotNull Editor editor2, CharSequence documentText2, int caretOffset, EnterBetweenBracesDelegate helper2) {
        if (file2 == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(6);
        }
        int prevCharOffset = CharArrayUtil.shiftBackward((CharSequence)documentText2, (int)(caretOffset - 1), (String)" \t");
        int nextCharOffset = CharArrayUtil.shiftForward((CharSequence)documentText2, (int)caretOffset, (String)" \t");
        return EnterBetweenBracesFinalHandler.isValidOffset(prevCharOffset, documentText2) && EnterBetweenBracesFinalHandler.isValidOffset(nextCharOffset, documentText2) && helper2.isBracePair(documentText2.charAt(prevCharOffset), documentText2.charAt(nextCharOffset)) && !helper2.bracesAreInTheSameElement(file2, editor2, prevCharOffset, nextCharOffset);
    }

    @NotNull
    protected EnterBetweenBracesDelegate getLanguageImplementation(@Nullable Language language2) {
        EnterBetweenBracesDelegate helper2;
        if (language2 != null && (helper2 = (EnterBetweenBracesDelegate)EnterBetweenBracesDelegate.EP_NAME.forLanguage(language2)) != null) {
            EnterBetweenBracesDelegate enterBetweenBracesDelegate = helper2;
            if (enterBetweenBracesDelegate == null) {
                EnterBetweenBracesFinalHandler.$$$reportNull$$$0(7);
            }
            return enterBetweenBracesDelegate;
        }
        EnterBetweenBracesDelegate enterBetweenBracesDelegate = ourDefaultBetweenDelegate;
        if (enterBetweenBracesDelegate == null) {
            EnterBetweenBracesFinalHandler.$$$reportNull$$$0(8);
        }
        return enterBetweenBracesDelegate;
    }

    protected static boolean isValidOffset(int offset, CharSequence text2) {
        return offset >= 0 && offset < text2.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesFinalHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesFinalHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

