/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SmartEnterAction
extends EditorAction {
    public SmartEnterAction() {
        super((EditorActionHandler)new Handler());
        this.setInjectedContext(true);
    }

    public static void plainEnter(Editor editor2, Caret caret, DataContext dataContext) {
        SmartEnterAction.getEnterHandler().execute(editor2, caret, dataContext);
    }

    private static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    private static class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (editor2 instanceof EditorWindow && editor2.isOneLineMode()) {
                return false;
            }
            return SmartEnterAction.getEnterHandler().isEnabled(editor2, caret, dataContext);
        }

        public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            List processors;
            Project project;
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(3);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null || editor2.isOneLineMode()) {
                SmartEnterAction.plainEnter(editor2, caret, dataContext);
                return;
            }
            LookupManager.getInstance(project).hideActiveLookup();
            TemplateState state = TemplateManagerImpl.getTemplateState(editor2);
            if (state != null) {
                state.gotoEnd();
            }
            int caretOffset = editor2.getCaretModel().getOffset();
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project);
            if (psiFile == null) {
                SmartEnterAction.plainEnter(editor2, caret, dataContext);
                return;
            }
            if (EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace(editor2, caretOffset, psiFile.getFileType())) {
                EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
                enterHandler.execute(editor2, caret, dataContext);
                return;
            }
            Language language2 = PsiUtilBase.getLanguageInEditor((Editor)editor2, (Project)project);
            boolean processed2 = false;
            if (language2 != null && !(processors = SmartEnterProcessors.INSTANCE.allForLanguage(language2)).isEmpty()) {
                for (SmartEnterProcessor processor2 : processors) {
                    if (!processor2.process(project, editor2, psiFile)) continue;
                    processed2 = true;
                    break;
                }
            }
            if (!processed2) {
                SmartEnterAction.plainEnter(editor2, caret, dataContext);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/SmartEnterAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeWriteAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

