/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

final class UpdateFoldRegionsOperation
implements Runnable {
    private static final Logger LOG = Logger.getInstance(UpdateFoldRegionsOperation.class);
    private static final Key<Boolean> CAN_BE_REMOVED_WHEN_COLLAPSED = Key.create((String)"canBeRemovedWhenCollapsed");
    static final Key<Boolean> COLLAPSED_BY_DEFAULT = Key.create((String)"collapsedByDefault");
    static final Key<String> SIGNATURE = Key.create((String)"signature");
    static final Key<Boolean> UPDATE_REGION = Key.create((String)"update");
    static final String NO_SIGNATURE = "no signature";
    private static final Comparator<PsiElement> COMPARE_BY_OFFSET_REVERSED = (element2, element1) -> {
        int startOffsetDiff = element1.getTextRange().getStartOffset() - element2.getTextRange().getStartOffset();
        return startOffsetDiff == 0 ? element1.getTextRange().getEndOffset() - element2.getTextRange().getEndOffset() : startOffsetDiff;
    };
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    @NotNull
    private final ApplyDefaultStateMode myApplyDefaultState;
    private final FoldingMap myElementsToFoldMap;
    private final Set<FoldingUpdate.RegionInfo> myRegionInfos;
    private final MultiMap<FoldingGroup, FoldingUpdate.RegionInfo> myGroupedRegionInfos;
    private final boolean myKeepCollapsedRegions;
    private final boolean myForInjected;

    UpdateFoldRegionsOperation(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull List<? extends FoldingUpdate.RegionInfo> elementsToFold, @NotNull ApplyDefaultStateMode applyDefaultState, boolean keepCollapsedRegions, boolean forInjected) {
        if (project == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(2);
        }
        if (elementsToFold == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(3);
        }
        if (applyDefaultState == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(4);
        }
        this.myElementsToFoldMap = new FoldingMap();
        this.myRegionInfos = new LinkedHashSet<FoldingUpdate.RegionInfo>();
        this.myGroupedRegionInfos = new MultiMap();
        this.myProject = project;
        this.myEditor = editor2;
        this.myFile = file2;
        this.myApplyDefaultState = applyDefaultState;
        this.myKeepCollapsedRegions = keepCollapsedRegions;
        this.myForInjected = forInjected;
        for (FoldingUpdate.RegionInfo regionInfo : elementsToFold) {
            this.myElementsToFoldMap.putValue(regionInfo.element, regionInfo);
            this.myRegionInfos.add(regionInfo);
            FoldingGroup group2 = regionInfo.descriptor.getGroup();
            if (group2 == null) continue;
            this.myGroupedRegionInfos.putValue((Object)group2, (Object)regionInfo);
        }
    }

    @Override
    public void run() {
        EditorFoldingInfo info2 = EditorFoldingInfo.get(this.myEditor);
        FoldingModelEx foldingModel = (FoldingModelEx)this.myEditor.getFoldingModel();
        HashMap<TextRange, Boolean> rangeToExpandStatusMap = new HashMap<TextRange, Boolean>();
        this.removeInvalidRegions(info2, foldingModel, rangeToExpandStatusMap);
        HashMap<FoldRegion, Boolean> shouldExpand = new HashMap<FoldRegion, Boolean>();
        HashMap<FoldingGroup, Boolean> groupExpand = new HashMap<FoldingGroup, Boolean>();
        List<FoldRegion> newRegions = this.addNewRegions(info2, foldingModel, rangeToExpandStatusMap, shouldExpand, groupExpand);
        UpdateFoldRegionsOperation.applyExpandStatus(newRegions, shouldExpand, groupExpand);
        foldingModel.clearDocumentRangesModificationStatus();
    }

    private static void applyExpandStatus(@NotNull List<? extends FoldRegion> newRegions, @NotNull Map<FoldRegion, Boolean> shouldExpand, @NotNull Map<FoldingGroup, Boolean> groupExpand) {
        if (newRegions == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(5);
        }
        if (shouldExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(6);
        }
        if (groupExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(7);
        }
        for (FoldRegion foldRegion : newRegions) {
            FoldingGroup group2 = foldRegion.getGroup();
            Boolean expanded2 = group2 == null ? shouldExpand.get(foldRegion) : groupExpand.get(group2);
            if (expanded2 == null) continue;
            foldRegion.setExpanded(expanded2.booleanValue());
        }
    }

    @NotNull
    private List<FoldRegion> addNewRegions(@NotNull EditorFoldingInfo info2, @NotNull FoldingModelEx foldingModel, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap, @NotNull Map<FoldRegion, Boolean> shouldExpand, @NotNull Map<FoldingGroup, Boolean> groupExpand) {
        if (info2 == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(8);
        }
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(9);
        }
        if (rangeToExpandStatusMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(10);
        }
        if (shouldExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(11);
        }
        if (groupExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(12);
        }
        ArrayList<FoldRegion> newRegions = new ArrayList<FoldRegion>();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        for (FoldingUpdate.RegionInfo regionInfo : this.myRegionInfos) {
            ProgressManager.checkCanceled();
            FoldingDescriptor descriptor2 = regionInfo.descriptor;
            FoldingGroup group2 = descriptor2.getGroup();
            TextRange range2 = descriptor2.getRange();
            String placeholder = null;
            try {
                placeholder = descriptor2.getPlaceholderText();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (range2.getEndOffset() > this.myEditor.getDocument().getTextLength()) {
                LOG.error(String.format("Invalid folding descriptor detected (%s). It ends beyond the document range (%d)", descriptor2, this.myEditor.getDocument().getTextLength()));
                continue;
            }
            FoldRegion region = foldingModel.createFoldRegion(range2.getStartOffset(), range2.getEndOffset(), placeholder == null ? "..." : placeholder, group2, descriptor2.isNonExpandable());
            if (region == null) continue;
            PsiElement psi = descriptor2.getElement().getPsi();
            if (psi == null || !psi.isValid() || !this.myFile.isValid()) {
                region.dispose();
                continue;
            }
            region.setGutterMarkEnabledForSingleLine(descriptor2.isGutterMarkEnabledForSingleLine());
            if (descriptor2.canBeRemovedWhenCollapsed()) {
                region.putUserData(CAN_BE_REMOVED_WHEN_COLLAPSED, (Object)Boolean.TRUE);
            }
            region.putUserData(COLLAPSED_BY_DEFAULT, (Object)regionInfo.collapsedByDefault);
            region.putUserData(SIGNATURE, (Object)((String)ObjectUtils.chooseNotNull((Object)regionInfo.signature, (Object)NO_SIGNATURE)));
            info2.addRegion(region, smartPointerManager.createSmartPsiElementPointer(psi));
            newRegions.add(region);
            if (descriptor2.isNonExpandable()) {
                region.putUserData(FoldingModelImpl.SELECT_REGION_ON_CARET_NEARBY, (Object)Boolean.TRUE);
                continue;
            }
            boolean expandStatus = this.shouldExpandNewRegion(range2, rangeToExpandStatusMap, regionInfo.collapsedByDefault);
            if (group2 == null) {
                shouldExpand.put(region, expandStatus);
                continue;
            }
            Boolean alreadyExpanded = groupExpand.get(group2);
            groupExpand.put(group2, alreadyExpanded == null ? expandStatus : alreadyExpanded != false || expandStatus);
        }
        ArrayList<FoldRegion> arrayList = newRegions;
        if (arrayList == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private boolean shouldExpandNewRegion(TextRange range2, Map<TextRange, Boolean> rangeToExpandStatusMap, boolean collapsedByDefault) {
        if (this.myApplyDefaultState != ApplyDefaultStateMode.NO) {
            TextRange lineRange;
            if (this.myApplyDefaultState == ApplyDefaultStateMode.EXCEPT_CARET_REGION && (lineRange = OpenFileDescriptor.getRangeToUnfoldOnNavigation((Editor)this.myEditor)).intersects(range2)) {
                return true;
            }
            return !collapsedByDefault;
        }
        Boolean oldStatus = rangeToExpandStatusMap.get(range2);
        return oldStatus == null || oldStatus != false || FoldingUtil.caretInsideRange(this.myEditor, range2);
    }

    private void removeInvalidRegions(@NotNull EditorFoldingInfo info2, @NotNull FoldingModelEx foldingModel, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap) {
        if (info2 == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(14);
        }
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(15);
        }
        if (rangeToExpandStatusMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(16);
        }
        ArrayList<FoldRegion> toRemove2 = new ArrayList<FoldRegion>();
        Ref infoRef = Ref.create();
        HashSet<FoldingGroup> processedGroups = new HashSet<FoldingGroup>();
        ArrayList<FoldingUpdate.RegionInfo> matchedInfos = new ArrayList<FoldingUpdate.RegionInfo>();
        for (FoldRegion region : foldingModel.getAllFoldRegions()) {
            FoldingGroup group2 = region.getGroup();
            if (group2 != null && !processedGroups.add(group2)) continue;
            List<FoldRegion> regionsToProcess = group2 == null ? Collections.singletonList(region) : foldingModel.getGroupedRegions(group2);
            matchedInfos.clear();
            boolean shouldRemove = false;
            boolean isLight = true;
            for (FoldRegion foldRegion : regionsToProcess) {
                if (!foldRegion.isValid() || this.shouldRemoveRegion(foldRegion, info2, rangeToExpandStatusMap, (Ref<? super FoldingUpdate.RegionInfo>)infoRef)) {
                    shouldRemove = true;
                }
                isLight &= foldRegion.getUserData(SIGNATURE) == null;
                FoldingUpdate.RegionInfo regionInfo = (FoldingUpdate.RegionInfo)infoRef.get();
                matchedInfos.add(regionInfo);
            }
            if (!shouldRemove && group2 != null && !isLight) {
                FoldingGroup requestedGroup = null;
                for (FoldingUpdate.RegionInfo matchedInfo : matchedInfos) {
                    if (matchedInfo == null) {
                        shouldRemove = true;
                        break;
                    }
                    FoldingGroup g = matchedInfo.descriptor.getGroup();
                    if (g == null) {
                        shouldRemove = true;
                        break;
                    }
                    if (requestedGroup == null) {
                        requestedGroup = g;
                        continue;
                    }
                    if (requestedGroup.equals((Object)g)) continue;
                    shouldRemove = true;
                    break;
                }
                if (this.myGroupedRegionInfos.get(requestedGroup).size() != matchedInfos.size()) {
                    shouldRemove = true;
                }
            }
            if (shouldRemove) {
                for (FoldRegion foldRegion : regionsToProcess) {
                    rangeToExpandStatusMap.putIfAbsent(TextRange.create((Segment)foldRegion), foldRegion.isExpanded());
                }
                toRemove2.addAll(regionsToProcess);
                continue;
            }
            for (FoldingUpdate.RegionInfo regionInfo : matchedInfos) {
                if (regionInfo == null) continue;
                this.myElementsToFoldMap.remove(regionInfo.element, regionInfo);
                this.myRegionInfos.remove(regionInfo);
            }
        }
        for (FoldRegion region : toRemove2) {
            foldingModel.removeFoldRegion(region);
            info2.removeRegion(region);
        }
    }

    private boolean shouldRemoveRegion(@NotNull FoldRegion region, @NotNull EditorFoldingInfo info2, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap, @NotNull Ref<? super FoldingUpdate.RegionInfo> matchingInfo) {
        Collection regionInfos;
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(17);
        }
        if (info2 == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(18);
        }
        if (rangeToExpandStatusMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(19);
        }
        if (matchingInfo == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(20);
        }
        matchingInfo.set(null);
        if (UPDATE_REGION.get((UserDataHolder)region) == Boolean.TRUE) {
            rangeToExpandStatusMap.put(TextRange.create((int)region.getStartOffset(), (int)region.getEndOffset()), region.isExpanded());
            return true;
        }
        PsiElement element2 = (PsiElement)SlowOperations.allowSlowOperations(() -> info2.getPsiElement(region));
        if (element2 != null) {
            PsiFile containingFile = element2.getContainingFile();
            boolean isInjected = InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(containingFile);
            if (isInjected != this.myForInjected) {
                return false;
            }
        }
        boolean forceKeepRegion = this.myKeepCollapsedRegions && !region.isExpanded() && !this.regionOrGroupCanBeRemovedWhenCollapsed(region);
        Boolean storedCollapsedByDefault = (Boolean)region.getUserData(COLLAPSED_BY_DEFAULT);
        if (element2 != null && !(regionInfos = this.myElementsToFoldMap.get(element2)).isEmpty()) {
            FoldingUpdate.RegionInfo[] array2 = regionInfos.toArray(new FoldingUpdate.RegionInfo[0]);
            for (FoldingUpdate.RegionInfo regionInfo : array2) {
                FoldingDescriptor descriptor2 = regionInfo.descriptor;
                TextRange range2 = descriptor2.getRange();
                if (!TextRange.areSegmentsEqual((Segment)region, (Segment)range2)) continue;
                if (storedCollapsedByDefault != null && storedCollapsedByDefault != regionInfo.collapsedByDefault) {
                    rangeToExpandStatusMap.put(range2, !regionInfo.collapsedByDefault);
                    return true;
                }
                if (!region.getPlaceholderText().equals(descriptor2.getPlaceholderText()) || range2.getLength() < 2) {
                    return true;
                }
                matchingInfo.set((Object)regionInfo);
                return false;
            }
            if (!forceKeepRegion) {
                for (FoldingUpdate.RegionInfo regionInfo : regionInfos) {
                    rangeToExpandStatusMap.put(regionInfo.descriptor.getRange(), region.isExpanded());
                }
                return true;
            }
        } else {
            return !forceKeepRegion && region.getUserData(SIGNATURE) != null;
        }
        return false;
    }

    private boolean regionOrGroupCanBeRemovedWhenCollapsed(@NotNull FoldRegion region) {
        FoldingGroup group2;
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(21);
        }
        List<FoldRegion> affectedRegions = (group2 = region.getGroup()) != null && this.myEditor instanceof EditorEx ? ((EditorEx)this.myEditor).getFoldingModel().getGroupedRegions(group2) : Collections.singletonList(region);
        for (FoldRegion affectedRegion : affectedRegions) {
            if (!this.regionCanBeRemovedWhenCollapsed(affectedRegion)) continue;
            return true;
        }
        return false;
    }

    private boolean regionCanBeRemovedWhenCollapsed(@NotNull FoldRegion region) {
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(22);
        }
        return Boolean.TRUE.equals(region.getUserData(CAN_BE_REMOVED_WHEN_COLLAPSED)) || ((FoldingModelEx)this.myEditor.getFoldingModel()).hasDocumentRegionChangedFor(region) || !region.isValid() || this.isRegionInCaretLine(region);
    }

    private boolean isRegionInCaretLine(@NotNull FoldRegion region) {
        if (region == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(23);
        }
        int regionStartLine = this.myEditor.getDocument().getLineNumber(region.getStartOffset());
        int regionEndLine = this.myEditor.getDocument().getLineNumber(region.getEndOffset());
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        return caretLine >= regionStartLine && caretLine <= regionEndLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToFold";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyDefaultState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRegions";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldExpand";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupExpand";
                break;
            }
            case 8: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingModel";
                break;
            }
            case 10: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToExpandStatusMap";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation";
                break;
            }
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addNewRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyExpandStatus";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNewRegions";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeInvalidRegions";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldRemoveRegion";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "regionOrGroupCanBeRemovedWhenCollapsed";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "regionCanBeRemovedWhenCollapsed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isRegionInCaretLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FoldingMap
    extends MultiMap<PsiElement, FoldingUpdate.RegionInfo> {
        private FoldingMap() {
            super(new TreeMap(COMPARE_BY_OFFSET_REVERSED));
        }

        @NotNull
        protected Collection<FoldingUpdate.RegionInfo> createCollection() {
            return new ArrayList<FoldingUpdate.RegionInfo>();
        }
    }

    static enum ApplyDefaultStateMode {
        YES,
        EXCEPT_CARET_REGION,
        NO;

    }
}

