/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFoldingHandler
extends EditorActionHandler {
    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
        if (editor2 == null) {
            BaseFoldingHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            BaseFoldingHandler.$$$reportNull$$$0(1);
        }
        return editor2.getProject() != null;
    }

    protected List<FoldRegion> getFoldRegionsForSelection(@NotNull Editor editor2, @Nullable Caret caret) {
        if (editor2 == null) {
            BaseFoldingHandler.$$$reportNull$$$0(2);
        }
        FoldRegion[] allRegions = editor2.getFoldingModel().getAllFoldRegions();
        if (caret == null) {
            caret = editor2.getCaretModel().getPrimaryCaret();
        }
        if (caret.hasSelection()) {
            ArrayList<FoldRegion> result2 = new ArrayList<FoldRegion>();
            for (FoldRegion region : allRegions) {
                if (region.getStartOffset() < caret.getSelectionStart() || region.getEndOffset() > caret.getSelectionEnd()) continue;
                result2.add(region);
            }
            if (!result2.isEmpty()) {
                return result2;
            }
        }
        return Arrays.asList(allRegions);
    }

    protected List<FoldRegion> getFoldRegionsForCaret(@NotNull Editor editor2, @Nullable Caret caret, boolean toCollapse) {
        if (editor2 == null) {
            BaseFoldingHandler.$$$reportNull$$$0(3);
        }
        if (caret == null) {
            caret = editor2.getCaretModel().getPrimaryCaret();
        }
        int offset = caret.getOffset();
        FoldRegion rootRegion = FoldingUtil.findFoldRegionStartingAtLine(editor2, editor2.getDocument().getLineNumber(offset));
        if (rootRegion == null || toCollapse && !rootRegion.isExpanded()) {
            FoldRegion[] regions;
            rootRegion = null;
            for (FoldRegion region : regions = FoldingUtil.getFoldRegionsAtOffset(editor2, offset)) {
                if (region.isExpanded() != toCollapse) continue;
                rootRegion = region;
                break;
            }
        }
        ArrayList<FoldRegion> result2 = new ArrayList<FoldRegion>();
        if (rootRegion != null) {
            FoldRegion[] allRegions;
            for (FoldRegion region : allRegions = editor2.getFoldingModel().getAllFoldRegions()) {
                if (region.getStartOffset() < rootRegion.getStartOffset() || region.getEndOffset() > rootRegion.getEndOffset()) continue;
                result2.add(region);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/actions/BaseFoldingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFoldRegionsForSelection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFoldRegionsForCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

