/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.PatternDescriptor;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateByPatternDialog
extends DialogWrapper {
    private final Project myProject;
    private JPanel myPanel;
    private Splitter mySplitter;
    private final Tree myTree;
    private final Editor myEditor;
    private final MultiMap<String, PatternDescriptor> myMap;

    public GenerateByPatternDialog(Project project, PatternDescriptor[] descriptors) {
        super(project);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(CodeInsightBundle.message((String)"button.generate.by.pattern", (Object[])objectArray));
        this.setOKButtonText(CodeInsightBundle.message((String)"button.generate", (Object[])new Object[0]));
        this.myMap = new MultiMap();
        for (PatternDescriptor descriptor2 : descriptors) {
            this.myMap.putValue((Object)descriptor2.getParentId(), (Object)descriptor2);
        }
        DefaultMutableTreeNode root2 = this.createNode(null);
        this.myTree = new SimpleTree(){};
        this.myTree.setRootVisible(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            @NotNull
            public Component getTreeCellRendererComponent(@NotNull JTree tree, Object value2, boolean sel, boolean expanded2, boolean leaf, int row2, boolean hasFocus) {
                if (tree == null) {
                    2.$$$reportNull$$$0(0);
                }
                Component component2 = super.getTreeCellRendererComponent(tree, value2, sel, expanded2, leaf, row2, hasFocus);
                Object object = ((DefaultMutableTreeNode)value2).getUserObject();
                if (object instanceof PatternDescriptor) {
                    this.setText(((PatternDescriptor)object).getName());
                    this.setIcon(((PatternDescriptor)object).getIcon());
                }
                Component component3 = component2;
                if (component3 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return component3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tree";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/generation/GenerateByPatternDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/generation/GenerateByPatternDialog$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTreeCellRendererComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getTreeCellRendererComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myTree.setModel((TreeModel)new DefaultTreeModel(root2));
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                GenerateByPatternDialog.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/generation/GenerateByPatternDialog$3", "valueChanged"));
            }
        });
        this.myEditor = TemplateEditorUtil.createEditor(true, "");
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree));
        JPanel details2 = new JPanel(new BorderLayout());
        details2.add((Component)this.myEditor.getComponent(), "Center");
        this.mySplitter.setSecondComponent((JComponent)details2);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setShowDividerControls(true);
        this.myTree.setSelectionRow(0);
        this.init();
    }

    private void update() {
        DefaultMutableTreeNode node2 = this.getSelectedNode();
        this.getOKAction().setEnabled(node2 != null && node2.isLeaf());
        PatternDescriptor descriptor2 = this.getSelectedDescriptor();
        if (descriptor2 != null) {
            this.updateDetails(descriptor2);
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        TreePath path2 = this.myTree.getSelectionModel().getSelectionPath();
        return path2 == null ? null : (DefaultMutableTreeNode)path2.getLastPathComponent();
    }

    PatternDescriptor getSelectedDescriptor() {
        Object object;
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && (object = selectedNode.getUserObject()) instanceof PatternDescriptor) {
            return (PatternDescriptor)object;
        }
        return null;
    }

    private void updateDetails(PatternDescriptor descriptor2) {
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            Template template = descriptor2.getTemplate();
            if (template instanceof TemplateImpl) {
                String text2 = template.getString();
                this.myEditor.getDocument().replaceString(0, this.myEditor.getDocument().getTextLength(), (CharSequence)text2);
                TemplateEditorUtil.setHighlighter(this.myEditor, ((TemplateImpl)template).getTemplateContext());
            } else {
                this.myEditor.getDocument().replaceString(0, this.myEditor.getDocument().getTextLength(), (CharSequence)"");
            }
        });
    }

    private DefaultMutableTreeNode createNode(@Nullable PatternDescriptor descriptor2) {
        DefaultMutableTreeNode root2 = new DefaultMutableTreeNode(descriptor2){

            @Override
            @NotNull
            public String toString() {
                Object object = this.getUserObject();
                String string = object == null ? "" : ((PatternDescriptor)object).getName();
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateByPatternDialog$4", "toString"));
            }
        };
        String id2 = descriptor2 == null ? "root" : descriptor2.getId();
        Collection collection = this.myMap.get((Object)id2);
        for (PatternDescriptor childDescriptor : collection) {
            root2.add(this.createNode(childDescriptor));
        }
        return root2;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected String getDimensionServiceKey() {
        return "generate.patterns.dialog";
    }

    protected void dispose() {
        super.dispose();
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    private void createUIComponents() {
        this.mySplitter = new Splitter(false, 0.3f);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Splitter splitter2 = this.mySplitter;
        jPanel2.add((Component)splitter2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(400, 300), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

