/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightManagerImpl
extends HighlightManager {
    private final Project myProject;
    private final Key<Map<RangeHighlighter, HighlightFlags>> HIGHLIGHT_INFO_MAP_KEY = Key.create((String)"HIGHLIGHT_INFO_MAP_KEY");
    public static final Key<Integer> HIGHLIGHT_FLAGS_KEY = Key.create((String)"HIGHLIGHT_FLAGS_KEY");

    public HighlightManagerImpl(Project project) {
        this.myProject = project;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject).subscribe(AnActionListener.TOPIC, (Object)new MyAnActionListener());
        DocumentListener documentListener2 = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Document document = event.getDocument();
                Iterator iterator2 = EditorFactory.getInstance().editors(document).iterator();
                while (iterator2.hasNext()) {
                    Editor editor2 = (Editor)iterator2.next();
                    Map<RangeHighlighter, HighlightFlags> map2 = HighlightManagerImpl.this.getHighlightInfoMap(editor2, false);
                    if (map2 == null) {
                        return;
                    }
                    ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
                    for (RangeHighlighter highlighter : map2.keySet()) {
                        HighlightFlags info2 = map2.get(highlighter);
                        if (!info2.editor.getDocument().equals(document) || !BitUtil.isSet((int)info2.flags, (int)4)) continue;
                        highlightersToRemove.add(highlighter);
                    }
                    for (RangeHighlighter highlighter : highlightersToRemove) {
                        HighlightManagerImpl.this.removeSegmentHighlighter(editor2, highlighter);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/highlighting/HighlightManagerImpl$1", "documentChanged"));
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(documentListener2, (Disposable)this.myProject);
    }

    @Nullable
    private Map<RangeHighlighter, HighlightFlags> getHighlightInfoMap(@NotNull Editor editor2, boolean toCreate) {
        Map map2;
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(0);
        }
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        if ((map2 = (Map)editor2.getUserData(this.HIGHLIGHT_INFO_MAP_KEY)) == null && toCreate) {
            map2 = (Map)((UserDataHolderEx)editor2).putUserDataIfAbsent(this.HIGHLIGHT_INFO_MAP_KEY, new HashMap());
        }
        return map2;
    }

    public RangeHighlighter @NotNull [] getHighlighters(@NotNull Editor editor2) {
        Map<RangeHighlighter, HighlightFlags> highlightersMap;
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(1);
        }
        if ((highlightersMap = this.getHighlightInfoMap(editor2, false)) == null) {
            if (RangeHighlighter.EMPTY_ARRAY == null) {
                HighlightManagerImpl.$$$reportNull$$$0(2);
            }
            return RangeHighlighter.EMPTY_ARRAY;
        }
        HashSet<RangeHighlighter> set2 = new HashSet<RangeHighlighter>();
        for (Map.Entry<RangeHighlighter, HighlightFlags> entry2 : highlightersMap.entrySet()) {
            HighlightFlags info2 = entry2.getValue();
            if (!info2.editor.equals(editor2)) continue;
            set2.add(entry2.getKey());
        }
        RangeHighlighter[] rangeHighlighterArray = set2.toArray(RangeHighlighter.EMPTY_ARRAY);
        if (rangeHighlighterArray == null) {
            HighlightManagerImpl.$$$reportNull$$$0(3);
        }
        return rangeHighlighterArray;
    }

    public boolean removeSegmentHighlighter(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter) {
        Map<RangeHighlighter, HighlightFlags> map2;
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(4);
        }
        if (highlighter == null) {
            HighlightManagerImpl.$$$reportNull$$$0(5);
        }
        if ((map2 = this.getHighlightInfoMap(editor2, false)) == null) {
            return false;
        }
        HighlightFlags info2 = map2.get(highlighter);
        if (info2 == null) {
            return false;
        }
        MarkupModel markupModel = info2.editor.getMarkupModel();
        if (((MarkupModelEx)markupModel).containsHighlighter(highlighter)) {
            highlighter.dispose();
        }
        map2.remove(highlighter);
        return true;
    }

    public void addOccurrenceHighlights(@NotNull Editor editor2, PsiReference @NotNull [] occurrences, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(6);
        }
        if (attributesKey == null) {
            HighlightManagerImpl.$$$reportNull$$$0(7);
        }
        if (occurrences == null) {
            HighlightManagerImpl.$$$reportNull$$$0(8);
        }
        this.addOccurrenceHighlights(editor2, occurrences, null, attributesKey, hideByTextChange, outHighlighters);
    }

    private void addOccurrenceHighlights(@NotNull Editor editor2, PsiReference @NotNull [] occurrences, @Nullable TextAttributes attributes2, @Nullable TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(9);
        }
        if (occurrences == null) {
            HighlightManagerImpl.$$$reportNull$$$0(10);
        }
        assert (attributes2 != null || attributesKey != null) : "Both attributes and attributesKey are null";
        if (occurrences.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes2, editor2.getColorsScheme());
        int oldOffset = editor2.getCaretModel().getOffset();
        int horizontalScrollOffset = editor2.getScrollingModel().getHorizontalScrollOffset();
        int verticalScrollOffset = editor2.getScrollingModel().getVerticalScrollOffset();
        for (PsiReference occurrence : occurrences) {
            Project project;
            PsiElement element2 = occurrence.getElement();
            int startOffset = element2.getTextRange().getStartOffset();
            int start2 = startOffset + occurrence.getRangeInElement().getStartOffset();
            int end = startOffset + occurrence.getRangeInElement().getEndOffset();
            PsiFile containingFile = element2.getContainingFile();
            Editor textEditor = InjectedLanguageUtil.openEditorFor(containingFile, project = element2.getProject());
            if (textEditor == null) continue;
            this.addOccurrenceHighlight(textEditor, start2, end, attributes2, attributesKey, flags, outHighlighters, scrollMarkColor);
        }
        editor2.getCaretModel().moveToOffset(oldOffset);
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor2.getScrollingModel().scrollHorizontally(horizontalScrollOffset);
        editor2.getScrollingModel().scrollVertically(verticalScrollOffset);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor2, int start2, int end, TextAttributes attributes2, int flags, Collection<? super RangeHighlighter> outHighlighters, Color scrollMarkColor) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(11);
        }
        this.addOccurrenceHighlight(editor2, start2, end, attributes2, null, flags, outHighlighters, scrollMarkColor);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor2, int start2, int end, TextAttributesKey attributesKey, int flags, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(12);
        }
        this.addOccurrenceHighlight(editor2, start2, end, null, attributesKey, flags, outHighlighters, null);
    }

    private void addOccurrenceHighlight(@NotNull Editor editor2, int start2, int end, @Nullable TextAttributes forcedAttributes, @Nullable TextAttributesKey attributesKey, int flags, @Nullable Collection<? super RangeHighlighter> outHighlighters, @Nullable Color scrollMarkColor) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(13);
        }
        MarkupModelEx markupModel = (MarkupModelEx)editor2.getMarkupModel();
        markupModel.addRangeHighlighterAndChangeAttributes(attributesKey, start2, end, 5999, HighlighterTargetArea.EXACT_RANGE, false, (Consumer<? super RangeHighlighterEx>)((Consumer)highlighter -> {
            HighlightFlags info2 = new HighlightFlags(editor2 instanceof EditorWindow ? ((EditorWindow)editor2).getDelegate() : editor2, flags);
            Map<RangeHighlighter, HighlightFlags> map2 = this.getHighlightInfoMap(editor2, true);
            map2.put((RangeHighlighter)highlighter, info2);
            highlighter.setVisibleIfFolded(true);
            if (outHighlighters != null) {
                outHighlighters.add((RangeHighlighter)highlighter);
            }
            if (forcedAttributes != null) {
                highlighter.setTextAttributes(forcedAttributes);
            }
            if (scrollMarkColor != null) {
                highlighter.setErrorStripeMarkColor(scrollMarkColor);
            }
            highlighter.putUserData(HIGHLIGHT_FLAGS_KEY, flags);
        }));
    }

    public void addRangeHighlight(@NotNull Editor editor2, int startOffset, int endOffset, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, @Nullable Collection<? super RangeHighlighter> highlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(14);
        }
        if (attributesKey == null) {
            HighlightManagerImpl.$$$reportNull$$$0(15);
        }
        this.addRangeHighlight(editor2, startOffset, endOffset, null, attributesKey, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor2, int startOffset, int endOffset, @NotNull TextAttributes attributes2, boolean hideByTextChange, @Nullable Collection<? super RangeHighlighter> highlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(16);
        }
        if (attributes2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(17);
        }
        this.addRangeHighlight(editor2, startOffset, endOffset, attributes2, null, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor2, int startOffset, int endOffset, @NotNull TextAttributes attributes2, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<? super RangeHighlighter> highlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(18);
        }
        if (attributes2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(19);
        }
        this.addRangeHighlight(editor2, startOffset, endOffset, attributes2, null, hideByTextChange, hideByAnyKey, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor2, int startOffset, int endOffset, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<? super RangeHighlighter> highlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(20);
        }
        if (attributesKey == null) {
            HighlightManagerImpl.$$$reportNull$$$0(21);
        }
        this.addRangeHighlight(editor2, startOffset, endOffset, null, attributesKey, hideByTextChange, hideByAnyKey, highlighters);
    }

    private void addRangeHighlight(@NotNull Editor editor2, int startOffset, int endOffset, @Nullable TextAttributes attributes2, @Nullable TextAttributesKey attributesKey, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<? super RangeHighlighter> highlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(22);
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        if (hideByAnyKey) {
            flags |= 2;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes2, editor2.getColorsScheme());
        this.addOccurrenceHighlight(editor2, startOffset, endOffset, attributes2, attributesKey, flags, highlighters, scrollMarkColor);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor2, PsiElement @NotNull [] elements, @NotNull TextAttributes attributes2, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(23);
        }
        if (attributes2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(24);
        }
        if (elements == null) {
            HighlightManagerImpl.$$$reportNull$$$0(25);
        }
        this.addOccurrenceHighlights(editor2, elements, attributes2, null, hideByTextChange, outHighlighters);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor2, PsiElement @NotNull [] elements, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(26);
        }
        if (attributesKey == null) {
            HighlightManagerImpl.$$$reportNull$$$0(27);
        }
        if (elements == null) {
            HighlightManagerImpl.$$$reportNull$$$0(28);
        }
        this.addOccurrenceHighlights(editor2, elements, null, attributesKey, hideByTextChange, outHighlighters);
    }

    private void addOccurrenceHighlights(@NotNull Editor editor2, PsiElement @NotNull [] elements, @Nullable TextAttributes attributes2, @Nullable TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(29);
        }
        if (elements == null) {
            HighlightManagerImpl.$$$reportNull$$$0(30);
        }
        if (elements.length == 0 || editor2 instanceof ImaginaryEditor) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes2, editor2.getColorsScheme());
        if (editor2 instanceof EditorWindow) {
            editor2 = ((EditorWindow)editor2).getDelegate();
        }
        for (PsiElement element2 : elements) {
            TextRange range2 = element2.getTextRange();
            range2 = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element2, range2);
            this.addOccurrenceHighlight(editor2, HighlightManagerImpl.trimOffsetToDocumentSize(editor2, range2.getStartOffset()), HighlightManagerImpl.trimOffsetToDocumentSize(editor2, range2.getEndOffset()), attributes2, attributesKey, flags, outHighlighters, scrollMarkColor);
        }
    }

    private static int trimOffsetToDocumentSize(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(31);
        }
        if (offset < 0) {
            return 0;
        }
        int textLength = editor2.getDocument().getTextLength();
        return Math.min(offset, textLength);
    }

    @Nullable
    private static Color getScrollMarkColor(@Nullable TextAttributes attributes2, @NotNull EditorColorsScheme colorScheme) {
        if (colorScheme == null) {
            HighlightManagerImpl.$$$reportNull$$$0(32);
        }
        if (attributes2 == null) {
            return null;
        }
        if (attributes2.getErrorStripeColor() != null) {
            return attributes2.getErrorStripeColor();
        }
        if (attributes2.getBackgroundColor() != null) {
            boolean isDark = ColorUtil.isDark((Color)colorScheme.getDefaultBackground());
            return isDark ? attributes2.getBackgroundColor().brighter() : attributes2.getBackgroundColor().darker();
        }
        return null;
    }

    public boolean hideHighlights(@NotNull Editor editor2, @HighlightManager.HideFlags int mask) {
        Map<RangeHighlighter, HighlightFlags> map2;
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(33);
        }
        if ((map2 = this.getHighlightInfoMap(editor2, false)) == null) {
            return false;
        }
        boolean done = false;
        ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
        for (RangeHighlighter highlighter : map2.keySet()) {
            HighlightFlags info2 = map2.get(highlighter);
            if (!InjectedLanguageEditorUtil.getTopLevelEditor(info2.editor).equals(InjectedLanguageEditorUtil.getTopLevelEditor(editor2)) || (info2.flags & mask) == 0) continue;
            highlightersToRemove.add(highlighter);
            done = true;
        }
        for (RangeHighlighter highlighter : highlightersToRemove) {
            this.removeSegmentHighlighter(editor2, highlighter);
        }
        return done;
    }

    boolean hasHideByEscapeHighlighters(@NotNull Editor editor2) {
        Map<RangeHighlighter, HighlightFlags> map2;
        if (editor2 == null) {
            HighlightManagerImpl.$$$reportNull$$$0(34);
        }
        if ((map2 = this.getHighlightInfoMap(editor2, false)) != null) {
            for (HighlightFlags info2 : map2.values()) {
                if (!info2.editor.equals(editor2) || (info2.flags & 1) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 7: 
            case 15: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 17: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoMap";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighters";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeSegmentHighlighter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addOccurrenceHighlights";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addOccurrenceHighlight";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlight";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "trimOffsetToDocumentSize";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getScrollMarkColor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hideHighlights";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasHideByEscapeHighlighters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HighlightFlags {
        @NotNull
        final Editor editor;
        @HighlightManager.HideFlags
        final int flags;

        HighlightFlags(@NotNull Editor editor2, @HighlightManager.HideFlags int flags) {
            if (editor2 == null) {
                HighlightFlags.$$$reportNull$$$0(0);
            }
            this.editor = editor2;
            this.flags = flags;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl$HighlightFlags", "<init>"));
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            this.requestHideHighlights(event.getDataContext());
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            this.requestHideHighlights(dataContext);
        }

        private void requestHideHighlights(@NotNull DataContext dataContext) {
            Editor editor2;
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(3);
            }
            if ((editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) == null) {
                return;
            }
            HighlightManagerImpl.this.hideHighlights(editor2, 2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestHideHighlights";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

