/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HighlightUsagesHandlerBase<T extends PsiElement> {
    @NotNull
    protected final Editor myEditor;
    @NotNull
    protected final PsiFile myFile;
    protected final List<TextRange> myReadUsages;
    protected final List<TextRange> myWriteUsages;
    protected @NlsContexts.StatusBarText String myStatusText;
    protected @NlsContexts.HintText String myHintText;

    protected HighlightUsagesHandlerBase(@NotNull Editor editor2, @NotNull PsiFile file2) {
        if (editor2 == null) {
            HighlightUsagesHandlerBase.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            HighlightUsagesHandlerBase.$$$reportNull$$$0(1);
        }
        this.myReadUsages = new ArrayList<TextRange>();
        this.myWriteUsages = new ArrayList<TextRange>();
        this.myEditor = editor2;
        this.myFile = file2;
    }

    public void highlightUsages() {
        List<T> targets2 = this.getTargets();
        this.selectTargets(targets2, targets1 -> {
            this.computeUsages((List<? extends T>)targets1);
            this.performHighlighting();
        });
    }

    private void performHighlighting() {
        boolean clearHighlights = HighlightUsagesHandler.isClearHighlights(this.myEditor);
        HighlightUsagesHandler.highlightRanges(HighlightManager.getInstance((Project)this.myFile.getProject()), this.myEditor, EditorColors.SEARCH_RESULT_ATTRIBUTES, clearHighlights, this.myReadUsages);
        HighlightUsagesHandler.highlightRanges(HighlightManager.getInstance((Project)this.myFile.getProject()), this.myEditor, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, clearHighlights, this.myWriteUsages);
        if (!clearHighlights) {
            WindowManager.getInstance().getStatusBar(this.myFile.getProject()).setInfo(this.myStatusText);
            HighlightHandlerBase.setupFindModel(this.myFile.getProject());
        }
        if (this.myHintText != null) {
            HintManager.getInstance().showInformationHint(this.myEditor, this.myHintText);
        }
    }

    protected void buildStatusText(@Nullable String elementName, int refCount) {
        if (refCount > 0) {
            this.myStatusText = CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.message" : "status.bar.highlighted.usages.no.target.message"), (Object[])new Object[]{refCount, elementName, HighlightUsagesHandler.getShortcutText()});
        } else {
            this.myHintText = CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.not.found.message" : "status.bar.highlighted.usages.not.found.no.target.message"), (Object[])new Object[]{elementName});
        }
    }

    @NotNull
    public abstract List<T> getTargets();

    @Nullable
    public String getFeatureId() {
        return null;
    }

    protected abstract void selectTargets(@NotNull List<? extends T> var1, @NotNull Consumer<? super List<? extends T>> var2);

    public abstract void computeUsages(@NotNull List<? extends T> var1);

    protected void addOccurrence(@NotNull PsiElement element2) {
        TextRange range2;
        if (element2 == null) {
            HighlightUsagesHandlerBase.$$$reportNull$$$0(2);
        }
        if ((range2 = element2.getTextRange()) != null) {
            range2 = InjectedLanguageManager.getInstance((Project)element2.getProject()).injectedToHost(element2, range2);
            this.myReadUsages.add(range2);
        }
    }

    public List<TextRange> getReadUsages() {
        return this.myReadUsages;
    }

    public List<TextRange> getWriteUsages() {
        return this.myWriteUsages;
    }

    public boolean highlightReferences() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addOccurrence";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

