/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ClientHintManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHintManager
implements ClientHintManager {
    private static final Logger LOG = Logger.getInstance(LocalHintManager.class);
    private final EditorMouseListener myEditorMouseListener;
    private final DocumentListener myEditorDocumentListener;
    private final VisibleAreaListener myVisibleAreaListener;
    private final CaretListener myCaretMoveListener;
    private final SelectionListener mySelectionListener;
    private LightweightHint myQuestionHint;
    private QuestionAction myQuestionAction;
    private final List<HintManagerImpl.HintInfo> myHintsStack = ContainerUtil.createLockFreeCopyOnWriteList();
    private Editor myLastEditor;
    private final Alarm myHideAlarm = new Alarm();
    private boolean myRequestFocusForNextHint;

    @Override
    public boolean canShowQuestionAction(QuestionAction action2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myQuestionAction == null || HintManagerImpl.getPriority(this.myQuestionAction) <= HintManagerImpl.getPriority(action2);
    }

    public LocalHintManager() {
        this.myCaretMoveListener = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                LocalHintManager.this.hideHints(1026, false, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/LocalHintManager$1", "caretPositionChanged"));
            }
        };
        this.mySelectionListener = new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                LocalHintManager.this.hideHints(1024, false, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/hint/LocalHintManager$2", "selectionChanged"));
            }
        };
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(AnActionListener.TOPIC, (Object)new MyAnActionListener());
        busConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new MyDynamicPluginListener());
        this.myEditorMouseListener = new EditorMouseListener(){

            public void mousePressed(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                LocalHintManager.this.hideAllHints();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/hint/LocalHintManager$3", "mousePressed"));
            }
        };
        this.myVisibleAreaListener = e -> {
            this.updateScrollableHints(e);
            if (e.getOldRectangle() == null || e.getOldRectangle().x != e.getNewRectangle().x || e.getOldRectangle().y != e.getNewRectangle().y) {
                this.hideHints(32, false, false);
            }
        };
        this.myEditorDocumentListener = new BulkAwareDocumentListener(){

            public void documentChangedNonBulk(@NotNull DocumentEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (event.getOldLength() != 0 || event.getNewLength() != 0) {
                    LocalHintManager.this.onDocumentChange();
                }
            }

            public void bulkUpdateFinished(@NotNull Document document) {
                if (document == null) {
                    4.$$$reportNull$$$0(1);
                }
                LocalHintManager.this.onDocumentChange();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/hint/LocalHintManager$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentChangedNonBulk";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bulkUpdateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void onDocumentChange() {
        EDT.assertIsEdt();
        for (HintManagerImpl.HintInfo info2 : this.myHintsStack) {
            if (!BitUtil.isSet((int)info2.flags, (int)8)) continue;
            info2.hint.hide();
            this.myHintsStack.remove(info2);
        }
        if (this.myHintsStack.isEmpty()) {
            this.updateLastEditor(null);
        }
    }

    @Override
    public void setRequestFocusForNextHint(boolean requestFocus) {
        this.myRequestFocusForNextHint = requestFocus;
    }

    @Override
    public boolean performCurrentQuestionAction() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myQuestionAction != null && this.myQuestionHint != null) {
            if (this.myQuestionHint.isVisible()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("performing an action:" + this.myQuestionAction);
                }
                if (this.myQuestionAction.execute() && this.myQuestionHint != null) {
                    this.myQuestionHint.hide();
                }
                return true;
            }
            this.myQuestionAction = null;
            this.myQuestionHint = null;
        }
        return false;
    }

    private void updateScrollableHints(VisibleAreaEvent e) {
        EDT.assertIsEdt();
        for (HintManagerImpl.HintInfo info2 : this.myHintsStack) {
            if (info2.hint == null || !BitUtil.isSet((int)info2.flags, (int)128)) continue;
            HintManagerImpl.updateScrollableHintPosition(e, info2.hint, BitUtil.isSet((int)info2.flags, (int)64));
        }
    }

    @Override
    public boolean hasShownHintsThatWillHideByOtherHint(boolean willShowTooltip) {
        EDT.assertIsEdt();
        for (HintManagerImpl.HintInfo hintInfo : this.myHintsStack) {
            if (hintInfo.hint.isVisible() && BitUtil.isSet((int)hintInfo.flags, (int)16)) {
                return true;
            }
            if (!willShowTooltip || !hintInfo.hint.isAwtTooltip()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void showEditorHint(LightweightHint hint, Editor editor2, @HintManager.PositionFlags short constraint, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        editor2.getScrollingModel().runActionOnScrollingFinished(() -> {
            LogicalPosition pos = editor2.getCaretModel().getLogicalPosition();
            Point p = HintManagerImpl.getHintPosition(hint, editor2, pos, constraint);
            this.showEditorHint(hint, editor2, p, flags, timeout, reviveOnEditorChange, HintManagerImpl.createHintHint(editor2, p, hint, constraint));
        });
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, @HintManager.PositionFlags short position) {
        if (hint == null) {
            LocalHintManager.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            LocalHintManager.$$$reportNull$$$0(1);
        }
        if (p == null) {
            LocalHintManager.$$$reportNull$$$0(2);
        }
        HintHint hintHint = HintManagerImpl.createHintHint(editor2, p, hint, position).setShowImmediately(true);
        this.showEditorHint(hint, editor2, p, flags, timeout, reviveOnEditorChange, hintHint);
    }

    @Override
    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, HintHint hintInfo) {
        if (hint == null) {
            LocalHintManager.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            LocalHintManager.$$$reportNull$$$0(4);
        }
        if (p == null) {
            LocalHintManager.$$$reportNull$$$0(5);
        }
        EDT.assertIsEdt();
        this.myHideAlarm.cancelAllRequests();
        this.hideHints(16, false, false);
        if (editor2 != this.myLastEditor) {
            this.hideAllHints();
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor2.getContentComponent().isShowing()) {
            return;
        }
        if (!ApplicationManager.getApplication().isActive()) {
            return;
        }
        this.updateLastEditor(editor2);
        HintManagerImpl.getPublisher().hintShown(editor2.getProject(), hint, flags);
        JComponent component2 = hint.getComponent();
        if (this.myRequestFocusForNextHint) {
            hintInfo.setRequestFocus(true);
            this.myRequestFocusForNextHint = false;
        }
        HintManagerImpl.doShowInGivenLocation(hint, editor2, p, hintInfo, true);
        ListenerUtil.addMouseListener(component2, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LocalHintManager.this.myHideAlarm.cancelAllRequests();
            }
        });
        ListenerUtil.addFocusListener(component2, new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LocalHintManager.this.myHideAlarm.cancelAllRequests();
            }
        });
        if (BitUtil.isSet((int)flags, (int)256)) {
            ListenerUtil.addMouseMotionListener(component2, new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    LocalHintManager.this.hideHints(256, true, false);
                }
            });
        }
        this.myHintsStack.add(new HintManagerImpl.HintInfo(hint, flags, reviveOnEditorChange));
        if (timeout > 0) {
            Timer timer2 = TimerUtil.createNamedTimer((String)"Hint timeout", (int)timeout, event -> hint.hide());
            timer2.setRepeats(false);
            timer2.start();
        }
    }

    @Override
    public void showHint(@NotNull JComponent component2, @NotNull RelativePoint p, int flags, int timeout, @Nullable Runnable onHintHidden) {
        if (component2 == null) {
            LocalHintManager.$$$reportNull$$$0(6);
        }
        if (p == null) {
            LocalHintManager.$$$reportNull$$$0(7);
        }
        EDT.assertIsEdt();
        this.myHideAlarm.cancelAllRequests();
        this.hideHints(16, false, false);
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder(component2, null).setRequestFocus(false).setResizable(false).setMovable(false);
        if (onHintHidden != null) {
            builder2.setCancelCallback(() -> {
                onHintHidden.run();
                return true;
            });
        }
        final JBPopup popup2 = builder2.createPopup();
        popup2.show(p);
        ListenerUtil.addMouseListener(component2, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LocalHintManager.this.myHideAlarm.cancelAllRequests();
            }
        });
        ListenerUtil.addFocusListener(component2, new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LocalHintManager.this.myHideAlarm.cancelAllRequests();
            }
        });
        HintManagerImpl.HintInfo info2 = new HintManagerImpl.HintInfo(new LightweightHint(component2){

            @Override
            public void hide() {
                popup2.cancel();
            }
        }, flags, false);
        this.myHintsStack.add(info2);
        if (timeout > 0) {
            Timer timer2 = TimerUtil.createNamedTimer((String)"Popup timeout", (int)timeout, event -> Disposer.dispose((Disposable)popup2));
            timer2.setRepeats(false);
            timer2.start();
        }
    }

    @Override
    public void hideAllHints() {
        EDT.assertIsEdt();
        for (HintManagerImpl.HintInfo info2 : this.myHintsStack) {
            if (info2.hint.vetoesHiding()) continue;
            info2.hint.hide();
        }
        this.cleanup();
    }

    @Override
    public void cleanup() {
        this.myHintsStack.clear();
        this.updateLastEditor(null);
    }

    @Override
    public Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor2, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            LocalHintManager.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            LocalHintManager.$$$reportNull$$$0(9);
        }
        EDT.assertIsEdt();
        LogicalPosition pos = editor2.getCaretModel().getLogicalPosition();
        DataContext dataContext = ((EditorEx)editor2).getDataContext();
        Rectangle dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(dataContext);
        if (dominantArea != null) {
            return HintManagerImpl.getHintPositionRelativeTo(hint, editor2, constraint, dominantArea, pos);
        }
        JRootPane rootPane = editor2.getComponent().getRootPane();
        if (rootPane != null) {
            JLayeredPane lp = rootPane.getLayeredPane();
            for (HintManagerImpl.HintInfo info2 : this.myHintsStack) {
                if (!info2.hint.isSelectingHint()) continue;
                IdeTooltip tooltip2 = info2.hint.getCurrentIdeTooltip();
                if (tooltip2 != null) {
                    Point p = tooltip2.getShowingPoint().getPoint((Component)lp);
                    if (info2.hint != hint) {
                        switch (constraint) {
                            case 1: {
                                if (tooltip2.getPreferredPosition() != Balloon.Position.below) break;
                                p.y -= tooltip2.getPositionChangeY();
                                break;
                            }
                            case 2: 
                            case 5: {
                                if (tooltip2.getPreferredPosition() != Balloon.Position.above) break;
                                p.y += tooltip2.getPositionChangeY();
                                break;
                            }
                            case 4: {
                                if (tooltip2.getPreferredPosition() != Balloon.Position.atLeft) break;
                                p.x += tooltip2.getPositionChangeX();
                                break;
                            }
                            case 3: {
                                if (tooltip2.getPreferredPosition() != Balloon.Position.atRight) break;
                                p.x -= tooltip2.getPositionChangeX();
                            }
                        }
                    }
                    return p;
                }
                Rectangle rectangle = info2.hint.getBounds();
                JComponent c = info2.hint.getComponent();
                rectangle = SwingUtilities.convertRectangle(c.getParent(), rectangle, lp);
                return HintManagerImpl.getHintPositionRelativeTo(hint, editor2, constraint, rectangle, pos);
            }
        }
        return HintManagerImpl.getHintPosition(hint, editor2, pos, constraint);
    }

    @Override
    public void showErrorHint(@NotNull Editor editor2, @NotNull @NlsContexts.HintText String text2, short position) {
        if (editor2 == null) {
            LocalHintManager.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            LocalHintManager.$$$reportNull$$$0(11);
        }
        JComponent label2 = HintUtil.createErrorLabel(text2);
        LightweightHint hint = new LightweightHint(label2);
        Point p = this.getHintPosition(hint, editor2, position);
        this.showEditorHint(hint, editor2, p, 42, 0, false, position);
    }

    @Override
    public void showInformationHint(@NotNull Editor editor2, @NotNull JComponent component2, @HintManager.PositionFlags short position, @Nullable Runnable onHintHidden) {
        if (editor2 == null) {
            LocalHintManager.$$$reportNull$$$0(12);
        }
        if (component2 == null) {
            LocalHintManager.$$$reportNull$$$0(13);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        AccessibleContextUtil.setName((Component)component2, (String)IdeBundle.message((String)"information.hint.accessible.context.name", (Object[])new Object[0]));
        LightweightHint hint = new LightweightHint(component2);
        if (onHintHidden != null) {
            hint.addHintListener(event -> onHintHidden.run());
        }
        Point p = this.getHintPosition(hint, editor2, position);
        this.showEditorHint(hint, editor2, p, 42, 0, false, position);
    }

    @Override
    public void showQuestionHint(@NotNull Editor editor2, @NotNull Point p, int offset1, int offset2, final @NotNull LightweightHint hint, @NotNull QuestionAction action2, @HintManager.PositionFlags short constraint) {
        RangeHighlighter highlighter;
        if (editor2 == null) {
            LocalHintManager.$$$reportNull$$$0(14);
        }
        if (p == null) {
            LocalHintManager.$$$reportNull$$$0(15);
        }
        if (hint == null) {
            LocalHintManager.$$$reportNull$$$0(16);
        }
        if (action2 == null) {
            LocalHintManager.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.hideQuestionHint();
        if (offset1 != offset2) {
            TextAttributes attributes2 = new TextAttributes();
            attributes2.setEffectColor(HintUtil.QUESTION_UNDERSCORE_COLOR);
            attributes2.setEffectType(EffectType.LINE_UNDERSCORE);
            highlighter = editor2.getMarkupModel().addRangeHighlighter(offset1, offset2, 5001, attributes2, HighlighterTargetArea.EXACT_RANGE);
        } else {
            highlighter = null;
        }
        hint.addHintListener(new HintListener(){

            @Override
            public void hintHidden(@NotNull EventObject event) {
                if (event == null) {
                    11.$$$reportNull$$$0(0);
                }
                hint.removeHintListener(this);
                if (highlighter != null) {
                    highlighter.dispose();
                }
                if (LocalHintManager.this.myQuestionHint == hint) {
                    LocalHintManager.this.myQuestionAction = null;
                    LocalHintManager.this.myQuestionHint = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/hint/LocalHintManager$11", "hintHidden"));
            }
        });
        this.showEditorHint(hint, editor2, p, 714, 0, false, HintManagerImpl.createHintHint(editor2, p, hint, constraint));
        this.myQuestionAction = action2;
        this.myQuestionHint = hint;
    }

    private void hideQuestionHint() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myQuestionHint != null) {
            this.myQuestionHint.hide();
            this.myQuestionHint = null;
            this.myQuestionAction = null;
        }
    }

    protected void updateLastEditor(Editor editor2) {
        if (this.myLastEditor != editor2) {
            if (this.myLastEditor != null) {
                this.myLastEditor.removeEditorMouseListener(this.myEditorMouseListener);
                this.myLastEditor.getDocument().removeDocumentListener(this.myEditorDocumentListener);
                this.myLastEditor.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
                this.myLastEditor.getCaretModel().removeCaretListener(this.myCaretMoveListener);
                this.myLastEditor.getSelectionModel().removeSelectionListener(this.mySelectionListener);
            }
            this.myLastEditor = editor2;
            if (this.myLastEditor != null) {
                this.myLastEditor.addEditorMouseListener(this.myEditorMouseListener);
                this.myLastEditor.getDocument().addDocumentListener(this.myEditorDocumentListener);
                this.myLastEditor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
                this.myLastEditor.getCaretModel().addCaretListener(this.myCaretMoveListener);
                this.myLastEditor.getSelectionModel().addSelectionListener(this.mySelectionListener);
            }
        }
    }

    @Override
    public boolean isEscapeHandlerEnabled() {
        boolean isEDT = EDT.isCurrentThreadEdt();
        HintManagerImpl.HintInfo[] arr = this.myHintsStack.toArray(new HintManagerImpl.HintInfo[0]);
        for (int i2 = arr.length - 1; i2 > -1; --i2) {
            HintManagerImpl.HintInfo info2 = arr[i2];
            if (!info2.hint.isVisible()) {
                if (!isEDT) continue;
                this.myHintsStack.remove(info2);
                info2.hint.hide();
                continue;
            }
            if ((info2.flags & 3) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hideHints(int mask, boolean onlyOne, boolean editorChanged) {
        EDT.assertIsEdt();
        boolean result2 = false;
        HintManagerImpl.HintInfo[] arr = this.myHintsStack.toArray(new HintManagerImpl.HintInfo[0]);
        for (int i2 = arr.length - 1; i2 > -1; --i2) {
            HintManagerImpl.HintInfo info2 = arr[i2];
            if (!info2.hint.isVisible() && !info2.hint.vetoesHiding()) {
                this.myHintsStack.remove(info2);
                info2.hint.hide();
                continue;
            }
            if ((info2.flags & mask) == 0 && (!editorChanged || info2.reviveOnEditorChange)) continue;
            this.myHintsStack.remove(info2);
            info2.hint.hide();
            if ((mask & 1) != 0 && (info2.flags & 0x200) != 0) continue;
            result2 = true;
            if (onlyOne) break;
        }
        if (this.myHintsStack.isEmpty()) {
            this.updateLastEditor(null);
        }
        return result2;
    }

    @Override
    public void onProjectClosed(@NotNull Project project) {
        if (project == null) {
            LocalHintManager.$$$reportNull$$$0(18);
        }
        this.myQuestionAction = null;
        this.myQuestionHint = null;
        if (this.myLastEditor != null && project == this.myLastEditor.getProject()) {
            this.updateLastEditor(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/LocalHintManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showEditorHint";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showHint";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getHintPosition";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorHint";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "showInformationHint";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "showQuestionHint";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyDynamicPluginListener
    implements DynamicPluginListener {
        private MyDynamicPluginListener() {
        }

        @Override
        public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            if (pluginDescriptor == null) {
                MyDynamicPluginListener.$$$reportNull$$$0(0);
            }
            LocalHintManager.this.cleanup();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/codeInsight/hint/LocalHintManager$MyDynamicPluginListener", "pluginUnloaded"));
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            if (action2 instanceof HintManagerImpl.ActionToIgnore) {
                return;
            }
            AnAction escapeAction = ActionManagerEx.getInstanceEx().getAction("EditorEscape");
            if (action2 == escapeAction) {
                return;
            }
            LocalHintManager.this.hideHints(2, false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/hint/LocalHintManager$MyAnActionListener";
            objectArray[2] = "beforeActionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

