/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hints.InlayHintsPassFactory;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsProviderExtension;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.ProviderInfo;
import com.intellij.codeInsight.hints.VcsCodeAuthorInlayHintsProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationsPreloader;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.ApplicationKt;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.CacheableAnnotationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\b\u0010\f\u001a\u00020\rH\u0002\u001a\b\u0010\u000e\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\b\u0010\u0011\u001a\u00020\rH\u0000\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"VCS_CODE_AUTHOR_ANNOTATION", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/vcs/annotate/FileAnnotation;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getAnnotation", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isCodeAuthorEnabledForApplication", "", "isCodeAuthorEnabledInSettings", "language", "Lcom/intellij/lang/Language;", "isCodeAuthorInlayHintsEnabled", "refreshCodeAuthorInlayHints", "", "registerAnnotation", "annotation", "unregisterAnnotation", "intellij.platform.vcs.impl"})
public final class VcsCodeAuthorInlayHintsProviderKt {
    private static final Key<FileAnnotation> VCS_CODE_AUTHOR_ANNOTATION;

    private static final boolean isCodeAuthorEnabledForApplication() {
        return !ApplicationKt.getApplication().isUnitTestMode() && Registry.is((String)"vcs.code.author.inlay.hints");
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isCodeAuthorEnabledInSettings() {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = InlayHintsProviderExtension.INSTANCE.findProviders();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProviderInfo it = (ProviderInfo)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getProvider().getKey(), VcsCodeAuthorInlayHintsProvider.Companion.getKEY$intellij_platform_vcs_impl())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ProviderInfo it = (ProviderInfo)element$iv;
                    boolean bl3 = false;
                    if (!InlayHintsSettings.Companion.instance().hintsShouldBeShown(it.getProvider().getKey(), it.getLanguage())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isCodeAuthorEnabledInSettings(Language language2) {
        boolean bl;
        block3: {
            List list2 = InlayHintsProviderExtension.INSTANCE.allForLanguage(language2);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"InlayHintsProviderExtens\u2026.allForLanguage(language)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    InlayHintsProvider it = (InlayHintsProvider)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getKey(), VcsCodeAuthorInlayHintsProvider.Companion.getKEY$intellij_platform_vcs_impl())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean hasProviderForLanguage = bl;
        return hasProviderForLanguage && InlayHintsSettings.Companion.instance().hintsShouldBeShown(VcsCodeAuthorInlayHintsProvider.Companion.getKEY$intellij_platform_vcs_impl(), language2);
    }

    public static final boolean isCodeAuthorInlayHintsEnabled() {
        return VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorEnabledForApplication() && VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorEnabledInSettings();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static final void refreshCodeAuthorInlayHints(@NotNull Project project, @NotNull VirtualFile file2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorEnabledForApplication()) {
            return;
        }
        PsiManagerEx psiManagerEx = PsiManagerEx.getInstanceEx(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)psiManagerEx), (String)"PsiManagerEx.getInstanceEx(project)");
        PsiFile psiFile = psiManagerEx.getFileManager().getCachedPsiFile(file2);
        if (psiFile != null) {
            Language language2 = psiFile.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"psiFile.language");
            if (!VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorEnabledInSettings(language2)) {
                return;
            }
        }
        List<Editor> list2 = VcsAnnotateUtil.getEditors(project, file2);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"VcsAnnotateUtil.getEditors(project, file)");
        List<Editor> editors2 = list2;
        Iterable $this$filter$iv = editors2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Editor it = (Editor)element$iv$iv;
            boolean bl = false;
            if (!(it.getUserData(VCS_CODE_AUTHOR_ANNOTATION) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List noCodeAuthorEditors = (List)destination$iv$iv;
        if (noCodeAuthorEditors.isEmpty()) {
            return;
        }
        Iterator iterator2 = noCodeAuthorEditors.iterator();
        while (iterator2.hasNext()) {
            Editor editor2;
            Editor editor3 = editor2 = (Editor)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor");
            InlayHintsPassFactory.Companion.clearModificationStamp(editor3);
        }
        if (psiFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
        }
    }

    private static final FileAnnotation getAnnotation(Project project, VirtualFile file2, Editor editor2) {
        FileAnnotation fileAnnotation = (FileAnnotation)editor2.getUserData(VCS_CODE_AUTHOR_ANNOTATION);
        if (fileAnnotation != null) {
            FileAnnotation fileAnnotation2 = fileAnnotation;
            boolean bl = false;
            boolean bl2 = false;
            FileAnnotation it = fileAnnotation2;
            boolean bl3 = false;
            return it;
        }
        AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file2);
        if (abstractVcs == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"ProjectLevelVcsManager.g\u2026sFor(file) ?: return null");
        AbstractVcs vcs = abstractVcs;
        AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (!(annotationProvider instanceof CacheableAnnotationProvider)) {
            annotationProvider = null;
        }
        CacheableAnnotationProvider cacheableAnnotationProvider = (CacheableAnnotationProvider)annotationProvider;
        if (cacheableAnnotationProvider == null) {
            return null;
        }
        CacheableAnnotationProvider provider2 = cacheableAnnotationProvider;
        FileAnnotation fileAnnotation3 = provider2.getFromCache(file2);
        if (fileAnnotation3 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fileAnnotation3, (String)"provider.getFromCache(file) ?: return null");
        FileAnnotation annotation = fileAnnotation3;
        Disposable annotationDisposable2 = new Disposable(file2, annotation){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ FileAnnotation $annotation;

            public final void dispose() {
                VcsCodeAuthorInlayHintsProviderKt.access$unregisterAnnotation(this.$file, this.$annotation);
                this.$annotation.dispose();
            }
            {
                this.$file = virtualFile2;
                this.$annotation = fileAnnotation;
            }
        };
        annotation.setCloser(new Runnable(editor2, annotationDisposable2, project, file2){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Disposable $annotationDisposable;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;

            public final void run() {
                this.$editor.putUserData(VcsCodeAuthorInlayHintsProviderKt.access$getVCS_CODE_AUTHOR_ANNOTATION$p(), null);
                Disposer.dispose((Disposable)this.$annotationDisposable);
                Project $this$service$iv = this.$project;
                boolean $i$f$service = false;
                Object object = $this$service$iv.getService(AnnotationsPreloader.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                ((AnnotationsPreloader)object).schedulePreloading(this.$file);
            }
            {
                this.$editor = editor2;
                this.$annotationDisposable = disposable2;
                this.$project = project;
                this.$file = virtualFile2;
            }
        });
        annotation.setReloader(new Consumer(annotation){
            final /* synthetic */ FileAnnotation $annotation;

            public final void consume(FileAnnotation it) {
                this.$annotation.close();
            }
            {
                this.$annotation = fileAnnotation;
            }
        });
        editor2.putUserData(VCS_CODE_AUTHOR_ANNOTATION, (Object)annotation);
        VcsCodeAuthorInlayHintsProviderKt.registerAnnotation(file2, annotation);
        EditorUtil.disposeWithEditor(editor2, annotationDisposable2);
        return annotation;
    }

    private static final void registerAnnotation(VirtualFile file2, FileAnnotation annotation) {
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)annotation.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.g\u2026tance(annotation.project)");
        projectLevelVcsManager.getAnnotationLocalChangesListener().registerAnnotation(file2, annotation);
    }

    private static final void unregisterAnnotation(VirtualFile file2, FileAnnotation annotation) {
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)annotation.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.g\u2026tance(annotation.project)");
        projectLevelVcsManager.getAnnotationLocalChangesListener().unregisterAnnotation(file2, annotation);
    }

    static {
        Key key = Key.create((String)"Vcs.CodeAuthor.Annotation");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<FileAnnotatio\u2026s.CodeAuthor.Annotation\")");
        VCS_CODE_AUTHOR_ANNOTATION = key;
    }

    public static final /* synthetic */ boolean access$isCodeAuthorEnabledForApplication() {
        return VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorEnabledForApplication();
    }

    public static final /* synthetic */ FileAnnotation access$getAnnotation(Project project, VirtualFile file2, Editor editor2) {
        return VcsCodeAuthorInlayHintsProviderKt.getAnnotation(project, file2, editor2);
    }

    public static final /* synthetic */ void access$unregisterAnnotation(VirtualFile file2, FileAnnotation annotation) {
        VcsCodeAuthorInlayHintsProviderKt.unregisterAnnotation(file2, annotation);
    }

    public static final /* synthetic */ Key access$getVCS_CODE_AUTHOR_ANNOTATION$p() {
        return VCS_CODE_AUTHOR_ANNOTATION;
    }
}

