/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupTypedHandler
extends TypedActionHandlerBase {
    private static final Logger LOG = Logger.getInstance(LookupTypedHandler.class);

    public LookupTypedHandler(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    public void execute(@NotNull Editor originalEditor, char charTyped, @NotNull DataContext dataContext) {
        Editor editor2;
        Project project;
        PsiFile file2;
        if (originalEditor == null) {
            LookupTypedHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            LookupTypedHandler.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = file2 = (project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null ? null : PsiUtilBase.getPsiFileInEditor((Editor)originalEditor, (Project)project);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
            }
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)originalEditor)) {
            return;
        }
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments && oldPhase.indicator != null) {
            oldPhase.indicator.scheduleRestart();
        }
        if ((editor2 = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, originalEditor, file2)) != originalEditor) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        }
        if (originalEditor.isInsertMode() && LookupTypedHandler.beforeCharTyped(charTyped, project, originalEditor, editor2, file2)) {
            return;
        }
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
        }
    }

    private static boolean beforeCharTyped(char charTyped, Project project, Editor originalEditor, Editor editor2, PsiFile file2) {
        LookupElement item;
        LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup(originalEditor);
        if (lookup2 == null) {
            return false;
        }
        if (charTyped == ' ' && ChooseItemAction.hasTemplatePrefix(lookup2, ' ')) {
            return false;
        }
        CharFilter.Result result2 = LookupTypedHandler.getLookupAction(charTyped, lookup2);
        if (lookup2.isLookupDisposed()) {
            return false;
        }
        if (result2 == CharFilter.Result.ADD_TO_PREFIX) {
            CompletionProgressIndicator completion;
            Document document = editor2.getDocument();
            long modificationStamp = document.getModificationStamp();
            if (!lookup2.performGuardedChange(() -> {
                lookup2.fireBeforeAppendPrefix(charTyped);
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets((Editor)originalEditor, (String)String.valueOf(charTyped), (boolean)true);
            })) {
                return true;
            }
            lookup2.appendPrefix(charTyped);
            if (lookup2.isStartCompletionWhenNothingMatches() && lookup2.getItems().isEmpty()) {
                completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
                if (completion != null) {
                    completion.scheduleRestart();
                } else {
                    AutoPopupController.getInstance(editor2.getProject()).scheduleAutoPopup(editor2);
                }
            }
            originalEditor.getCaretModel().runForEachCaret(caret -> {
                DataContext context2 = DataManager.getInstance().getDataContext((Component)originalEditor.getContentComponent());
                AutoHardWrapHandler.getInstance().wrapLineIfNecessary(originalEditor, context2, modificationStamp);
            });
            completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
            if (completion != null) {
                completion.prefixUpdated();
            }
            return true;
        }
        if (result2 == CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP && lookup2.isFocused() && (item = lookup2.getCurrentItem()) != null) {
            if (LookupTypedHandler.completeTillTypedCharOccurrence(charTyped, lookup2, item)) {
                return true;
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByDotEtc");
            lookup2.finishLookupInWritableFile(charTyped, item);
            return true;
        }
        lookup2.hide();
        TypedHandler.autoPopupCompletion(editor2, charTyped, project, file2);
        return false;
    }

    private static boolean completeTillTypedCharOccurrence(char charTyped, LookupImpl lookup2, LookupElement item) {
        String oldPrefix;
        PrefixMatcher matcher = lookup2.itemMatcher(item);
        PrefixMatcher expanded2 = matcher.cloneWithPrefix((oldPrefix = matcher.getPrefix() + lookup2.getAdditionalPrefix()) + charTyped);
        if (expanded2.prefixMatches(item)) {
            for (String s : item.getAllLookupStrings()) {
                if (!matcher.prefixMatches(s)) continue;
                int i2 = -1;
                while ((i2 = s.indexOf(charTyped, i2 + 1)) >= 0) {
                    String newPrefix = s.substring(0, i2 + 1);
                    if (!expanded2.prefixMatches(newPrefix)) continue;
                    lookup2.replacePrefix(oldPrefix, newPrefix);
                    return true;
                }
            }
        }
        return false;
    }

    public static CharFilter.Result getLookupAction(char charTyped, LookupImpl lookup2) {
        CharFilter.Result filtersDecision = LookupTypedHandler.getFilterDecision(charTyped, lookup2);
        if (filtersDecision != null) {
            return filtersDecision;
        }
        return CharFilter.Result.HIDE_LOOKUP;
    }

    @Nullable
    private static CharFilter.Result getFilterDecision(char charTyped, LookupImpl lookup2) {
        lookup2.checkValid();
        LookupElement item = lookup2.getCurrentItem();
        int prefixLength = item == null ? lookup2.getAdditionalPrefix().length() : lookup2.itemPattern(item).length();
        for (CharFilter extension2 : CharFilter.EP_NAME.getExtensionList()) {
            CharFilter.Result result2 = extension2.acceptChar(charTyped, prefixLength, lookup2);
            if (result2 != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(extension2 + " of " + extension2.getClass() + " returned " + result2);
                }
                return result2;
            }
            if (lookup2.isLookupDisposed()) {
                throw new AssertionError((Object)("Lookup disposed after " + extension2));
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "originalEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/lookup/impl/LookupTypedHandler";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

