/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl.actions;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.editorActions.ExpandLiveTemplateCustomAction;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.LatencyAwareEditorAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseItemAction
extends EditorAction
implements HintManagerImpl.ActionToIgnore,
LatencyAwareEditorAction {
    public ChooseItemAction(Handler handler2) {
        super((EditorActionHandler)handler2);
    }

    public static boolean hasTemplatePrefix(LookupImpl lookup2, char shortcutChar) {
        lookup2.refreshUi(false, false);
        CompletionProcess completion = CompletionService.getCompletionService().getCurrentCompletion();
        if (completion == null || !completion.isAutopopupCompletion()) {
            return false;
        }
        if (lookup2.isSelectionTouched()) {
            return false;
        }
        PsiFile file2 = lookup2.getPsiFile();
        if (file2 == null) {
            return false;
        }
        Editor editor2 = lookup2.getEditor();
        int offset = editor2.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor2.getDocument());
        LiveTemplateLookupElement liveTemplateLookup = (LiveTemplateLookupElement)((Object)ContainerUtil.findInstance(lookup2.getItems(), LiveTemplateLookupElement.class));
        if (liveTemplateLookup == null || !liveTemplateLookup.sudden) {
            if (LiveTemplateCompletionContributor.customTemplateAvailableAndHasCompletionItem(Character.valueOf(shortcutChar), editor2, file2, offset)) {
                return true;
            }
            List templates = (List)SlowOperations.allowSlowOperations(() -> TemplateManagerImpl.listApplicableTemplateWithInsertingDummyIdentifier(TemplateActionContext.expanding((PsiFile)file2, (Editor)editor2)));
            TemplateImpl template = LiveTemplateCompletionContributor.findFullMatchedApplicableTemplate(editor2, offset, templates);
            return template != null && shortcutChar == TemplateSettings.getInstance().getShortcutChar(template);
        }
        return liveTemplateLookup.getTemplateShortcut() == shortcutChar;
    }

    public static class ChooseWithDot
    extends ChooseItemAction {
        public ChooseWithDot() {
            super(new Handler(false, '.'));
        }
    }

    public static class CompletingStatement
    extends ChooseItemAction {
        public CompletingStatement() {
            super(new Handler(true, '\r'));
        }
    }

    public static class Replacing
    extends ChooseItemAction {
        public Replacing() {
            super(new Handler(false, '\t'));
        }
    }

    public static class FocusedOnly
    extends ChooseItemAction {
        public FocusedOnly() {
            super(new Handler(true, '\n'));
        }
    }

    public static class Handler
    extends EditorActionHandler {
        final boolean focusedOnly;
        final char finishingChar;

        public Handler(boolean focusedOnly, char finishingChar) {
            this.focusedOnly = focusedOnly;
            this.finishingChar = finishingChar;
        }

        public void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup(editor2);
            assert (lookup2 != null);
            if ((this.finishingChar == '\n' || this.finishingChar == '\t') && ChooseItemAction.hasTemplatePrefix(lookup2, this.finishingChar)) {
                lookup2.hideLookup(true);
                ExpandLiveTemplateCustomAction.createExpandTemplateHandler(this.finishingChar).execute(editor2, null, dataContext);
                return;
            }
            if (this.finishingChar == '\n') {
                if (!lookup2.isFocused()) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByControlEnter");
                }
            } else if (this.finishingChar == '\r') {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishBySmartEnter");
            } else if (this.finishingChar == '\t') {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.replace");
            } else if (this.finishingChar == '.') {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByCtrlDot");
            }
            SlowOperations.allowSlowOperations(() -> lookup2.finishLookup(this.finishingChar));
        }

        public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
            LookupImpl lookup2;
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if ((lookup2 = (LookupImpl)LookupManager.getActiveLookup(editor2)) == null) {
                return false;
            }
            if (!lookup2.isAvailableToUser()) {
                return false;
            }
            if (lookup2.getCurrentItemOrEmpty() == null) {
                return false;
            }
            if (this.focusedOnly && lookup2.getLookupFocusDegree() == LookupFocusDegree.UNFOCUSED) {
                return false;
            }
            if (this.finishingChar == '\t') {
                return !lookup2.getItems().isEmpty();
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/lookup/impl/actions/ChooseItemAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

