/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.util.DefaultModuleRendererFactory;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.TargetPresentation;
import com.intellij.navigation.TargetPresentationBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import com.intellij.util.TextWithIcon;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u000b*\u00020\u0013H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0013H\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"CONTAINER_PATTERN", "Ljava/util/regex/Pattern;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "fileLocation", "Lcom/intellij/util/TextWithIcon;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "presentationError", "", "element", "Lcom/intellij/psi/PsiElement;", "targetPresentation", "Lcom/intellij/navigation/TargetPresentation;", "itemPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getColoredAttributes", "getContainerText", "", "intellij.platform.lang.impl"})
public final class UtilKt {
    private static final Logger LOG;
    private static final Pattern CONTAINER_PATTERN;

    @ApiStatus.Internal
    @NotNull
    public static final TargetPresentation targetPresentation(@NotNull ItemPresentation itemPresentation) {
        Intrinsics.checkNotNullParameter((Object)itemPresentation, (String)"itemPresentation");
        String string = itemPresentation.getPresentableText();
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPresentation.presentableText ?: \"\"");
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(string).icon(itemPresentation.getIcon(false)).presentableTextAttributes(UtilKt.getColoredAttributes(itemPresentation)).containerText(UtilKt.getContainerText(itemPresentation)).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"TargetPresentation\n    .\u2026xt())\n    .presentation()");
        return targetPresentation;
    }

    private static final TextAttributes getColoredAttributes(ItemPresentation $this$getColoredAttributes) {
        ColoredItemPresentation coloredPresentation;
        ColoredItemPresentation coloredItemPresentation;
        ItemPresentation itemPresentation = $this$getColoredAttributes;
        if (!(itemPresentation instanceof ColoredItemPresentation)) {
            itemPresentation = null;
        }
        if ((coloredItemPresentation = (coloredPresentation = (ColoredItemPresentation)itemPresentation)) == null || (coloredItemPresentation = coloredItemPresentation.getTextAttributesKey()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)coloredItemPresentation, (String)"coloredPresentation?.tex\u2026ributesKey ?: return null");
        ColoredItemPresentation textAttributesKey = coloredItemPresentation;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        return editorColorsManager.getSchemeForCurrentUITheme().getAttributes((TextAttributesKey)textAttributesKey);
    }

    @Nls
    private static final String getContainerText(ItemPresentation $this$getContainerText) {
        String string = $this$getContainerText.getLocationString();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"locationString ?: return null");
        String locationString = string;
        Matcher matcher = CONTAINER_PATTERN.matcher(locationString);
        return matcher.matches() ? matcher.group(2) : locationString;
    }

    @ApiStatus.Internal
    @NotNull
    public static final TargetPresentation targetPresentation(@NotNull PsiElement element2) {
        TextAttributes textAttributes;
        Color color;
        Object object;
        TargetPresentationBuilder targetPresentationBuilder;
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        Project project2 = project;
        PsiFile psiFile = element2.getContainingFile();
        VirtualFile file2 = psiFile != null ? psiFile.getVirtualFile() : null;
        PsiElement psiElement = element2;
        if (!(psiElement instanceof NavigationItem)) {
            psiElement = null;
        }
        NavigationItem navigationItem = (NavigationItem)psiElement;
        Object itemPresentation = navigationItem != null ? navigationItem.getPresentation() : null;
        Object object4 = itemPresentation;
        if (object4 == null || (object4 = object4.getPresentableText()) == null) {
            PsiElement psiElement2 = element2;
            if (!(psiElement2 instanceof PsiNamedElement)) {
                psiElement2 = null;
            }
            PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement2;
            object4 = object3 = psiNamedElement != null ? psiNamedElement.getName() : null;
        }
        if (object4 == null) {
            object3 = object2 = element2.getText();
        }
        if (object3 == null) {
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            UtilKt.presentationError(element2);
            object2 = element2.toString();
        }
        Object presentableText2 = object2;
        TextWithIcon moduleTextWithIcon = PsiElementListCellRenderer.getModuleTextWithIcon(element2);
        TargetPresentationBuilder targetPresentationBuilder2 = TargetPresentation.Companion.builder((String)presentableText2);
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            bl2 = false;
            bl = false;
            VirtualFile virtualFile4 = virtualFile3;
            targetPresentationBuilder = targetPresentationBuilder2;
            boolean bl6 = false;
            object = VfsPresentationUtil.getFileBackgroundColor(project2, file2);
            targetPresentationBuilder2 = targetPresentationBuilder;
            color = object;
        } else {
            color = null;
        }
        ItemPresentation itemPresentation2 = itemPresentation;
        TargetPresentationBuilder targetPresentationBuilder3 = targetPresentationBuilder2.backgroundColor(color).icon(element2.getIcon(3)).presentableTextAttributes((TextAttributes)(itemPresentation2 != null ? UtilKt.getColoredAttributes(itemPresentation2) : null));
        ItemPresentation itemPresentation3 = itemPresentation;
        Object object5 = itemPresentation3 != null ? UtilKt.getContainerText(itemPresentation3) : null;
        VirtualFile virtualFile5 = file2;
        if (virtualFile5 != null) {
            VirtualFile virtualFile6 = virtualFile5;
            bl2 = false;
            bl = false;
            VirtualFile it = virtualFile6;
            object = object5;
            targetPresentationBuilder = targetPresentationBuilder3;
            boolean bl7 = false;
            TextAttributes textAttributes2 = UtilKt.fileStatusAttributes(project2, file2);
            targetPresentationBuilder3 = targetPresentationBuilder;
            object5 = object;
            textAttributes = textAttributes2;
        } else {
            textAttributes = null;
        }
        TextWithIcon textWithIcon = moduleTextWithIcon;
        TextWithIcon textWithIcon2 = moduleTextWithIcon;
        TargetPresentation targetPresentation = targetPresentationBuilder3.containerText((String)object5, textAttributes).locationText(textWithIcon != null ? textWithIcon.getText() : null, textWithIcon2 != null ? textWithIcon2.getIcon() : null).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"TargetPresentation\n    .\u2026icon)\n    .presentation()");
        return targetPresentation;
    }

    private static final void presentationError(PsiElement element2) {
        Class<?> clazz = element2.getClass();
        LOG.error((Throwable)PluginException.createByClass((String)(clazz.getName() + " cannot be presented"), null, clazz));
    }

    @ApiStatus.Experimental
    @Nullable
    public static final TextAttributes fileStatusAttributes(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file2);
        Color fileColor = fileStatus != null ? fileStatus.getColor() : null;
        boolean hasProblem = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(file2);
        return hasProblem ? new TextAttributes(fileColor, null, (Color)JBColor.red, EffectType.WAVE_UNDERSCORE, 0) : (fileColor != null ? new TextAttributes(fileColor, null, null, null, 0) : null);
    }

    @ApiStatus.Experimental
    @Nullable
    public static final TextWithIcon fileLocation(@NotNull Project project, @NotNull VirtualFile file2) {
        Module module;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        return fileIndex.isInLibrary(file2) ? new DefaultModuleRendererFactory().libraryLocation(fileIndex, file2) : ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project)) != null ? DefaultModuleRendererFactory.projectLocation(file2, module, fileIndex) : null);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.codeInsight.navigation");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026.codeInsight.navigation\")");
        LOG = logger;
        Pattern pattern = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"(\\\\(in |\\\\()?([^)]*)(\\\\))?\")");
        CONTAINER_PATTERN = pattern;
    }
}

