/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.actions;

import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;

public class EmmetEditPointUtil {
    public static void moveForward(Editor editor2, PsiFile file2) {
        if (!XmlGtTypedHandler.fileContainsXmlLanguage(file2)) {
            return;
        }
        EmmetEditPointUtil.moveToNextPoint(editor2, file2, editor2.getCaretModel().getOffset(), 1);
    }

    public static void moveBackward(Editor editor2, PsiFile file2) {
        if (!XmlGtTypedHandler.fileContainsXmlLanguage(file2)) {
            return;
        }
        EmmetEditPointUtil.moveToNextPoint(editor2, file2, editor2.getCaretModel().getOffset(), -1);
    }

    private static void moveToNextPoint(Editor editor2, PsiFile file2, int offset, int inc) {
        Document doc = editor2.getDocument();
        TemplateLanguageFileViewProvider provider2 = (TemplateLanguageFileViewProvider)ObjectUtils.tryCast((Object)file2.getViewProvider(), TemplateLanguageFileViewProvider.class);
        Language additionalLanguage = provider2 != null ? provider2.getTemplateDataLanguage() : null;
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(doc);
        for (int i2 = offset + inc; i2 < doc.getTextLength() && i2 >= 0; i2 += inc) {
            PsiElement current2 = InjectedLanguageUtil.findElementAtNoCommit(file2, i2);
            if (EmmetEditPointUtil.checkAndMove(editor2, doc, i2, current2)) {
                return;
            }
            if (additionalLanguage == null || !EmmetEditPointUtil.checkAndMove(editor2, doc, i2, current2 = provider2.findElementAt(i2, additionalLanguage))) continue;
            return;
        }
    }

    private static boolean checkAndMove(Editor editor2, Document doc, int offset, PsiElement current2) {
        if (current2 == null) {
            return false;
        }
        if (current2.getParent() instanceof XmlText) {
            int line = doc.getLineNumber(offset);
            int lineStart = doc.getLineStartOffset(line);
            int lineEnd = doc.getLineEndOffset(line);
            CharSequence text2 = doc.getCharsSequence().subSequence(lineStart, lineEnd);
            if (StringUtil.isEmptyOrSpaces((CharSequence)text2) && EmmetEditPointUtil.moveCaret(editor2, current2, lineEnd)) {
                return true;
            }
        } else if (EmmetEditPointUtil.isEmptyEditPoint(current2) && EmmetEditPointUtil.moveCaret(editor2, current2, current2.getTextRange().getStartOffset())) {
            return true;
        }
        return false;
    }

    private static boolean moveCaret(Editor editor2, PsiElement current2, int offset) {
        CaretModel caretModel = (editor2 = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor2, current2.getContainingFile())).getCaretModel();
        if (caretModel.getOffset() == offset) {
            return false;
        }
        caretModel.moveToOffset(offset);
        Caret caret = caretModel.getCurrentCaret();
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        if (caret == caretModel.getPrimaryCaret()) {
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
        }
        return true;
    }

    private static boolean isEmptyEditPoint(PsiElement element2) {
        IElementType type = element2.getNode().getElementType();
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            PsiElement prev2 = PsiTreeUtil.prevLeaf((PsiElement)element2);
            return prev2 != null && prev2.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
        }
        if (type == XmlTokenType.XML_END_TAG_START || type == XmlTokenType.XML_START_TAG_START) {
            PsiElement prev3 = PsiTreeUtil.prevLeaf((PsiElement)element2);
            return prev3 != null && prev3.getNode().getElementType() == XmlTokenType.XML_TAG_END;
        }
        return false;
    }
}

