/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectionEngine {
    private static final Logger LOG = Logger.getInstance(InspectionEngine.class);
    private static final Set<Class<? extends LocalInspectionTool>> RECURSIVE_VISITOR_TOOL_CLASSES = ContainerUtil.newConcurrentSet();

    @NotNull
    public static PsiElementVisitor createVisitorAndAcceptElements(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2, @NotNull List<? extends PsiElement> elements) {
        PsiElementVisitor visitor;
        if (tool == null) {
            InspectionEngine.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            InspectionEngine.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            InspectionEngine.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(3);
        }
        if ((visitor = InspectionEngine.createVisitor(tool, holder, isOnTheFly, session2)) != PsiElementVisitor.EMPTY_VISITOR) {
            tool.inspectionStarted(session2, isOnTheFly);
            InspectionEngine.acceptElements(elements, visitor);
        }
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor == null) {
            InspectionEngine.$$$reportNull$$$0(4);
        }
        return psiElementVisitor;
    }

    @NotNull
    public static PsiElementVisitor createVisitor(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        PsiElementVisitor visitor;
        if (tool == null) {
            InspectionEngine.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            InspectionEngine.$$$reportNull$$$0(6);
        }
        if (session2 == null) {
            InspectionEngine.$$$reportNull$$$0(7);
        }
        if ((visitor = tool.buildVisitor(holder, isOnTheFly, session2)) == null) {
            LOG.error("Tool " + tool + " (" + tool.getClass() + ") must not return null from the buildVisitor() method");
        } else if (visitor instanceof PsiRecursiveVisitor && RECURSIVE_VISITOR_TOOL_CLASSES.add(tool.getClass())) {
            LOG.error("The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive: " + tool);
        }
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor == null) {
            InspectionEngine.$$$reportNull$$$0(8);
        }
        return psiElementVisitor;
    }

    public static void acceptElements(@NotNull List<? extends PsiElement> elements, @NotNull PsiElementVisitor elementVisitor) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(9);
        }
        if (elementVisitor == null) {
            InspectionEngine.$$$reportNull$$$0(10);
        }
        int elementsSize = elements.size();
        for (int i2 = 0; i2 < elementsSize; ++i2) {
            PsiElement element2 = elements.get(i2);
            element2.accept(elementVisitor);
            ProgressManager.checkCanceled();
        }
    }

    @NotNull
    private static List<ProblemDescriptor> inspect(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, @NotNull ProgressIndicator indicator2) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(12);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(13);
        }
        if (indicator2 == null) {
            InspectionEngine.$$$reportNull$$$0(14);
        }
        Map<String, List<ProblemDescriptor>> problemDescriptors = InspectionEngine.inspectEx(toolWrappers, file2, iManager, false, indicator2);
        ArrayList<ProblemDescriptor> result2 = new ArrayList<ProblemDescriptor>();
        for (List<ProblemDescriptor> group2 : problemDescriptors.values()) {
            result2.addAll(group2);
        }
        ArrayList<ProblemDescriptor> arrayList = result2;
        if (arrayList == null) {
            InspectionEngine.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator2) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(17);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(18);
        }
        if (indicator2 == null) {
            InspectionEngine.$$$reportNull$$$0(19);
        }
        TextRange restrictRange = file2.getTextRange();
        return InspectionEngine.inspectEx(toolWrappers, file2, restrictRange, iManager, isOnTheFly, indicator2);
    }

    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull TextRange restrictRange, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator2) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(21);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(22);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(23);
        }
        if (indicator2 == null) {
            InspectionEngine.$$$reportNull$$$0(24);
        }
        if (toolWrappers.isEmpty()) {
            Map<String, List<ProblemDescriptor>> map2 = Collections.emptyMap();
            if (map2 == null) {
                InspectionEngine.$$$reportNull$$$0(25);
            }
            return map2;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(file2, restrictRange, file2.getTextRange(), __ -> true, (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List elements = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> ContainerUtil.concat((List[])new List[]{d.inside, d.outside, d.parents})));
        return InspectionEngine.inspectElements(toolWrappers, file2, iManager, isOnTheFly, indicator2, elements, InspectionEngine.calcElementDialectIds(elements));
    }

    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectElements(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator2, @NotNull List<? extends PsiElement> elements, @NotNull Set<String> elementDialectIds) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(27);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(28);
        }
        if (indicator2 == null) {
            InspectionEngine.$$$reportNull$$$0(29);
        }
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(30);
        }
        if (elementDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(31);
        }
        TextRange range2 = file2.getTextRange();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(file2, range2.getStartOffset(), range2.getEndOffset());
        toolWrappers = InspectionEngine.filterToolsApplicableByLanguage(toolWrappers, elementDialectIds);
        ConcurrentHashMap<String, List<ProblemDescriptor>> resultDescriptors = new ConcurrentHashMap<String, List<ProblemDescriptor>>();
        Processor processor2 = wrapper2 -> {
            ProblemsHolder holder = new ProblemsHolder(iManager, file2, isOnTheFly);
            LocalInspectionTool tool = (LocalInspectionTool)wrapper2.getTool();
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session2, elements);
            tool.inspectionFinished(session2, holder);
            if (holder.hasResults()) {
                resultDescriptors.put(tool.getShortName(), ContainerUtil.filter((Collection)holder.getResults(), descriptor2 -> {
                    PsiElement element2 = descriptor2.getPsiElement();
                    return element2 == null || !SuppressionUtil.inspectionResultSuppressed(element2, tool);
                }));
            }
            return true;
        };
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(toolWrappers, indicator2, processor2);
        ConcurrentHashMap<String, List<ProblemDescriptor>> concurrentHashMap = resultDescriptors;
        if (concurrentHashMap == null) {
            InspectionEngine.$$$reportNull$$$0(32);
        }
        return concurrentHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<ProblemDescriptor> runInspectionOnFile(final @NotNull PsiFile file2, @NotNull InspectionToolWrapper<?, ?> toolWrapper, final @NotNull GlobalInspectionContext inspectionContext) {
        block15: {
            if (file2 == null) {
                InspectionEngine.$$$reportNull$$$0(33);
            }
            if (toolWrapper == null) {
                InspectionEngine.$$$reportNull$$$0(34);
            }
            if (inspectionContext == null) {
                InspectionEngine.$$$reportNull$$$0(35);
            }
            final InspectionManager inspectionManager = InspectionManager.getInstance((Project)file2.getProject());
            toolWrapper.initialize(inspectionContext);
            RefManagerImpl refManager = (RefManagerImpl)inspectionContext.getRefManager();
            refManager.inspectionReadActionStarted();
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                List<ProblemDescriptor> list2 = InspectionEngine.inspect(Collections.singletonList((LocalInspectionToolWrapper)toolWrapper), file2, inspectionManager, (ProgressIndicator)new EmptyProgressIndicator());
                List<ProblemDescriptor> list3 = list2;
                if (list3 == null) {
                    InspectionEngine.$$$reportNull$$$0(36);
                }
                return list3;
            }
            if (!(toolWrapper instanceof GlobalInspectionToolWrapper)) break block15;
            final GlobalInspectionTool globalTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
            final ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
            if (globalTool instanceof GlobalSimpleInspectionTool) {
                GlobalSimpleInspectionTool simpleTool = (GlobalSimpleInspectionTool)globalTool;
                ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, file2, false);
                ProblemDescriptionsProcessor collectProcessor = new ProblemDescriptionsProcessor(){

                    public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                        if (refEntity == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                    }

                    public void ignoreElement(@NotNull RefEntity refEntity) {
                        if (refEntity == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        throw new UnsupportedOperationException();
                    }

                    public void resolveProblem(@NotNull CommonProblemDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        throw new UnsupportedOperationException();
                    }

                    public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                        if (commonProblemDescriptors == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (!(refEntity instanceof RefElement)) {
                            return;
                        }
                        PsiElement element2 = ((RefElement)refEntity).getPsiElement();
                        InspectionEngine.convertToProblemDescriptors(element2, commonProblemDescriptors, descriptors);
                    }

                    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        throw new RuntimeException();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "refEntity";
                                break;
                            }
                            case 2: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "descriptor";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "commonProblemDescriptors";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/codeInspection/InspectionEngine$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "getDescriptions";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "ignoreElement";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "resolveProblem";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "addProblemElement";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "getElement";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                simpleTool.checkFile(file2, inspectionManager, problemsHolder, inspectionContext, collectProcessor);
                ArrayList<ProblemDescriptor> arrayList = descriptors;
                ArrayList<ProblemDescriptor> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    InspectionEngine.$$$reportNull$$$0(37);
                }
                return arrayList2;
            }
            RefElement fileRef = refManager.getReference((PsiElement)file2);
            final AnalysisScope scope2 = new AnalysisScope(file2);
            assert (fileRef != null);
            fileRef.accept(new RefVisitor(){

                public void visitElement(@NotNull RefEntity elem) {
                    CommonProblemDescriptor[] elemDescriptors;
                    if (elem == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((elemDescriptors = globalTool.checkElement(elem, scope2, inspectionManager, inspectionContext)) != null) {
                        InspectionEngine.convertToProblemDescriptors((PsiElement)file2, elemDescriptors, descriptors);
                    }
                    for (RefEntity child2 : elem.getChildren()) {
                        child2.accept((RefVisitor)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/InspectionEngine$2", "visitElement"));
                }
            });
            ArrayList<ProblemDescriptor> arrayList = descriptors;
            ArrayList<ProblemDescriptor> arrayList3 = arrayList;
            if (arrayList3 == null) {
                InspectionEngine.$$$reportNull$$$0(38);
            }
            return arrayList3;
            finally {
                refManager.inspectionReadActionFinished();
                toolWrapper.cleanup(file2.getProject());
                inspectionContext.cleanup();
            }
        }
        List<ProblemDescriptor> list4 = Collections.emptyList();
        if (list4 == null) {
            InspectionEngine.$$$reportNull$$$0(39);
        }
        return list4;
    }

    private static void convertToProblemDescriptors(@NotNull PsiElement element2, CommonProblemDescriptor @NotNull [] commonProblemDescriptors, @NotNull List<? super ProblemDescriptor> descriptors) {
        if (element2 == null) {
            InspectionEngine.$$$reportNull$$$0(40);
        }
        if (descriptors == null) {
            InspectionEngine.$$$reportNull$$$0(41);
        }
        if (commonProblemDescriptors == null) {
            InspectionEngine.$$$reportNull$$$0(42);
        }
        for (CommonProblemDescriptor common : commonProblemDescriptors) {
            if (common instanceof ProblemDescriptor) {
                descriptors.add((ProblemDescriptor)((ProblemDescriptor)common));
                continue;
            }
            ProblemDescriptorBase base = new ProblemDescriptorBase(element2, element2, common.getDescriptionTemplate(), (LocalQuickFix[])common.getFixes(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            descriptors.add(base);
        }
    }

    @NotNull
    public static List<LocalInspectionToolWrapper> filterToolsApplicableByLanguage(@NotNull Collection<? extends LocalInspectionToolWrapper> tools, @NotNull Set<String> elementDialectIds) {
        if (tools == null) {
            InspectionEngine.$$$reportNull$$$0(43);
        }
        if (elementDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(44);
        }
        HashMap resultsWithDialects = new HashMap();
        HashMap resultsNoDialects = new HashMap();
        List list2 = ContainerUtil.filter(tools, tool -> {
            String language2 = tool.getLanguage();
            if (language2 == null) {
                return true;
            }
            boolean applyToDialects = tool.applyToDialects();
            Map map2 = applyToDialects ? resultsWithDialects : resultsNoDialects;
            return map2.computeIfAbsent(language2, __ -> ContainerUtil.intersects((Collection)elementDialectIds, InspectionEngine.getDialectIdsSpecifiedForTool(language2, applyToDialects)));
        });
        if (list2 == null) {
            InspectionEngine.$$$reportNull$$$0(45);
        }
        return list2;
    }

    @NotNull
    private static Set<String> getDialectIdsSpecifiedForTool(@NotNull String langId, boolean applyToDialects) {
        Set<String> result2;
        Language language2;
        if (langId == null) {
            InspectionEngine.$$$reportNull$$$0(46);
        }
        if ((language2 = Language.findLanguageByID((String)langId)) == null) {
            result2 = Collections.singleton(langId);
        } else if (language2 instanceof MetaLanguage) {
            Collection matchingLanguages = ((MetaLanguage)language2).getMatchingLanguages();
            result2 = new HashSet<String>();
            for (Language matchingLanguage : matchingLanguages) {
                result2.addAll(InspectionEngine.getLanguageWithDialects(matchingLanguage, applyToDialects));
            }
        } else {
            result2 = InspectionEngine.getLanguageWithDialects(language2, applyToDialects);
        }
        Set<String> set2 = result2;
        if (set2 == null) {
            InspectionEngine.$$$reportNull$$$0(47);
        }
        return set2;
    }

    @NotNull
    private static Set<String> getLanguageWithDialects(@NotNull Language language2, boolean applyToDialects) {
        if (language2 == null) {
            InspectionEngine.$$$reportNull$$$0(48);
        }
        List dialects = language2.getDialects();
        if (!applyToDialects || dialects.isEmpty()) {
            Set<String> set2 = Collections.singleton(language2.getID());
            if (set2 == null) {
                InspectionEngine.$$$reportNull$$$0(49);
            }
            return set2;
        }
        HashSet<String> result2 = new HashSet<String>(1 + dialects.size());
        result2.add(language2.getID());
        InspectionEngine.addDialects(language2, result2);
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            InspectionEngine.$$$reportNull$$$0(50);
        }
        return hashSet;
    }

    private static void addDialects(@NotNull Language language2, @NotNull Set<? super String> result2) {
        if (language2 == null) {
            InspectionEngine.$$$reportNull$$$0(51);
        }
        if (result2 == null) {
            InspectionEngine.$$$reportNull$$$0(52);
        }
        for (Language dialect : language2.getDialects()) {
            if (!result2.add(dialect.getID())) continue;
            InspectionEngine.addDialects(dialect, result2);
        }
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> inside, @NotNull List<? extends PsiElement> outside) {
        if (inside == null) {
            InspectionEngine.$$$reportNull$$$0(53);
        }
        if (outside == null) {
            InspectionEngine.$$$reportNull$$$0(54);
        }
        HashSet<String> dialectIds = new HashSet<String>();
        HashSet processedLanguages = new HashSet();
        InspectionEngine.addDialects(inside, processedLanguages, dialectIds);
        InspectionEngine.addDialects(outside, processedLanguages, dialectIds);
        HashSet<String> hashSet = dialectIds;
        if (hashSet == null) {
            InspectionEngine.$$$reportNull$$$0(55);
        }
        return hashSet;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(56);
        }
        HashSet<String> dialectIds = new HashSet<String>();
        HashSet processedLanguages = new HashSet();
        InspectionEngine.addDialects(elements, processedLanguages, dialectIds);
        HashSet<String> hashSet = dialectIds;
        if (hashSet == null) {
            InspectionEngine.$$$reportNull$$$0(57);
        }
        return hashSet;
    }

    private static void addDialects(@NotNull List<? extends PsiElement> elements, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(58);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(59);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(60);
        }
        for (PsiElement psiElement : elements) {
            Language language2 = psiElement.getLanguage();
            outDialectIds.add(language2.getID());
            InspectionEngine.addDialects(language2, outProcessedLanguages, outDialectIds);
        }
    }

    private static void addDialects(@NotNull Language language2, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (language2 == null) {
            InspectionEngine.$$$reportNull$$$0(61);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(62);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(63);
        }
        if (outProcessedLanguages.add((Language)language2)) {
            for (Language dialect : language2.getDialects()) {
                outDialectIds.add(dialect.getID());
                InspectionEngine.addDialects(dialect, outProcessedLanguages, outDialectIds);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 15: 
            case 25: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 55: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 15: 
            case 25: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 55: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 9: 
            case 30: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 8: 
            case 15: 
            case 25: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionEngine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementVisitor";
                break;
            }
            case 11: 
            case 16: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 12: 
            case 17: 
            case 21: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 18: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iManager";
                break;
            }
            case 14: 
            case 19: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 31: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDialectIds";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionContext";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonProblemDescriptors";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langId";
                break;
            }
            case 48: 
            case 51: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outProcessedLanguages";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionEngine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitorAndAcceptElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "inspect";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectEx";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectElements";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "runInspectionOnFile";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "filterToolsApplicableByLanguage";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectIdsSpecifiedForTool";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageWithDialects";
                break;
            }
            case 55: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "calcElementDialectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitorAndAcceptElements";
                break;
            }
            case 4: 
            case 8: 
            case 15: 
            case 25: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 55: 
            case 57: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptElements";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "inspectEx";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "inspectElements";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "runInspectionOnFile";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "filterToolsApplicableByLanguage";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getDialectIdsSpecifiedForTool";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageWithDialects";
                break;
            }
            case 51: 
            case 52: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addDialects";
                break;
            }
            case 53: 
            case 54: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "calcElementDialectIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 15: 
            case 25: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 55: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

