/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(RunInspectionIntention.class);
    private final String myShortName;

    public RunInspectionIntention(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            RunInspectionIntention.$$$reportNull$$$0(0);
        }
        this.myShortName = key.toString();
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]);
        if (string == null) {
            RunInspectionIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            RunInspectionIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (project == null) {
            RunInspectionIntention.$$$reportNull$$$0(3);
        }
        return LocalInspectionToolWrapper.findTool2RunInBatch(project, (PsiElement)file2, this.myShortName) != null;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            RunInspectionIntention.$$$reportNull$$$0(4);
        }
        Module module = file2 != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) : null;
        AnalysisScope analysisScope = new AnalysisScope(project);
        if (file2 != null) {
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file2);
            VirtualFile virtualFile2 = topLevelFile.getVirtualFile();
            if (file2.isPhysical() && virtualFile2 != null && virtualFile2.isInLocalFileSystem()) {
                analysisScope = new AnalysisScope(topLevelFile);
            }
        }
        RunInspectionIntention.selectScopeAndRunInspection(this.myShortName, analysisScope, module, (PsiElement)file2, project);
    }

    public static void selectScopeAndRunInspection(@NotNull String toolShortName, @NotNull AnalysisScope customScope, @Nullable Module module, @Nullable PsiElement context2, @NotNull Project project) {
        if (toolShortName == null) {
            RunInspectionIntention.$$$reportNull$$$0(5);
        }
        if (customScope == null) {
            RunInspectionIntention.$$$reportNull$$$0(6);
        }
        if (project == null) {
            RunInspectionIntention.$$$reportNull$$$0(7);
        }
        List<ModelScopeItem> items = BaseAnalysisActionDialog.standardItems(project, customScope, module, context2);
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(CodeInsightBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0])}), CodeInsightBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project, items, AnalysisUIOptions.getInstance(project), true);
        if (!dlg.showAndGet()) {
            return;
        }
        customScope = dlg.getScope(customScope);
        InspectionToolWrapper<?, ?> wrapper2 = LocalInspectionToolWrapper.findTool2RunInBatch(project, context2, toolShortName);
        LOG.assertTrue(wrapper2 != null, (Object)("Can't find tool with name = \"" + toolShortName + "\""));
        RunInspectionIntention.rerunInspection(wrapper2, (InspectionManagerEx)InspectionManager.getInstance((Project)project), customScope, context2);
    }

    public static void rerunInspection(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @NotNull AnalysisScope scope2, @Nullable PsiElement psiElement) {
        if (toolWrapper == null) {
            RunInspectionIntention.$$$reportNull$$$0(8);
        }
        if (managerEx == null) {
            RunInspectionIntention.$$$reportNull$$$0(9);
        }
        if (scope2 == null) {
            RunInspectionIntention.$$$reportNull$$$0(10);
        }
        GlobalInspectionContextImpl inspectionContext = RunInspectionIntention.createContext(toolWrapper, managerEx, psiElement);
        inspectionContext.doInspections(scope2);
    }

    @NotNull
    public static GlobalInspectionContextImpl createContext(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement) {
        if (toolWrapper == null) {
            RunInspectionIntention.$$$reportNull$$$0(11);
        }
        if (managerEx == null) {
            RunInspectionIntention.$$$reportNull$$$0(12);
        }
        InspectionProfileImpl model2 = RunInspectionIntention.createProfile(toolWrapper, managerEx, psiElement);
        GlobalInspectionContextImpl inspectionContext = managerEx.createNewGlobalContext();
        inspectionContext.setExternalProfile(model2);
        GlobalInspectionContextImpl globalInspectionContextImpl = inspectionContext;
        if (globalInspectionContextImpl == null) {
            RunInspectionIntention.$$$reportNull$$$0(13);
        }
        return globalInspectionContextImpl;
    }

    @NotNull
    public static InspectionProfileImpl createProfile(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement) {
        if (toolWrapper == null) {
            RunInspectionIntention.$$$reportNull$$$0(14);
        }
        if (managerEx == null) {
            RunInspectionIntention.$$$reportNull$$$0(15);
        }
        Project project = managerEx.getProject();
        InspectionProfileImpl rootProfile = InspectionProfileManager.getInstance(project).getCurrentProfile();
        LinkedHashSet<InspectionToolWrapper> allWrappers = new LinkedHashSet<InspectionToolWrapper>();
        allWrappers.add(toolWrapper);
        rootProfile.collectDependentInspections(toolWrapper, allWrappers, project);
        ArrayList<InspectionToolWrapper<?, ?>> toolWrappers = allWrappers.size() == 1 ? Collections.singletonList((InspectionToolWrapper)allWrappers.iterator().next()) : new ArrayList(allWrappers);
        InspectionProfileImpl model2 = new InspectionProfileImpl(toolWrapper.getDisplayName(), (InspectionToolsSupplier)new InspectionToolsSupplier.Simple(toolWrappers), rootProfile);
        for (InspectionToolWrapper inspectionToolWrapper : toolWrappers) {
            model2.enableTool(inspectionToolWrapper.getShortName(), project);
        }
        try {
            Element element2 = new Element("toCopy");
            for (InspectionToolWrapper inspectionToolWrapper : toolWrappers) {
                InspectionToolWrapper<?, ?> tw;
                inspectionToolWrapper.getTool().writeSettings(element2);
                InspectionToolWrapper<?, ?> inspectionToolWrapper2 = tw = psiElement == null ? model2.getInspectionTool(inspectionToolWrapper.getShortName(), project) : model2.getInspectionTool(inspectionToolWrapper.getShortName(), psiElement);
                assert (tw != null);
                tw.getTool().readSettings(element2);
            }
        }
        catch (InvalidDataException | WriteExternalException throwable) {
            // empty catch block
        }
        model2.setSingleTool(toolWrapper.getShortName());
        InspectionProfileImpl inspectionProfileImpl = model2;
        if (inspectionProfileImpl == null) {
            RunInspectionIntention.$$$reportNull$$$0(16);
        }
        return inspectionProfileImpl;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/RunInspectionIntention";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolShortName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customScope";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerEx";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/RunInspectionIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectScopeAndRunInspection";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rerunInspection";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

