/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaVariableValue
extends DfaValue {
    @NotNull
    private final VariableDescriptor myDescriptor;
    @NotNull
    private final DfType myDfType;
    @Nullable
    private final DfaVariableValue myQualifier;
    private DfType myInherentType;
    private final List<DfaVariableValue> myDependents;

    private DfaVariableValue(@NotNull VariableDescriptor descriptor2, @NotNull DfaValueFactory factory2, @Nullable DfaVariableValue qualifier, @NotNull DfType type) {
        if (descriptor2 == null) {
            DfaVariableValue.$$$reportNull$$$0(0);
        }
        if (factory2 == null) {
            DfaVariableValue.$$$reportNull$$$0(1);
        }
        if (type == null) {
            DfaVariableValue.$$$reportNull$$$0(2);
        }
        super(factory2);
        this.myDependents = new SmartList();
        this.myDescriptor = descriptor2;
        this.myQualifier = qualifier;
        this.myDfType = type;
    }

    @Nullable
    public PsiElement getPsiVariable() {
        return this.myDescriptor.getPsiElement();
    }

    @NotNull
    public VariableDescriptor getDescriptor() {
        VariableDescriptor variableDescriptor = this.myDescriptor;
        if (variableDescriptor == null) {
            DfaVariableValue.$$$reportNull$$$0(3);
        }
        return variableDescriptor;
    }

    @Override
    public DfaVariableValue bindToFactory(@NotNull DfaValueFactory factory2) {
        if (factory2 == null) {
            DfaVariableValue.$$$reportNull$$$0(4);
        }
        return factory2.getVarFactory().createVariableValue(this.myDescriptor, this.myQualifier == null ? null : this.myQualifier.bindToFactory(factory2), (descriptor2, value2) -> this.myDfType);
    }

    @Override
    @NotNull
    public DfType getDfType() {
        DfType dfType = this.myDfType;
        if (dfType == null) {
            DfaVariableValue.$$$reportNull$$$0(5);
        }
        return dfType;
    }

    @Override
    public boolean dependsOn(DfaVariableValue other) {
        return other == this || this.myQualifier != null && this.myQualifier.dependsOn(other);
    }

    @NotNull
    public List<DfaVariableValue> getDependentVariables() {
        List<DfaVariableValue> list2 = this.myDependents;
        if (list2 == null) {
            DfaVariableValue.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public int getDepth() {
        int depth = 0;
        for (DfaVariableValue qualifier = this.getQualifier(); qualifier != null; qualifier = qualifier.getQualifier()) {
            ++depth;
        }
        return depth;
    }

    @NotNull
    @Contract(pure=true)
    public DfaVariableValue withQualifier(DfaVariableValue newQualifier) {
        DfaVariableValue dfaVariableValue = newQualifier == this.myQualifier ? this : this.myFactory.getVarFactory().createVariableValue(this.myDescriptor, newQualifier);
        if (dfaVariableValue == null) {
            DfaVariableValue.$$$reportNull$$$0(7);
        }
        return dfaVariableValue;
    }

    public String toString() {
        return (String)(this.myQualifier == null ? "" : this.myQualifier + ".") + this.myDescriptor;
    }

    @Nullable
    public DfaVariableValue getQualifier() {
        return this.myQualifier;
    }

    public DfType getInherentType() {
        if (this.myInherentType == null) {
            this.myInherentType = this.myDescriptor.getInitialDfType(this, this.getFactory().getContext());
        }
        return this.myInherentType;
    }

    void resetInherentType() {
        this.myInherentType = null;
    }

    public boolean isFlushableByCalls() {
        return !this.myDescriptor.isStable() || this.myQualifier != null && this.myQualifier.isFlushableByCalls();
    }

    public boolean canBeCapturedInClosure() {
        return !this.myDescriptor.canBeCapturedInClosure() || this.myQualifier != null && this.myQualifier.canBeCapturedInClosure();
    }

    public boolean containsCalls() {
        return this.myDescriptor.isCall() || this.myQualifier != null && this.myQualifier.containsCalls();
    }

    public boolean alwaysEqualsToItself(@NotNull DfType type) {
        if (type == null) {
            DfaVariableValue.$$$reportNull$$$0(8);
        }
        return this.myDescriptor.alwaysEqualsToItself(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentVariables";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToFactory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "alwaysEqualsToItself";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory {
        private final Map<Pair<VariableDescriptor, DfaVariableValue>, DfaVariableValue> myExistingVars = new HashMap<Pair<VariableDescriptor, DfaVariableValue>, DfaVariableValue>();
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory2) {
            this.myFactory = factory2;
        }

        @NotNull
        public DfaVariableValue createVariableValue(@NotNull VariableDescriptor descriptor2) {
            if (descriptor2 == null) {
                Factory.$$$reportNull$$$0(0);
            }
            DfaVariableValue dfaVariableValue = this.createVariableValue(descriptor2, null);
            if (dfaVariableValue == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return dfaVariableValue;
        }

        @NotNull
        public DfaVariableValue createVariableValue(@NotNull VariableDescriptor descriptor2, @Nullable DfaVariableValue qualifier) {
            if (descriptor2 == null) {
                Factory.$$$reportNull$$$0(2);
            }
            DfaVariableValue dfaVariableValue = this.createVariableValue(descriptor2, qualifier, VariableDescriptor::getDfType);
            if (dfaVariableValue == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return dfaVariableValue;
        }

        @Nullable
        public DfaVariableValue getVariableValue(@NotNull VariableDescriptor descriptor2, @Nullable DfaVariableValue qualifier) {
            if (descriptor2 == null) {
                Factory.$$$reportNull$$$0(4);
            }
            Pair key = Pair.create((Object)descriptor2, (Object)qualifier);
            return this.myExistingVars.get(key);
        }

        @NotNull
        DfaVariableValue createVariableValue(@NotNull VariableDescriptor descriptor2, @Nullable DfaVariableValue qualifier, @NotNull @NotNull BiFunction<? super @NotNull VariableDescriptor, ? super @Nullable DfaVariableValue, @NotNull DfType> typeSupplier) {
            Pair key;
            DfaVariableValue var;
            if (descriptor2 == null) {
                Factory.$$$reportNull$$$0(5);
            }
            if (typeSupplier == null) {
                Factory.$$$reportNull$$$0(6);
            }
            if ((var = this.myExistingVars.get(key = Pair.create((Object)descriptor2, (Object)qualifier))) == null) {
                var = new DfaVariableValue(descriptor2, this.myFactory, qualifier, typeSupplier.apply(descriptor2, qualifier));
                this.myExistingVars.put((Pair<VariableDescriptor, DfaVariableValue>)key, var);
                while (qualifier != null) {
                    qualifier.myDependents.add(var);
                    qualifier = qualifier.getQualifier();
                }
            }
            DfaVariableValue dfaVariableValue = var;
            if (dfaVariableValue == null) {
                Factory.$$$reportNull$$$0(7);
            }
            return dfaVariableValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeSupplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createVariableValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createVariableValue";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariableValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

