/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlainTextFormatter
implements InspectionsReportConverter {
    public static final String NAME = "plain";
    private static final String FILE_ELEMENT = "file";
    private static final String LINE_ELEMENT = "line";
    private static final String PROBLEM_ELEMENT = "problem";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String PROBLEM_CLASS_ELEMENT = "problem_class";
    private static final String SEVERITY_ATTRIBUTE = "severity";

    public String getFormatName() {
        return NAME;
    }

    public boolean useTmpDirForRawData() {
        return true;
    }

    public void convert(@NotNull String rawDataDirectoryPath, @Nullable String outputPath, @NotNull Map<String, Tools> tools, @NotNull List<? extends File> inspectionsResults) throws InspectionsReportConverter.ConversionException {
        Writer w;
        Transformer transformer;
        if (rawDataDirectoryPath == null) {
            PlainTextFormatter.$$$reportNull$$$0(0);
        }
        if (tools == null) {
            PlainTextFormatter.$$$reportNull$$$0(1);
        }
        if (inspectionsResults == null) {
            PlainTextFormatter.$$$reportNull$$$0(2);
        }
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        try (InputStream descrExtractorXsltStream = this.getClass().getResourceAsStream("description-text.xsl");){
            StreamSource xslSource = new StreamSource(descrExtractorXsltStream);
            transformer = transformerFactory.newTransformer(xslSource);
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot find inspection descriptions converter.");
        }
        catch (TransformerConfigurationException e) {
            throw new InspectionsReportConverter.ConversionException("Fail to load inspection descriptions converter.");
        }
        if (outputPath != null) {
            File outputFile = new File(outputPath);
            try {
                w = new FileWriter(outputFile);
            }
            catch (IOException iOException) {
                throw new InspectionsReportConverter.ConversionException("Cannot edit file: " + outputFile.getPath());
            }
        } else {
            w = new PrintWriter(System.out);
        }
        try {
            for (File file2 : inspectionsResults) {
                if (file2.isDirectory()) {
                    this.warn("Folder isn't expected here: " + file2.getName());
                    continue;
                }
                String fileNameWithoutExt = FileUtilRt.getNameWithoutExtension((String)file2.getName());
                if (".descriptions".equals(fileNameWithoutExt) || fileNameWithoutExt.endsWith("_aggregate")) continue;
                InspectionToolWrapper toolWrapper = tools.get(fileNameWithoutExt).getTool();
                w.append(this.getToolPresentableName(toolWrapper)).append("\n");
                this.writeInspectionDescription(w, toolWrapper, transformer);
                w.append("\n");
                SAXBuilder builder2 = new SAXBuilder();
                try {
                    Document doc = builder2.build(file2);
                    Element root2 = doc.getRootElement();
                    List problems = root2.getChildren(PROBLEM_ELEMENT);
                    int maxFileColonLineLength = this.getMaxFileColonLineNumLength(file2, toolWrapper, problems);
                    for (Object problem : problems) {
                        Element fileElement = ((Element)problem).getChild(FILE_ELEMENT);
                        String filePath = this.getPath(fileElement);
                        if (this.resultsIgnored(file2, toolWrapper)) continue;
                        Element lineElement = ((Element)problem).getChild(LINE_ELEMENT);
                        Element problemDescrElement = ((Element)problem).getChild(DESCRIPTION_ELEMENT);
                        String severity = ((Element)problem).getChild(PROBLEM_CLASS_ELEMENT).getAttributeValue(SEVERITY_ATTRIBUTE);
                        String fileLineNum = lineElement.getText();
                        w.append("  ").append(filePath).append(':').append(fileLineNum);
                        for (int i2 = maxFileColonLineLength - 1 - filePath.length() - fileLineNum.length() + 4; i2 >= 0; --i2) {
                            w.append(' ');
                        }
                        w.append("[").append(severity).append("] ");
                        w.append(problemDescrElement.getText()).append('\n');
                    }
                }
                catch (JDOMException e) {
                    throw new InspectionsReportConverter.ConversionException("Unknown results format, file = " + file2.getPath() + ". Error: " + e.getMessage());
                }
                w.append("\n");
            }
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot write inspection results: " + e.getMessage());
        }
        finally {
            try {
                w.close();
            }
            catch (IOException e) {
                this.warn("Cannot save inspection results: " + e.getMessage());
            }
        }
    }

    private int getMaxFileColonLineNumLength(@NotNull File inspectionResultData, @NotNull InspectionToolWrapper toolWrapper, @NotNull List problems) {
        if (inspectionResultData == null) {
            PlainTextFormatter.$$$reportNull$$$0(3);
        }
        if (toolWrapper == null) {
            PlainTextFormatter.$$$reportNull$$$0(4);
        }
        if (problems == null) {
            PlainTextFormatter.$$$reportNull$$$0(5);
        }
        int maxFileColonLineLength = 0;
        for (Object problem : problems) {
            Element fileElement = ((Element)problem).getChild(FILE_ELEMENT);
            Element lineElement = ((Element)problem).getChild(LINE_ELEMENT);
            String filePath = this.getPath(fileElement);
            if (this.resultsIgnored(inspectionResultData, toolWrapper)) continue;
            maxFileColonLineLength = Math.max(maxFileColonLineLength, filePath.length() + 1 + lineElement.getText().length());
        }
        return maxFileColonLineLength;
    }

    private void warn(String msg) {
        System.err.println(msg);
    }

    private boolean resultsIgnored(@NotNull File file2, @NotNull InspectionToolWrapper toolWrapper) {
        if (file2 == null) {
            PlainTextFormatter.$$$reportNull$$$0(6);
        }
        if (toolWrapper == null) {
            PlainTextFormatter.$$$reportNull$$$0(7);
        }
        return false;
    }

    @NotNull
    private String getPath(@NotNull Element fileElement) {
        if (fileElement == null) {
            PlainTextFormatter.$$$reportNull$$$0(8);
        }
        String string = fileElement.getText().replace("file://$PROJECT_DIR$", ".");
        if (string == null) {
            PlainTextFormatter.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void writeInspectionDescription(@NotNull Writer w, @NotNull InspectionToolWrapper toolWrapper, @NotNull Transformer transformer) throws IOException, InspectionsReportConverter.ConversionException {
        if (w == null) {
            PlainTextFormatter.$$$reportNull$$$0(10);
        }
        if (toolWrapper == null) {
            PlainTextFormatter.$$$reportNull$$$0(11);
        }
        if (transformer == null) {
            PlainTextFormatter.$$$reportNull$$$0(12);
        }
        StringWriter descrWriter = new StringWriter();
        String descr = toolWrapper.loadDescription();
        if (descr == null) {
            return;
        }
        descr = descr.replace("<br>", "<br/>");
        try {
            transformer.transform(new StreamSource(new StringReader(descr)), new StreamResult(descrWriter));
        }
        catch (TransformerException e) {
            this.warn("ERROR:  Cannot load description for inspection: " + this.getToolPresentableName(toolWrapper) + ".\n        Error message: " + e.getMessage());
            return;
        }
        String trimmedDesc = descrWriter.toString().trim();
        String[] descLines = StringUtil.splitByLines((String)trimmedDesc);
        if (descLines.length > 0) {
            for (String descLine : descLines) {
                w.append("  ").append(descLine.trim()).append("\n");
            }
        }
    }

    @NotNull
    private String getToolPresentableName(@NotNull InspectionToolWrapper toolWrapper) throws IOException {
        if (toolWrapper == null) {
            PlainTextFormatter.$$$reportNull$$$0(13);
        }
        StringBuilder buff = new StringBuilder();
        buff.append(toolWrapper.getDisplayName()).append(" (");
        String[] groupPath = toolWrapper.getGroupPath();
        int groupPathLength = groupPath.length;
        for (int i2 = 0; i2 < groupPathLength; ++i2) {
            if (i2 != 0) {
                buff.append(" | ");
            }
            buff.append(groupPath[i2]);
        }
        buff.append(")");
        String string = buff.toString();
        if (string == null) {
            PlainTextFormatter.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawDataDirectoryPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionResultData";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_ELEMENT;
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElement";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/PlainTextFormatter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/PlainTextFormatter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMaxFileColonLineNumLength";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resultsIgnored";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 9: 
            case 14: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeInspectionDescription";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getToolPresentableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

