/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionViewNavigationPanel;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectionResultsViewUtil {
    static void releaseEditor(@Nullable Editor editor2) {
        if (editor2 != null && !editor2.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(editor2);
        }
    }

    @Nullable
    static Navigatable getNavigatableForInvalidNode(ProblemDescriptionNode node2) {
        PsiFile containingFile;
        RefEntity element2;
        for (element2 = node2.getElement(); element2 != null && !element2.isValid(); element2 = element2.getOwner()) {
        }
        if (!(element2 instanceof RefElement)) {
            return null;
        }
        PsiElement containingElement = ((RefElement)element2).getPsiElement();
        if (!(containingElement instanceof NavigatablePsiElement) || !containingElement.isValid()) {
            return null;
        }
        int lineNumber = node2.getLineNumber();
        if (lineNumber != -1 && (containingFile = containingElement.getContainingFile()) != null) {
            VirtualFile file2 = containingFile.getVirtualFile();
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document != null && document.getLineCount() > lineNumber) {
                return new OpenFileDescriptor(containingElement.getProject(), file2, lineNumber, 0);
            }
        }
        return (Navigatable)containingElement;
    }

    @NotNull
    static JLabel getNothingToShowTextLabel() {
        return InspectionResultsViewUtil.createLabelForText(InspectionViewNavigationPanel.getTitleText(false));
    }

    @NotNull
    static JComponent getInvalidEntityLabel(@NotNull RefEntity entity) {
        if (entity == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(0);
        }
        String name2 = entity.getName();
        return InspectionResultsViewUtil.createLabelForText(InspectionsBundle.message((String)"inspections.view.invalid.label", (Object[])new Object[]{name2}));
    }

    public static JComponent getPreviewIsNotAvailable(@NotNull RefEntity entity) {
        if (entity == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(1);
        }
        String name2 = entity.getQualifiedName();
        return InspectionResultsViewUtil.createLabelForText(InspectionsBundle.message((String)"inspections.view.no.preview.label", (Object[])new Object[]{name2}));
    }

    @NotNull
    static JComponent getApplyingFixLabel(@NotNull InspectionToolWrapper wrapper2) {
        if (wrapper2 == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(2);
        }
        return InspectionResultsViewUtil.createLabelForText(InspectionsBundle.message((String)"inspections.view.applying.quick.label", (Object[])new Object[]{wrapper2.getDisplayName()}));
    }

    @NotNull
    static JLabel createLabelForText(@Nls String text2) {
        JBLabel multipleSelectionLabel = new JBLabel(text2);
        multipleSelectionLabel.setVerticalAlignment(1);
        multipleSelectionLabel.setBorder((Border)JBUI.Borders.empty((int)16, (int)12, (int)0, (int)0));
        JBLabel jBLabel = multipleSelectionLabel;
        if (jBLabel == null) {
            InspectionResultsViewUtil.$$$reportNull$$$0(3);
        }
        return jBLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionResultsViewUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionResultsViewUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelForText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidEntityLabel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewIsNotAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getApplyingFixLabel";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

