/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.services;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.util.Url;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\\\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b26\u0010\n\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u00050\u000bJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0012\u001a\u00020\u0013JV\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u001326\u0010\n\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u0002H\u00050\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirerHttp;", "", "()V", "convertToAcquireCredentialsResult", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer$AcquireCredentialsResult;", "T", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "httpResponse", "Ljava/net/http/HttpResponse;", "", "credentialsProvider", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "body", "Ljava/net/http/HttpHeaders;", "headers", "requestToken", "url", "Lcom/intellij/util/Url;", "intellij.platform.collaborationTools.auth"})
public final class OAuthCredentialsAcquirerHttp {
    @NotNull
    public static final OAuthCredentialsAcquirerHttp INSTANCE;

    @NotNull
    public final <T extends Credentials> OAuthCredentialsAcquirer.AcquireCredentialsResult<T> requestToken(@NotNull Url url, @NotNull Function2<? super String, ? super HttpHeaders, ? extends T> credentialsProvider) {
        HttpResponse<String> httpResponse;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        try {
            httpResponse = this.requestToken(url);
        }
        catch (IOException e) {
            return new OAuthCredentialsAcquirer.AcquireCredentialsResult.Error("Cannot exchange token: " + e.getMessage());
        }
        HttpResponse<String> response = httpResponse;
        return this.convertToAcquireCredentialsResult(response, (Function2)new Function2<String, HttpHeaders, T>(credentialsProvider){
            final /* synthetic */ Function2 $credentialsProvider;

            @NotNull
            public final T invoke(@NotNull String body, @NotNull HttpHeaders headers) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
                return (T)((Credentials)this.$credentialsProvider.invoke((Object)body, (Object)headers));
            }
            {
                this.$credentialsProvider = function2;
                super(2);
            }
        });
    }

    @NotNull
    public final HttpResponse<String> requestToken(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toExternalForm()");
        String tokenUrl = string;
        HttpClient client2 = HttpClient.newHttpClient();
        HttpRequest request2 = HttpRequest.newBuilder().uri(URI.create(tokenUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<String> httpResponse = client2.send(request2, HttpResponse.BodyHandlers.ofString());
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"client.send(request, Htt\u2026.BodyHandlers.ofString())");
        return httpResponse;
    }

    @NotNull
    public final <T extends Credentials> OAuthCredentialsAcquirer.AcquireCredentialsResult<T> convertToAcquireCredentialsResult(@NotNull HttpResponse<String> httpResponse, @NotNull Function2<? super String, ? super HttpHeaders, ? extends T> credentialsProvider) {
        OAuthCredentialsAcquirer.AcquireCredentialsResult acquireCredentialsResult;
        Intrinsics.checkNotNullParameter(httpResponse, (String)"httpResponse");
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        if (httpResponse.statusCode() == 200) {
            String string = httpResponse.body();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"httpResponse.body()");
            HttpHeaders httpHeaders = httpResponse.headers();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"httpResponse.headers()");
            Credentials creds = (Credentials)credentialsProvider.invoke((Object)string, (Object)httpHeaders);
            acquireCredentialsResult = new OAuthCredentialsAcquirer.AcquireCredentialsResult.Success<Credentials>(creds);
        } else {
            CharSequence charSequence;
            CharSequence charSequence2 = httpResponse.body();
            boolean bl = false;
            CharSequence charSequence3 = charSequence2;
            boolean bl2 = false;
            if (charSequence3.length() == 0) {
                boolean bl3 = false;
                String string = "No token provided";
                charSequence = string;
            } else {
                charSequence = charSequence2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"httpResponse.body().ifEm\u2026y { \"No token provided\" }");
            String string = (String)charSequence;
            acquireCredentialsResult = new OAuthCredentialsAcquirer.AcquireCredentialsResult.Error(string);
        }
        return acquireCredentialsResult;
    }

    private OAuthCredentialsAcquirerHttp() {
    }

    static {
        OAuthCredentialsAcquirerHttp oAuthCredentialsAcquirerHttp;
        INSTANCE = oAuthCredentialsAcquirerHttp = new OAuthCredentialsAcquirerHttp();
    }
}

