/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialog;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.FileSpec;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0014J4\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00140\u00122\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00140\u0012H\u0002J\u001a\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00140\u0012H\u0014J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/configurationStore/ExportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "exists", "", "item", "Lcom/intellij/configurationStore/ExportableItem;", "exportSettings", "saveFile", "Ljava/nio/file/Path;", "markedComponents", "", "filterExisting", "", "Lcom/intellij/configurationStore/FileSpec;", "", "exportableComponents", "getExportableComponents", "update", "intellij.platform.configurationStore.impl"})
public class ExportSettingsAction
extends AnAction
implements DumbAware {
    @NotNull
    protected Map<FileSpec, List<ExportableItem>> getExportableComponents() {
        return this.filterExisting(ExportSettingsActionKt.getExportableComponentsMap$default(true, null, false, 6, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportSettings(@NotNull Path saveFile, @NotNull Set<ExportableItem> markedComponents) {
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        Intrinsics.checkNotNullParameter(markedComponents, (String)"markedComponents");
        Closeable closeable = PathKt.outputStream$default((Path)saveFile, (boolean)false, (int)1, null);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl3 = false;
            ExportSettingsActionKt.exportSettings$default(markedComponents, it, null, null, 12, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ApplicationManager.getApplication().saveSettings();
        Map<FileSpec, List<ExportableItem>> map2 = this.getExportableComponents();
        String string = ConfigurationStoreBundle.message("title.select.components.to.export", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ConfigurationStoreBundle\u2026ct.components.to.export\")");
        String string2 = ConfigurationStoreBundle.message("prompt.please.check.all.components.to.export", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ConfigurationStoreBundle\u2026ll.components.to.export\")");
        ChooseComponentsToExportDialog dialog2 = new ChooseComponentsToExportDialog(map2, true, string, string2);
        if (!dialog2.showAndGet()) {
            return;
        }
        Set<ExportableItem> markedComponents = dialog2.getExportableComponents$intellij_platform_configurationStore_impl();
        if (markedComponents.isEmpty()) {
            return;
        }
        Path saveFile = dialog2.getExportFile$intellij_platform_configurationStore_impl();
        try {
            if (PathKt.exists((Path)saveFile)) {
                String string3 = IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IdeBundle.message(\"title.file.already.exists\")");
                String string4 = ConfigurationStoreBundle.message("prompt.overwrite.settings.file", ((Object)saveFile).toString());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ConfigurationStoreBundle\u2026le\", saveFile.toString())");
                String string5 = IdeBundle.message((String)"action.overwrite", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"IdeBundle.message(\"action.overwrite\")");
                if (MessageUtil.showOkCancelDialog$default((String)string3, (String)string4, (String)string5, null, (Icon)Messages.getWarningIcon(), null, null, (int)104, null) != 0) {
                    return;
                }
            }
            this.exportSettings(saveFile, markedComponents);
            RevealFileAction.showDialog(AnAction.getEventProject((AnActionEvent)e), ConfigurationStoreBundle.message("message.settings.exported.successfully", new Object[0]), ConfigurationStoreBundle.message("title.export.successful", new Object[0]), saveFile.toFile(), null);
        }
        catch (IOException e2) {
            Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.writing.settings", e2.toString()), (String)IdeBundle.message((String)"title.error.writing.file", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<FileSpec, List<ExportableItem>> filterExisting(Map<FileSpec, ? extends List<ExportableItem>> exportableComponents) {
        void $this$mapNotNullTo$iv$iv;
        Map<FileSpec, ? extends List<ExportableItem>> $this$mapNotNull$iv = exportableComponents;
        boolean $i$f$mapNotNull = false;
        Map<FileSpec, ? extends List<ExportableItem>> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_9 = $this$forEach$iv$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var9_9.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            void fileSpec;
            void $this$filterTo$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry $dstr$fileSpec$items = element$iv$iv;
            boolean bl3 = false;
            Map.Entry entry2 = $dstr$fileSpec$items;
            boolean bl4 = false;
            FileSpec fileSpec2 = (FileSpec)entry2.getKey();
            entry2 = $dstr$fileSpec$items;
            bl4 = false;
            List items = (List)entry2.getValue();
            Iterable $this$filter$iv = items;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                ExportableItem it = (ExportableItem)element$iv$iv2;
                boolean bl5 = false;
                if (!this.exists(it)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List existingItems = (List)destination$iv$iv2;
            if ((existingItems.isEmpty() ? null : TuplesKt.to((Object)fileSpec, (Object)existingItems)) == null) continue;
            pair = pair;
            boolean bl6 = false;
            boolean bl7 = false;
            Pair it$iv$iv = pair;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final boolean exists(ExportableItem item) {
        if (item.getFileSpec().isDirectory()) {
            return ExportSettingsActionKt.access$checkIfDirectoryExists(item, ExportSettingsActionKt.access$getAppStorageManager());
        }
        byte[] content2 = ExportSettingsActionKt.access$loadFileContent(item, ExportSettingsActionKt.access$getAppStorageManager());
        return content2 != null && ExportSettingsActionKt.access$isComponentDefined(item.getComponentName(), content2);
    }
}

