/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.schemeManager.SchemeChangeApplicator;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.ui.AppUIUtil;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\n\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011\u001a\u001e\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u000b\u001a\u00020\u0003H\u0000\u001a+\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u001d*\b\u0012\u0004\u0012\u0002H\u001c0\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 \"&\u0010\u0000\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"6\u0010\u0006\u001a*\u0012&\u0012$\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"CHANGED_FILES_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "", "Lcom/intellij/openapi/components/StateStorage;", "CHANGED_SCHEMES_KEY", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeApplicator;", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "askToRestart", "", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "notReloadableComponents", "", "", "changedStorages", "", "isApp", "doReloadProject", "", "project", "Lcom/intellij/openapi/project/Project;", "reloadAppStore", "changes", "reloadStore", "Lcom/intellij/configurationStore/ReloadComponentStoreStatus;", "getAndClear", "T", "", "holder", "Lcom/intellij/openapi/util/UserDataHolderEx;", "(Lcom/intellij/openapi/util/Key;Lcom/intellij/openapi/util/UserDataHolderEx;)Ljava/lang/Object;", "intellij.platform.configurationStore.impl"})
public final class StoreReloadManagerImplKt {
    private static final Key<Map<ComponentStoreImpl, Set<StateStorage>>> CHANGED_FILES_KEY = new Key("CHANGED_FILES_KEY");
    private static final Key<Map<SchemeChangeApplicator<?, ?>, Set<SchemeChangeEvent<?, ?>>>> CHANGED_SCHEMES_KEY = new Key("CHANGED_SCHEMES_KEY");

    public static final boolean reloadAppStore(@NotNull Set<? extends StateStorage> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)application);
        if (iComponentStore == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        ReloadComponentStoreStatus status = StoreReloadManagerImplKt.reloadStore(changes, (ComponentStoreImpl)iComponentStore);
        if (status == ReloadComponentStoreStatus.RESTART_AGREED) {
            ApplicationManagerEx.getApplicationEx().restart(true);
            return false;
        }
        return status == ReloadComponentStoreStatus.SUCCESS || status == ReloadComponentStoreStatus.RESTART_CANCELLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ReloadComponentStoreStatus reloadStore(@NotNull Set<? extends StateStorage> changedStorages, @NotNull ComponentStoreImpl store) {
        boolean willBeReloaded;
        Collection<String> notReloadableComponents;
        block11: {
            Intrinsics.checkNotNullParameter(changedStorages, (String)"changedStorages");
            Intrinsics.checkNotNullParameter((Object)store, (String)"store");
            notReloadableComponents = null;
            willBeReloaded = false;
            try {
                notReloadableComponents = store.reload(changedStorages);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().warn(e);
                AppUIUtil.invokeOnEdt(new Runnable(e){
                    final /* synthetic */ Throwable $e;

                    public final void run() {
                        Messages.showWarningDialog((String)ConfigurationStoreBundle.message("project.reload.failed", this.$e.getMessage()), (String)ConfigurationStoreBundle.message("project.reload.failed.title", new Object[0]));
                    }
                    {
                        this.$e = throwable;
                    }
                });
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
                return reloadComponentStoreStatus;
            }
            if (notReloadableComponents != null && !notReloadableComponents.isEmpty()) break block11;
            ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
            for (StateStorage stateStorage : changedStorages) {
                if (!(stateStorage instanceof StateStorageBase)) continue;
                ((StateStorageBase)stateStorage).enableSaving();
            }
            return reloadComponentStoreStatus;
        }
        try {
            willBeReloaded = StoreReloadManagerImplKt.askToRestart(store, notReloadableComponents, changedStorages, store.getProject() == null);
            ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
            return reloadComponentStoreStatus;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (!willBeReloaded) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
            }
        }
    }

    public static final boolean askToRestart(@NotNull IComponentStore store, @NotNull Collection<String> notReloadableComponents, @Nullable Set<? extends StateStorage> changedStorages, boolean isApp) {
        String string;
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter(notReloadableComponents, (String)"notReloadableComponents");
        String string2 = store instanceof IProjectStore ? ConfigurationStoreBundle.message("configuration.project.files.changed.message.start", ((IProjectStore)store).getProjectName()) : ConfigurationStoreBundle.message("configuration.application.files.changed.message.start", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (store is IProjectSto\u2026anged.message.start\")\n  }");
        String firstMessage = string2;
        String string3 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)notReloadableComponents, (int)10), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        boolean bl2 = false;
        String string4 = string3;
        boolean bl3 = false;
        String string5 = notReloadableComponents.size() > 10 ? ConfigurationStoreBundle.message("configuration.project.components.changed.and.several.more", string4, notReloadableComponents.size() - 10) : string4;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"notReloadableComponents.\u2026else {\n      it\n    }\n  }");
        String nonReloadableComponentsJoined = string5;
        if (isApp) {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            String productName = applicationNamesInfo.getProductName();
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            string = application.isRestartCapable() ? ConfigurationStoreBundle.message("configuration.project.files.changed.restart.proposal", productName) : ConfigurationStoreBundle.message("configuration.project.files.changed.shutdown.proposal", productName);
        } else {
            string = ConfigurationStoreBundle.message("configuration.project.files.changed.reload.project.proposal", new Object[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (isApp) {\n    val pro\u2026ad.project.proposal\")\n  }");
        String question = string;
        String message2 = StringsKt.trimIndent((String)("\n    " + firstMessage + "\n\n    " + nonReloadableComponentsJoined + "\n    " + question + "\n  "));
        String string6 = store instanceof IProjectStore ? ConfigurationStoreBundle.message("configuration.project.files.changed.restart.prompt.title", ((IProjectStore)store).getProjectName()) : ConfigurationStoreBundle.message("configuration.application.files.changed.restart.prompt.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"if (store is IProjectSto\u2026ed.restart.prompt.title\")");
        String title2 = string6;
        if (Messages.showYesNoDialog((String)message2, (String)title2, (Icon)Messages.getQuestionIcon()) != 0) {
            return false;
        }
        if (changedStorages != null) {
            for (StateStorage stateStorage : changedStorages) {
                if (!(stateStorage instanceof StateStorageBase)) continue;
                ((StateStorageBase)stateStorage).disableSaving();
            }
        }
        return true;
    }

    private static final <T> T getAndClear(Key<T> $this$getAndClear, UserDataHolderEx holder) {
        Object object = holder.getUserData($this$getAndClear);
        if (object == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"holder.getUserData(this) ?: return null");
        Object value2 = object;
        holder.replace($this$getAndClear, value2, null);
        return (T)value2;
    }

    private static final void doReloadProject(Project project) {
        Ref projectRef = Ref.create((Object)project);
        ProjectReloadState.getInstance((Project)project).onBeforeAutomaticProjectReload();
        AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().submit(new Runnable(projectRef){
            final /* synthetic */ Ref $projectRef;

            public final void run() {
                ComponentStoreImplKt.getLOG().debug("Reloading project.");
                Project project1 = (Project)this.$projectRef.get();
                this.$projectRef.set(null);
                Project project = project1;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project1");
                if (project.isDisposed()) {
                    return;
                }
                String string = project1.getPresentableUrl();
                Intrinsics.checkNotNull((Object)string);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project1.presentableUrl!!");
                String presentableUrl = string;
                if (!ProjectManagerEx.getInstanceEx().closeAndDispose(project1)) {
                    return;
                }
                ProjectManagerEx.getInstanceEx().openProject(Paths.get(presentableUrl, new String[0]), new OpenProjectTask(false, null, false, false, null, null, false, null, null, 0, 0, false, false, false, null, false, false, null, null, null, 1048575, null));
            }
            {
                this.$projectRef = ref;
            }
        });
    }

    public static final /* synthetic */ Key access$getCHANGED_FILES_KEY$p() {
        return CHANGED_FILES_KEY;
    }

    public static final /* synthetic */ void access$doReloadProject(Project project) {
        StoreReloadManagerImplKt.doReloadProject(project);
    }

    public static final /* synthetic */ Key access$getCHANGED_SCHEMES_KEY$p() {
        return CHANGED_SCHEMES_KEY;
    }

    public static final /* synthetic */ Object access$getAndClear(Key $this$access_u24getAndClear, UserDataHolderEx holder) {
        return StoreReloadManagerImplKt.getAndClear($this$access_u24getAndClear, holder);
    }
}

